/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.GradientPaintExtContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class GradientPaintExt
implements Paint {
    private Point2D start;
    private Point2D end;
    private double[] I;
    private Color[] colors;
    private int transparency;
    private boolean cyclic;

    public Color[] getColors() {
        Color[] colors = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colors, 0, this.colors.length);
        return colors;
    }

    public double[] getIntervals() {
        double[] I = new double[this.I.length];
        System.arraycopy(this.I, 0, I, 0, this.I.length);
        return I;
    }

    public double[] getStopPoints() {
        double fSum = 0.0;
        for (int i = 0; i < this.I.length; ++i) {
            fSum += this.I[i];
        }
        double[] p = new double[this.I.length];
        p[0] = this.I[0];
        for (int i = 1; i < this.I.length; ++i) {
            p[i] = p[i - 1] + this.I[i];
        }
        if (FP.nonzero(fSum - 1.0)) {
            double dd = 1.0 / fSum;
            int i = 0;
            while (i < this.I.length) {
                int n = i++;
                p[n] = p[n] * dd;
            }
        }
        return p;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public final Point2D getStart() {
        return (Point2D)this.start.clone();
    }

    public final Point2D getEnd() {
        return (Point2D)this.end.clone();
    }

    public GradientPaintExt(double x, double y, double dx, double dy, double[] I, Color[] colors) {
        this(x, y, dx, dy, I, colors, false);
    }

    public GradientPaintExt(double x, double y, double dx, double dy, double[] I, Color[] colors, boolean cyclic) {
        this(new Point2D.Double(x, y), new Point2D.Double(dx, dy), I, colors, cyclic);
    }

    public GradientPaintExt(Point2D start, Point2D end, double[] I, Color[] colors) {
        this(start, end, I, colors, false);
    }

    public GradientPaintExt(Point2D start, Point2D end, double[] I, Color[] colors, boolean cyclic) {
        int i;
        if (start == null || end == null || start.equals(end) || I == null || colors == null || I.length != colors.length - 1 || colors.length < 2) {
            throw new IllegalArgumentException();
        }
        this.cyclic = cyclic;
        this.start = new Point2D.Double(start.getX(), start.getY());
        this.end = new Point2D.Double(end.getX(), end.getY());
        double[] temp = new double[I.length];
        System.arraycopy(I, 0, temp, 0, I.length);
        I = temp;
        double sum = 0.0;
        for (i = 0; i < I.length; ++i) {
            if (I[i] < 0.0) {
                throw new IllegalArgumentException("Cannot use negative interval: " + I[i]);
            }
            sum += I[i];
        }
        if (sum < FP.TOLERANCE) {
            throw new IllegalArgumentException("No stop points defined , except zero.");
        }
        i = 0;
        while (i < I.length) {
            int n = i++;
            I[n] = I[n] / sum;
        }
        this.I = I;
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
        boolean opaque = true;
        for (int i2 = 0; i2 < colors.length; ++i2) {
            opaque = opaque && colors[i2].getAlpha() == 255;
        }
        this.transparency = opaque ? 1 : 3;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new GradientPaintExtContext(this.start, this.end, this.I, this.colors, transform, this.cyclic);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    public int getTransparency() {
        return this.transparency;
    }
}

