/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.math;

public class MinMax {
    public static final MinMax ALL_DOUBLES = new MinMax(-1.7976931348623157E308, Double.MAX_VALUE);
    private static final double DEFAULT_MIN = Double.MAX_VALUE;
    private static final double DEFAULT_MAX = -1.7976931348623157E308;
    private double m_dMin;
    private double m_dMax;

    public MinMax() {
        this.m_dMin = Double.MAX_VALUE;
        this.m_dMax = -1.7976931348623157E308;
    }

    public MinMax(double dMin, double dMax) throws IllegalArgumentException {
        if (dMin > dMax) {
            throw new IllegalArgumentException("dMin (" + dMin + " ) is > dMax (" + dMax + ")");
        }
        this.m_dMin = dMin;
        this.m_dMax = dMax;
    }

    public MinMax(MinMax mmSrc) {
        this();
        if (mmSrc != null) {
            this.testRawValues(mmSrc);
        }
    }

    public boolean contains(double dValue) {
        return this.isValid() && dValue >= this.m_dMin && dValue <= this.m_dMax;
    }

    public double getMax() {
        assert (this.isValid());
        return this.m_dMax;
    }

    public double getMin() {
        assert (this.isValid());
        return this.m_dMin;
    }

    public boolean isValid() {
        return this.m_dMin != Double.MAX_VALUE && this.m_dMax != -1.7976931348623157E308;
    }

    public void testRawValue(double dValue) {
        if (dValue < this.m_dMin) {
            this.m_dMin = dValue;
        }
        if (dValue > this.m_dMax) {
            this.m_dMax = dValue;
        }
    }

    public void testRawValues(MinMax mmValues) {
        if (mmValues.isValid()) {
            this.testRawValue(mmValues.getMin());
            this.testRawValue(mmValues.getMax());
        }
    }

    public String toString() {
        return "MinMax(" + this.m_dMin + ", " + this.m_dMax + ")";
    }
}

