/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitModHyperbolic
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitModHyperbolic() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        double y = 1.0 / (a[1] + a[2] * x);
        if (Double.isNaN(y)) {
            throw new RuntimeException();
        }
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        a[1] = 1.0;
        a[2] = x;
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        assert (FP.nonzero(y));
        return 1.0 / y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "x";
        if (bHighOrderFirst) {
            return "y = 1 / (" + strTerm1 + " + " + strTerm2 + ")";
        }
        return "y = 1 / (" + strTerm2 + " + " + strTerm1 + ")";
    }
}

