/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitHyperbolic
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitHyperbolic() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        assert (FP.nonzero(x));
        double y = a[1] + a[2] / x;
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        assert (FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " / x";
        if (bHighOrderFirst) {
            return "y = " + strTerm1 + " + " + strTerm2;
        }
        return "y = " + strTerm2 + " + " + strTerm1;
    }
}

