/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IHistogramAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

class AxisHistObj
extends Axis2DObj
implements IHistogramAxis {
    private AxisTemplate m_axisID;

    public AxisHistObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, minMax, bVertical, bAscending, nAxisOffset, nAxisSize, true);
        this.m_axisID = id;
    }

    protected void calcMinorGridLine(IdentObj id, double fRelPos, BlackBoxObj blackBox) {
        if (FP.between(fRelPos, 0.0, 1.0) && this.m_axisID.getAxisObjID() != 7) {
            super.calcMinorGridLine(id, fRelPos, blackBox);
        }
    }

    void calcZeroLine() {
    }

    public int getHighIntervalCoord(int nInterval) {
        double high = this.getIntervalStop(nInterval);
        double low = this.getIntervalStart(nInterval);
        double width = (double)this.m_Perspective.getRiserWidth() / 100.0;
        return (int)this.getValueCoord(high - (high - low) * (1.0 - width) / 2.0);
    }

    public int getLowIntervalCoord(int nInterval) {
        double high = this.getIntervalStop(nInterval);
        double low = this.getIntervalStart(nInterval);
        double width = (double)this.m_Perspective.getRiserWidth() / 100.0;
        return (int)this.getValueCoord(low + (high - low) * (1.0 - width) / 2.0);
    }

    public int getNumIntervals() {
        int nNumIntervals = 0;
        if (!this.isNumericAxis()) {
            throw new UnsupportedOperationException("Numeric Axis method call on ordinal axis");
        }
        nNumIntervals = this.m_numericScale.getNumIntervals();
        return nNumIntervals;
    }

    public final double getIntervalStart(int nInterval) {
        double fIntervalStart = 0.0;
        if (!this.isNumericAxis()) {
            throw new UnsupportedOperationException("Numeric Axis method call on ordinal axis");
        }
        fIntervalStart = this.m_numericScale.getIntervalStart(nInterval);
        return fIntervalStart;
    }

    public final double getIntervalStop(int nInterval) {
        double fIntervalStop = 0.0;
        if (!this.isNumericAxis()) {
            throw new UnsupportedOperationException("Numeric Axis method call on ordinal axis");
        }
        fIntervalStop = this.m_numericScale.getIntervalStop(nInterval);
        return fIntervalStop;
    }
}

