/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DGridline;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.util.ArrayList;

class JChart_3D_Shape
extends JChart_3D {
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_3D_Shape(perspective);
        }
    };

    JChart_3D_Shape(Perspective perspective) {
        this(perspective, 0.0, 0.0, 0.0);
    }

    public JChart_3D_Shape(Perspective perspective, double x, double y, double z) {
        super(perspective, x, y, z);
    }

    protected boolean isInvertedForNegativeValue() {
        return true;
    }

    public void define3DMatrixObjects() {
        if (this.m_gt.is3DConnectSeries()) {
            this.define3DConnectSeries();
            this.define3DConnectGroups();
            return;
        }
        if (this.m_gt.is3DConnectGroups()) {
            this.define3DConnectGroups();
            this.define3DConnectSeries();
            return;
        }
        super.define3DMatrixObjects();
    }

    public void define3DConnectGroups() {
        double minSize;
        double sizeZ;
        double sizeX;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(true);
        Point3d[] points = null;
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        Point3d size = new Point3d();
        this.m_objectList = !this.m_bSafeAngle ? new ArrayList(this.m_nSeries * this.m_nGroups) : null;
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        double oldsizeX = sizeX = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double oldsizeZ = sizeZ = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d = minSize = sizeX < sizeZ ? sizeX : sizeZ;
        if (this.m_bRiserSquareRisers) {
            sizeX = sizeZ = minSize;
        }
        while (sEnum.hasNext()) {
            int nSeries = sEnum.next();
            assert (nSeries >= 0 && nSeries < this.m_nTotalSeries);
            int sRel = sEnum.getRelative(nSeries);
            assert (sRel >= 0 && sRel < this.m_nSeries);
            dX = this.m_O2Axis.getLowCoord(0, sRel);
            size.x = sizeX;
            if (this.m_bRiserSquareRisers && oldsizeX != minSize) {
                dX += (oldsizeX - minSize) / 2.0;
            }
            IdentObj id = new IdentObj(1005, nSeries, 0);
            GroupsEnumerator gEnum = this.getResetGroupsEnumerator(false);
            int nCount = gEnum.size();
            points = new Point3d[nCount];
            while (gEnum.hasNext()) {
                int nGroups = gEnum.next();
                assert (nGroups >= 0 && nGroups < this.m_nTotalGroups);
                int gRel = gEnum.getRelative(nGroups);
                assert (gRel >= 0 && gRel < this.m_nGroups);
                dZ = this.m_O1Axis.getLowCoord(0, gRel);
                size.z = sizeZ;
                if (this.m_bRiserSquareRisers && oldsizeZ != minSize) {
                    dZ += (oldsizeZ - minSize) / 2.0;
                }
                dY = this.m_numYCoords[nSeries][nGroups];
                Point3d p = points[--nCount] = new Point3d(dX, dY, dZ);
                System.out.println("JChart_3D define3DConnectGroups: [" + nSeries + "," + nGroups + "]= " + p);
            }
            boolean isConstantZ = false;
            Model3DGridline m = new Model3DGridline(this, id, this.assignSeriesColor(nSeries), isConstantZ, points, size, bGridStatus, this.m_bColorAutoshading);
            this.display(m);
        }
    }

    public void define3DConnectSeries() {
        double minSize;
        double sizeZ;
        double sizeX;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(false);
        Point3d[] points = null;
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        Point3d size = new Point3d();
        this.m_objectList = !this.m_bSafeAngle ? new ArrayList(this.m_nSeries * this.m_nGroups) : null;
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        double oldsizeX = sizeX = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double oldsizeZ = sizeZ = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d = minSize = sizeX < sizeZ ? sizeX : sizeZ;
        if (this.m_bRiserSquareRisers) {
            sizeX = sizeZ = minSize;
        }
        while (gEnum.hasNext()) {
            int nGroups = gEnum.next();
            assert (nGroups >= 0 && nGroups < this.m_nTotalGroups);
            int gRel = gEnum.getRelative(nGroups);
            assert (gRel >= 0 && gRel < this.m_nGroups);
            dZ = this.m_O1Axis.getLowCoord(0, gRel);
            size.z = sizeZ;
            if (this.m_bRiserSquareRisers && oldsizeZ != minSize) {
                dZ += (oldsizeZ - minSize) / 2.0;
            }
            IdentObj id = new IdentObj(1005, 0, nGroups);
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator(true);
            int nCount = sEnum.size();
            points = new Point3d[nCount];
            while (sEnum.hasNext()) {
                int nSeries = sEnum.next();
                assert (nSeries >= 0 && nSeries < this.m_nTotalSeries);
                int sRel = sEnum.getRelative(nSeries);
                assert (sRel >= 0 && sRel < this.m_nSeries);
                dX = this.m_O2Axis.getLowCoord(0, sRel);
                size.x = sizeX;
                if (this.m_bRiserSquareRisers && oldsizeX != minSize) {
                    dX += (oldsizeX - minSize) / 2.0;
                }
                dY = this.m_numYCoords[nSeries][nGroups];
                Point3d p = points[--nCount] = new Point3d(dX, dY, dZ);
                System.out.println("JChart_3D define3DConnectSeries: [" + nSeries + "," + nGroups + "]= " + p);
            }
            boolean isConstantZ = true;
            Model3DGridline m = new Model3DGridline(this, id, this.assignSeriesColor(nGroups), isConstantZ, points, size, bGridStatus, this.m_bColorAutoshading);
            this.display(m);
        }
    }
}

