/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Depth2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Bar2D {
    private Perspective m_Perspective;
    private IDrawContainer m_Detectiv;
    private Depth2D m_depth2D;

    public Bar2D(Perspective persp, IDrawContainer detectiv) {
        this.m_Perspective = persp;
        this.m_Detectiv = detectiv;
    }

    public Bar2D(Perspective persp, IDrawContainer detectiv, Depth2D depth2D) {
        this.m_Perspective = persp;
        this.m_Detectiv = detectiv;
        this.m_depth2D = depth2D;
    }

    public void draw(int series, int group, Rectangle rVirt, IBlackBox blackBox, Rectangle rGlobalClip) {
        if (this.m_depth2D != null) {
            this.drawTwoHalfDBarRiser(series, group, rVirt, blackBox, this.m_depth2D.getSeriesFrontOffset(series), this.m_depth2D.getSeriesBackOffset(series), this.m_Perspective.getDepthAngle(), true);
        } else {
            this.drawBarBasic(this.m_Perspective.getBarRiser(series, group), rVirt, blackBox, rGlobalClip);
        }
    }

    protected void drawBarBasic(IdentObj idFront, Rectangle rVirt, IBlackBox blackBoxNew, Rectangle rGlobalClip) {
        AnnotationBox.calcBorderedBox(this.m_Perspective, idFront, rVirt, blackBoxNew, rGlobalClip);
    }

    protected void drawTwoHalfDBarRiser(int s, int g, Rectangle rVirt, IBlackBox blackBox, Point ptFrontOffset, Point ptBackOffset, int nDepthAngle, boolean bColorAutoshadeRisers) {
        double fIntensity;
        Polygon polyVC;
        rVirt.x -= ptFrontOffset.x;
        rVirt.y -= ptFrontOffset.y;
        if (nDepthAngle != 90) {
            int nXFrame = nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
            polyVC = new Polygon();
            polyVC.addPoint(nXFrame, rVirt.y);
            polyVC.addPoint(nXFrame, rVirt.y + rVirt.height);
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame, rVirt.y);
            fIntensity = bColorAutoshadeRisers ? 0.8 : 1.0;
            IdentObj idSide = new IdentObj(556, s, g);
            DrawFactory.createPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        if (nDepthAngle != 0 && nDepthAngle != 180) {
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            fIntensity = 0.4;
            IdentObj idSide = new IdentObj(557, s, g);
            DrawFactory.createPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        IdentObj idFront = new IdentObj(521, s, g);
        if (bColorAutoshadeRisers) {
            fIntensity = 1.0;
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y);
            DrawFactory.createPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
        } else {
            DrawFactory.createRectangle(this.m_Detectiv, idFront, rVirt, blackBox, null);
        }
    }

    protected void drawBarAsPictograph(INumericAxis yAxisObj, boolean bHorz, Rectangle rVirt, IdentObj id, IBlackBox blackBox, Rectangle rGlobalClip) {
        Rectangle rPicto = new Rectangle(rVirt);
        int nGridlines = yAxisObj.getNumMajorGrids();
        int top = rVirt.y + rVirt.height;
        int bottom = rVirt.y;
        int left = rVirt.x;
        int right = rVirt.x + rVirt.width;
        double fPrevGridPosVC = yAxisObj.getBaseCoord();
        for (int iGrid = 0; iGrid <= nGridlines; ++iGrid) {
            Rectangle rClip;
            double fGridPosRel = yAxisObj.getMajorGridPos(iGrid);
            double fGridPosVC = ((IAxis2D)((Object)yAxisObj)).scaleToVC(fGridPosRel);
            double gap = fGridPosVC - fPrevGridPosVC;
            if (bHorz) {
                if (yAxisObj.isAscending()) {
                    if (fPrevGridPosVC > (double)left) {
                        left = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC >= (double)(rVirt.x + rVirt.width)) {
                        right = rVirt.x + rVirt.width;
                        rPicto.x = left;
                        rPicto.width = (int)gap;
                        rClip = new Rectangle(rGlobalClip);
                        if (right < rClip.x + rClip.width) {
                            rClip.width = right - rClip.x;
                        }
                        DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rClip);
                        continue;
                    }
                    if (!(fGridPosVC > (double)left + gap / 10.0)) continue;
                    right = (int)fGridPosVC;
                    rPicto.x = left;
                    rPicto.width = right - left;
                    DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rGlobalClip);
                    fPrevGridPosVC = fGridPosVC;
                    continue;
                }
                if (fPrevGridPosVC < (double)right) {
                    right = (int)fPrevGridPosVC;
                }
                if (fGridPosVC < (double)rVirt.x) {
                    rPicto.x = left = rVirt.x;
                    rPicto.width = right - left;
                    rClip = new Rectangle(rGlobalClip);
                    if (left > rClip.x) {
                        rClip.x = left;
                    }
                    DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    continue;
                }
                if (!(fGridPosVC < (double)right - gap / 10.0)) continue;
                rPicto.x = left = (int)fGridPosVC;
                rPicto.width = right - left;
                DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rGlobalClip);
                fPrevGridPosVC = fGridPosVC;
                continue;
            }
            if (yAxisObj.isAscending()) {
                if (fPrevGridPosVC > (double)bottom) {
                    bottom = (int)fPrevGridPosVC;
                }
                if (fGridPosVC >= (double)(rVirt.y + rVirt.height)) {
                    top = rVirt.y + rVirt.height;
                    rPicto.y = bottom;
                    rPicto.height = (int)gap;
                    rClip = new Rectangle(rGlobalClip);
                    if (top < rClip.y + rClip.height) {
                        rClip.height = top - rClip.y;
                    }
                    DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (!(fGridPosVC > (double)bottom + gap / 10.0)) continue;
                top = (int)fGridPosVC;
                rPicto.y = bottom;
                rPicto.height = top - bottom;
                DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rGlobalClip);
                fPrevGridPosVC = fGridPosVC;
                continue;
            }
            if (fPrevGridPosVC < (double)top) {
                top = (int)fPrevGridPosVC;
            }
            if (fGridPosVC <= (double)rVirt.y) {
                rPicto.y = bottom = rVirt.y;
                rPicto.height = top - bottom;
                rClip = new Rectangle(rGlobalClip);
                if (bottom > rClip.y) {
                    rClip.y = bottom;
                }
                DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rClip);
                break;
            }
            if (!(fGridPosVC < (double)top - gap / 10.0)) continue;
            rPicto.y = bottom = (int)fGridPosVC;
            rPicto.height = top - bottom;
            DrawFactory.createRectangle(this.m_Detectiv, id, rPicto, blackBox, rGlobalClip);
            fPrevGridPosVC = fGridPosVC;
        }
    }

    protected boolean isSeriesBarPictoGraph(int nSeries, IAxis yAxisObj) {
        boolean bDrawingPictograph = false;
        boolean bl = bDrawingPictograph = yAxisObj.getNumMajorGrids() > 1;
        if (bDrawingPictograph) {
            bDrawingPictograph = this.m_Perspective.getFillType(this.m_Perspective.getSeries(nSeries)) == 3;
        }
        return bDrawingPictograph;
    }
}

