/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.GraphicsUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class BorderInfoObj {
    private static final Logger logger = Logger.getLogger((String)"BorderInfoObj");
    public int m_nCornerArcHeight;
    public int m_nCornerArcWidth;
    public int m_nBorderWidth;
    public Insets m_Inset = null;
    public IdentObj m_idBorder;
    public Rectangle m_rBoundsVC;
    public int m_nBorderType;
    public IBlackBox m_blackBox;
    protected Color m_colorHighlightOuter;
    protected Color m_colorHighlightInner;
    protected Color m_colorShadowInner;
    protected Color m_colorShadowOuter;

    public void setupBorderInfo(Perspective perspective, IdentObj idObj, Rectangle rBoundsVC, IBlackBox bb) {
        this.m_rBoundsVC = rBoundsVC;
        this.m_idBorder = idObj;
        this.m_blackBox = bb == null ? new BlackBoxObj(perspective, idObj) : bb;
        this.m_nBorderType = perspective.getBorderType(idObj);
        this.m_nCornerArcHeight = perspective.getCornerArcHeight(idObj);
        this.m_nCornerArcWidth = perspective.getCornerArcWidth(idObj);
        Dimension frame = perspective.getSize();
        double aspectRatio = (double)frame.width / (double)frame.height;
        int insetSpaceVertical = perspective.getTopInset(idObj);
        int insetSpaceHorizontal = perspective.getLeftInset(idObj);
        if (aspectRatio > 1.0) {
            insetSpaceVertical = (int)((double)insetSpaceHorizontal * aspectRatio);
        } else {
            insetSpaceHorizontal = (int)((double)insetSpaceVertical / aspectRatio);
        }
        this.m_Inset = new Insets(insetSpaceVertical, insetSpaceHorizontal, insetSpaceVertical, insetSpaceHorizontal);
    }

    public void setupHighlightAndShadowColors() {
        Color colStart = this.m_blackBox.getFillColor();
        switch (this.m_blackBox.getFillType()) {
            default: {
                break;
            }
            case 2: {
                ArrayList<ColorPinObj> colorList = new ArrayList<ColorPinObj>();
                boolean bOK = this.m_blackBox.copyGradientColors(colorList);
                if (!bOK) break;
                ColorPinObj colPinObj = (ColorPinObj)colorList.get(0);
                colStart = colPinObj.getLeftColor();
            }
        }
        this.m_colorHighlightOuter = colStart.brighter().brighter();
        this.m_colorShadowInner = GraphicsUtil.brighten(colStart, 0.5);
        this.m_colorHighlightInner = GraphicsUtil.darker(this.m_blackBox.getFillColor(), colStart.darker(), 1.0);
        this.m_colorShadowOuter = colStart.darker().darker();
    }

    public IBlackBox copyFromBlackBox(Perspective perspective) {
        IBlackBox blackBoxIF;
        if (this.m_blackBox instanceof BlackBoxObj) {
            BlackBoxObj tmpBlackBox = new BlackBoxObj(perspective, this.m_idBorder);
            tmpBlackBox.copy((BlackBoxObj)this.m_blackBox);
            blackBoxIF = tmpBlackBox;
        } else if (this.m_blackBox instanceof SimpleBlackBoxObj) {
            SimpleBlackBoxObj tmpSimpleBlackBox = new SimpleBlackBoxObj(perspective, this.m_idBorder, false);
            tmpSimpleBlackBox.copy((SimpleBlackBoxObj)this.m_blackBox);
            blackBoxIF = tmpSimpleBlackBox;
        } else {
            blackBoxIF = null;
            logger.error((Object)"Improper type of BlackBox in BorderInfoObj:copyFromBlackBox");
        }
        return blackBoxIF;
    }
}

