/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetPolyLine
extends DetObj {
    private List<Point> vcPts;

    public DetPolyLine(IDrawContainer drawContainer, IdentObj id, IBlackBox blackBox, List<Point> vcPts) {
        super(drawContainer, id, blackBox);
        this.vcPts = vcPts;
        assert (vcPts != null);
        assert (vcPts.size() > 1);
    }

    @Override
    void hilite(Graphics2D g, VC vc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintIt(Graphics2D g2D, VC vc) {
        int nPoints = this.vcPts.size();
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            Point dcPt = vc.virtToDest(this.vcPts.get(i));
            xPoints[i] = dcPt.x;
            yPoints[i] = dcPt.y;
        }
        Stroke oldStroke = g2D.getStroke();
        g2D.setColor(this.blackBox.getBorderColor());
        g2D.setStroke(this.blackBox.getPenStroke());
        try {
            g2D.drawPolyline(xPoints, yPoints, nPoints);
        }
        finally {
            g2D.setStroke(oldStroke);
        }
    }

    @Override
    public Shape getShape() {
        return null;
    }
}

