/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.data;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataRange;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataChunk;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;
import java.util.ArrayList;
import java.util.List;

class DataStorage
implements IDataStorage {
    public static final int USER_PAGE = 0;
    public static final int MISSING_DATA_PAGE = 1;
    private DataRange m_DataExtents;
    private List<DataChunk> m_chunks;

    DataStorage() {
        this.m_chunks = new ArrayList<DataChunk>();
        this.m_chunks.add(new DataChunk(0, 0, 0));
        this.m_DataExtents = new DataRange();
    }

    DataStorage(DataStorage dsSrc) {
        this.copyChunks(dsSrc);
    }

    protected void copyChunks(DataStorage dsSrc) {
        this.m_chunks = new ArrayList<DataChunk>();
        for (DataChunk chunk : dsSrc.m_chunks) {
            this.m_chunks.add(new DataChunk(chunk));
        }
        this.m_DataExtents = new DataRange(dsSrc.m_DataExtents);
    }

    DataStorage(double[][] theData) {
        this();
        this.setDataMatrix(theData);
    }

    DataStorage(double[][] theData, int rowStart, int colStart) {
        this();
        this.setDataMatrix(rowStart, colStart, theData);
    }

    DataStorage(double[] theData, int rowStart) {
        this();
        this.setDataRow(rowStart, theData);
    }

    DataStorage(double[] theData, int rowStart, int colStart) {
        this();
        this.setDataRow(rowStart, colStart, theData);
    }

    public void dumpPage() {
        this.dumpPage(0);
    }

    public void dumpPage(int page) {
        for (DataChunk chunk : this.m_chunks) {
            if (!chunk.isOnPage(page)) continue;
            chunk.dumpChunk();
        }
    }

    public DataChunk findChunk(int page, int row, int col) {
        for (DataChunk chunk : this.m_chunks) {
            if (!chunk.contains(page, row, col)) continue;
            return chunk;
        }
        return null;
    }

    public Object getData(int row, int col) {
        assert (row >= 0 && col >= 0);
        DataChunk chunk = this.findChunk(0, row, col);
        assert (chunk != null);
        Object obj = chunk.getData(row, col);
        return obj;
    }

    public double getDataAsDouble(int row, int col) {
        Object obj = this.getData(row, col);
        if (DataStorage.isObjectNumeric(obj)) {
            Number nObj = (Number)obj;
            return nObj.doubleValue();
        }
        throw new RuntimeException("Cell at row = " + row + ", col = " + col + " is NOT a Number.");
    }

    public DataRange getDataExtents() {
        return this.m_DataExtents;
    }

    public boolean isCellNumeric(int row, int col) {
        Object obj = this.getData(row, col);
        return DataStorage.isObjectNumeric(obj);
    }

    public static boolean isObjectNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean bNumeric = false;
        if (obj instanceof Number) {
            bNumeric = true;
        }
        return bNumeric;
    }

    public void setData(int row, int col, double fValue) {
        this.setData(row, col, new Double(fValue));
    }

    public void setData(int row, int col, Object obj) {
        assert (row >= 0 && col >= 0);
        if (row < 0 || col < 0) {
            return;
        }
        DataChunk chunk = this.findChunk(0, row, col);
        if (chunk == null) {
            chunk = new DataChunk(0, row, col);
            this.m_chunks.add(chunk);
        }
        if (obj instanceof Double && ((Double)obj).isNaN()) {
            obj = null;
        }
        chunk.setData(row, col, obj);
        if (obj != null) {
            this.m_DataExtents.extendTo(row, col);
        }
        this.setFillMissingData(row, col, false);
    }

    public void deleteRow(int row) {
        DataChunk chunk;
        int numRows = this.m_DataExtents.getNumRows();
        int numCols = this.m_DataExtents.getNumCols();
        int r = row;
        while (r + 1 < numRows) {
            for (int c = 0; c < numCols; ++c) {
                DataChunk nextChunk;
                chunk = this.findChunk(0, r, c);
                if (chunk == null || (nextChunk = this.findChunk(0, r + 1, c)) == null) continue;
                chunk.setData(r, c, nextChunk.getData(r + 1, c));
            }
            ++r;
        }
        for (int c = 0; c < numCols; ++c) {
            chunk = this.findChunk(0, numRows - 1, c);
            if (chunk == null) continue;
            chunk.setData(numRows - 1, c, null);
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop() - 1, this.m_DataExtents.getColStop());
    }

    public void deleteCol(int col) {
        DataChunk chunk;
        int numRows = this.m_DataExtents.getNumRows();
        int numCols = this.m_DataExtents.getNumCols();
        int c = col;
        while (c + 1 < numCols) {
            for (int r = 0; r < numRows; ++r) {
                DataChunk nextChunk;
                chunk = this.findChunk(0, r, c);
                if (chunk == null || (nextChunk = this.findChunk(0, r, c + 1)) == null) continue;
                chunk.setData(r, c, nextChunk.getData(r, c + 1));
            }
            ++c;
        }
        for (int r = 0; r < numRows; ++r) {
            chunk = this.findChunk(0, r, numCols - 1);
            if (chunk == null) continue;
            chunk.setData(r, numCols - 1, null);
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop(), this.m_DataExtents.getColStop() - 1);
    }

    public void setDataMatrix(double[][] theData) {
        this.setDataMatrix(0, 0, theData);
    }

    public void setDataMatrix(Object[][] theData) {
        this.setDataMatrix(0, 0, theData);
    }

    public void setDataMatrix(int rowStart, int colStart, double[][] theData) {
        int nrows = theData.length;
        int ncols = theData[0].length;
        for (int ir = 0; ir < nrows; ++ir) {
            for (int ic = 0; ic < ncols; ++ic) {
                this.setData(rowStart + ir, colStart + ic, new Double(theData[ir][ic]));
            }
        }
    }

    public void setDataMatrix(int rowStart, int colStart, Object[][] theData) {
        int nrows = theData.length;
        int ncols = theData[0].length;
        for (int ir = 0; ir < nrows; ++ir) {
            for (int ic = 0; ic < ncols; ++ic) {
                this.setData(rowStart + ir, colStart + ic, theData[ir][ic]);
            }
        }
    }

    public void setDataRow(int rowStart, double[] theData) {
        this.setDataRow(rowStart, 0, theData);
    }

    public void setDataRow(int rowStart, Object[] theData) {
        this.setDataRow(rowStart, 0, theData);
    }

    public void setDataRow(int rowStart, int colStart, double[] theData) {
        int ncols = theData.length;
        for (int ic = 0; ic < ncols; ++ic) {
            this.setData(rowStart, colStart + ic, new Double(theData[ic]));
        }
    }

    public void setDataRow(int rowStart, int colStart, Object[] theData) {
        int ncols = theData.length;
        for (int ic = 0; ic < ncols; ++ic) {
            this.setData(rowStart, colStart + ic, theData[ic]);
        }
    }

    public void setFillMissingData(int nRow, int nCol, boolean bFillMissingData) {
        Boolean boolObj = bFillMissingData ? Boolean.TRUE : Boolean.FALSE;
        DataChunk missingDataChunk = this.findChunk(1, nRow, nCol);
        if (missingDataChunk == null) {
            missingDataChunk = new DataChunk(1, nRow, nCol);
            this.m_chunks.add(missingDataChunk);
        }
        missingDataChunk.setData(nRow, nCol, boolObj);
    }

    public boolean isMissingDataFilledIn(int nRow, int nCol) {
        assert (nRow >= 0 && nCol >= 0);
        DataChunk missingDataChunk = this.findChunk(1, nRow, nCol);
        assert (missingDataChunk != null);
        Boolean boolObj = (Boolean)missingDataChunk.getData(nRow, nCol);
        assert (boolObj != null);
        return boolObj;
    }

    public void dumpStorage() {
    }

    public void copy(IDataStorage ds) {
    }
}

