/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AutoNumberFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MaskFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatCallBack;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PFJDateFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PFJDecimalFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ScaledNumberFormat;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TTFNumberFormatCallback
extends NumberFormatCallBack {
    public static final int LCID_INVARIANT = 127;
    private static final int DECIMAL_SEPARATOR_SYMBOL = 0;
    private static final int GROUP_SEPARATOR_SYMBOL = 1;
    private static final int NUM_FRACTION_DIGITS = 2;
    private static final int GROUP_SIZE = 3;
    private static final int NO_NEG_SIGN = 4;
    private static final int PRE_POST_TEXT = 5;
    private static final int USE_THOUSANDS = 6;
    private static final int PERCENT_PATTERN = 7;
    private static final int LEADING_ZERO_PATTERN = 8;
    private static final int EXPONENT_PATTERN = 9;
    private static final int CURRENCY_FORMAT = 10;
    private static final int MONETARY_DECIMAL_SEPARATOR_SYMBOL = 11;
    public static final String AmigoCustomDateCookie = "Amigo";
    static final int dateTableSize = 9;
    static final String[] dateTableMDY = new String[]{"MM.dd.yyyy", "M.d", "M.d.yy", "MM.dd.yy", "MMM.yy", "MMMM.yy", "MMMM.d.yyyy", "M.dd.yy", "MM.d.yy"};
    static final String[] dateTableDMY = new String[]{"dd.MM.yyyy", "d.M", "d.M.yy", "dd.MM.yy", "MMM.yy", "MMMM.yy", "d.MMMM .yyyy", "dd.M.yy", "d.MM.yy"};
    static final String[] dateTableYMD = new String[]{"yyyy.MM.dd", "M.d", "yy.M.d", "yy.MM.dd", "yy.MMM", "yy.MMMM", "yyyy.MMMM.d", "yy.M.dd", "yy.MM.d"};
    static final Map<String, Integer> dateMap = new HashMap<String, Integer>(27);

    public static Format createJavaFormat(AdvFormatStruct advFormat, Locale locale) {
        Format format = null;
        if (advFormat != null) {
            NumberFormatOptions formatType = NumberFormatOptions.fromInt(advFormat.formatType);
            if (formatType == NumberFormatOptions.NoFormat) {
                formatType = NumberFormatOptions.fromInt(advFormat.alternateFormatType);
            }
            switch (formatType) {
                case NoFormat: {
                    format = advFormat.stdFormat == 1 ? new AutoNumberFormat() : new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    break;
                }
                case GeneralFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 0);
                    break;
                }
                case ScientificFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 9);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 2);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 0);
                    break;
                }
                case FractionFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    break;
                }
                case DateFormat: {
                    format = TTFNumberFormatCallback.convertDateFormat(TTFNumberFormatCallback.getString(advFormat.szDateFormat), locale);
                    break;
                }
                case TimeFormat: {
                    format = TTFNumberFormatCallback.convertTimeFormat(TTFNumberFormatCallback.getString(advFormat.szTimeFormat), locale);
                    break;
                }
                case DateTimeFormat: {
                    format = TTFNumberFormatCallback.convertDateTimeFormat(TTFNumberFormatCallback.getString(advFormat.szDateFormat), TTFNumberFormatCallback.getString(advFormat.szTimeFormat), locale);
                    break;
                }
                case ZipCodeFormat: {
                    format = new MaskFormat("#####");
                    break;
                }
                case ZipCodePlus4Format: {
                    format = new MaskFormat("#####-####");
                    break;
                }
                case SSNFormat: {
                    format = new MaskFormat("###-##-####");
                    break;
                }
                case PhoneFormat: {
                    format = new MaskFormat("###-####");
                    break;
                }
                case TextFormat: {
                    break;
                }
                case NumberFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 6);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 0);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 2);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 3);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 1);
                    break;
                }
                case PercentFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 7);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 0);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 2);
                    break;
                }
                case CurrencyFormat: {
                    format = new PFJDecimalFormat();
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 11);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 8);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 6);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 5);
                    TTFNumberFormatCallback.setFormatProperty(format, advFormat, 10);
                    break;
                }
            }
            if (format instanceof PFJDecimalFormat) {
                PFJDecimalFormat df = format;
                if (advFormat.isAlwaysLocalized()) {
                    DecimalFormatSymbols defaults = new DecimalFormatSymbols(locale);
                    DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
                    symbols.setDecimalSeparator(defaults.getDecimalSeparator());
                    symbols.setGroupingSeparator(defaults.getGroupingSeparator());
                    symbols.setMonetaryDecimalSeparator(defaults.getMonetaryDecimalSeparator());
                    defaults = new DecimalFormatSymbols();
                    symbols.setCurrencySymbol(defaults.getCurrencySymbol());
                    df.setDecimalFormatSymbols(symbols);
                }
                if (advFormat.dScaleFactor != 0.0 && !(df instanceof AutoNumberFormat)) {
                    format = new ScaledNumberFormat(df.toPattern(), df.getDecimalFormatSymbols(), advFormat.dScaleFactor);
                }
            }
        }
        return format;
    }

    private static Format convertDateFormat(String datePattern, Locale locale) {
        int dateStyle = TTFNumberFormatCallback.getDateStyle(datePattern = TTFNumberFormatCallback.fixDatePattern(datePattern));
        if (dateStyle >= 0) {
            return PFJDateFormat.getDateInstance(dateStyle, locale);
        }
        return PFJDateFormat.getCustomInstance("Amigo(" + datePattern + ")", locale);
    }

    private static Format convertTimeFormat(String timePattern, Locale locale) {
        timePattern = TTFNumberFormatCallback.fixTimePattern(timePattern);
        return PFJDateFormat.getTimeInstance(TTFNumberFormatCallback.getTimeStyle(timePattern), locale);
    }

    private static Format convertDateTimeFormat(String datePattern, String timePattern, Locale locale) {
        datePattern = TTFNumberFormatCallback.fixDatePattern(datePattern);
        timePattern = TTFNumberFormatCallback.fixTimePattern(timePattern);
        int dateStyle = TTFNumberFormatCallback.getDateStyle(datePattern);
        if (dateStyle >= 0) {
            return PFJDateFormat.getDateTimeInstance(dateStyle, TTFNumberFormatCallback.getTimeStyle(timePattern), locale);
        }
        return PFJDateFormat.getCustomInstance("Amigo(" + datePattern + ") " + timePattern, locale);
    }

    private static String fixDatePattern(String datePattern) {
        datePattern = datePattern.replaceAll("dddd", "EEEE");
        return datePattern.replaceAll("ddd", "EEE");
    }

    private static String fixTimePattern(String timePattern) {
        return timePattern.replace('t', 'a');
    }

    private static void setFormatProperty(PFJDecimalFormat decimalFormat, AdvFormatStruct advFormat, int id) {
        boolean usingCurrency = advFormat.formatType == NumberFormatOptions.CurrencyFormat.ordinal();
        char groupingCharacter = usingCurrency ? TTFNumberFormatCallback.getChar(advFormat.szMonThousandSep) : TTFNumberFormatCallback.getChar(advFormat.szThousand);
        String string = null;
        switch (id) {
            case 0: {
                char character = TTFNumberFormatCallback.getChar(advFormat.szDecimal);
                if (character == '\u0000') break;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setDecimalSeparator(character);
                decimalFormat.setDecimalFormatSymbols(symbols);
                break;
            }
            case 11: {
                char character = TTFNumberFormatCallback.getChar(advFormat.szMonDecimalSep);
                if (character == '\u0000') break;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setMonetaryDecimalSeparator(character);
                decimalFormat.setDecimalFormatSymbols(symbols);
                break;
            }
            case 1: {
                char character = TTFNumberFormatCallback.getChar(advFormat.szThousand);
                if (character == '\u0000') break;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setGroupingSeparator(character);
                decimalFormat.setDecimalFormatSymbols(symbols);
                break;
            }
            case 3: {
                decimalFormat.setGroupingSize(advFormat.iGrouping);
                break;
            }
            case 2: {
                decimalFormat.setMaximumFractionDigits(advFormat.iDigits);
                decimalFormat.setMinimumFractionDigits(advFormat.iDigits);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                if (advFormat.iLZero == 1) {
                    decimalFormat.applyPattern("0.#");
                    break;
                }
                decimalFormat.applyPattern("#.#");
                break;
            }
            case 6: {
                if (advFormat.iLZero == 1) {
                    if (groupingCharacter == '\u0000') {
                        decimalFormat.applyPattern("0.#");
                        break;
                    }
                    decimalFormat.applyPattern("#,##0.#");
                    break;
                }
                if (groupingCharacter == '\u0000') {
                    decimalFormat.applyPattern("#.#");
                    break;
                }
                decimalFormat.applyPattern("#,###.#");
                break;
            }
            case 5: {
                String basePositiveFormat = decimalFormat.getPositiveFormat();
                String baseNegativeFormat = decimalFormat.getNegativeFormat();
                basePositiveFormat = TTFNumberFormatCallback.getString(advFormat.szPrefixText) + basePositiveFormat + TTFNumberFormatCallback.getString(advFormat.szPostfixText);
                baseNegativeFormat = TTFNumberFormatCallback.getString(advFormat.szPrefixText) + baseNegativeFormat + TTFNumberFormatCallback.getString(advFormat.szPostfixText);
                decimalFormat.applyPattern(basePositiveFormat + ';' + baseNegativeFormat);
                break;
            }
            case 9: {
                if (advFormat.iLZero == 1) {
                    decimalFormat.applyPattern("0.##E000");
                    break;
                }
                decimalFormat.applyPattern("#.##E000");
                break;
            }
            case 7: {
                String basePositiveFormat = decimalFormat.getPositiveFormat();
                String baseNegativeFormat = decimalFormat.getNegativeFormat();
                if (advFormat.bPrefixPercentSymbol == 0) {
                    basePositiveFormat = basePositiveFormat + '%';
                    baseNegativeFormat = baseNegativeFormat + '%';
                } else {
                    basePositiveFormat = '%' + basePositiveFormat;
                    baseNegativeFormat = '%' + baseNegativeFormat;
                }
                decimalFormat.applyPattern(basePositiveFormat + ';' + baseNegativeFormat);
                break;
            }
            case 10: {
                DecimalFormatSymbols symbols;
                decimalFormat.applyPattern(TTFNumberFormatCallback.getCurrencyPattern(decimalFormat.toPattern(), advFormat.iPosCurr, advFormat.iNegCurr));
                char character = TTFNumberFormatCallback.getChar(advFormat.szMonThousandSep);
                if (character != '\u0000') {
                    symbols = decimalFormat.getDecimalFormatSymbols();
                    symbols.setGroupingSeparator(character);
                    decimalFormat.setDecimalFormatSymbols(symbols);
                }
                if ((character = TTFNumberFormatCallback.getChar(advFormat.szMonDecimalSep)) != '\u0000') {
                    symbols = decimalFormat.getDecimalFormatSymbols();
                    symbols.setDecimalSeparator(character);
                    decimalFormat.setDecimalFormatSymbols(symbols);
                }
                if ((string = TTFNumberFormatCallback.getString(advFormat.szCurrency)) != null) {
                    symbols = decimalFormat.getDecimalFormatSymbols();
                    symbols.setCurrencySymbol(string);
                    decimalFormat.setDecimalFormatSymbols(symbols);
                }
                decimalFormat.setGroupingSize(advFormat.iMonGrouping);
                decimalFormat.setMaximumFractionDigits(advFormat.iCurrDigits);
                decimalFormat.setMinimumFractionDigits(advFormat.iCurrDigits);
            }
        }
    }

    private static String getCurrencyPattern(String positivePattern, int posId, int negId) {
        if (positivePattern == null || positivePattern.length() == 0) {
            positivePattern = "#,##0";
        }
        String negativePattern = "";
        String newPositivePattern = positivePattern;
        int currencySymbol = 164;
        switch (posId) {
            case 0: {
                newPositivePattern = '\u00a4' + positivePattern;
                break;
            }
            case 1: {
                newPositivePattern = positivePattern + '\u00a4';
                break;
            }
            case 2: {
                newPositivePattern = "\u00a4 " + positivePattern;
                break;
            }
            case 3: {
                newPositivePattern = positivePattern + " " + '\u00a4';
            }
        }
        switch (negId) {
            case 0: {
                negativePattern = "(\u00a4" + positivePattern + ")";
                break;
            }
            case 1: {
                negativePattern = "-\u00a4" + positivePattern;
                break;
            }
            case 2: {
                negativePattern = "\u00a4-" + positivePattern;
                break;
            }
            case 3: {
                negativePattern = '\u00a4' + positivePattern + "-";
                break;
            }
            case 4: {
                negativePattern = "(" + positivePattern + '\u00a4' + ")";
                break;
            }
            case 5: {
                negativePattern = "-" + positivePattern + '\u00a4';
                break;
            }
            case 6: {
                negativePattern = positivePattern + "-" + '\u00a4';
                break;
            }
            case 7: {
                negativePattern = positivePattern + '\u00a4' + "-";
                break;
            }
            case 8: {
                negativePattern = "-" + positivePattern + " " + '\u00a4';
                break;
            }
            case 9: {
                negativePattern = "-\u00a4 " + positivePattern;
                break;
            }
            case 10: {
                negativePattern = positivePattern + " " + '\u00a4' + "-";
                break;
            }
            case 11: {
                negativePattern = "\u00a4 " + positivePattern + "-";
                break;
            }
            case 12: {
                negativePattern = "\u00a4 -" + positivePattern;
                break;
            }
            case 13: {
                negativePattern = positivePattern + "- " + '\u00a4';
                break;
            }
            case 14: {
                negativePattern = "(\u00a4 " + positivePattern + ")";
                break;
            }
            case 15: {
                negativePattern = "(" + positivePattern + " " + '\u00a4' + ")";
            }
        }
        return newPositivePattern + ";" + negativePattern;
    }

    private static String getString(char[] c) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < c.length && c[i] != '\u0000') {
            buffer.append(c[i++]);
        }
        return buffer.toString();
    }

    private static char getChar(char[] c) {
        return c[0];
    }

    static Integer findDateIndex(String str) {
        String unquote = str.replaceAll("'.'", ".");
        Integer index = dateMap.get(unquote);
        if (null != index) {
            return index;
        }
        for (String key : dateMap.keySet()) {
            if (!unquote.matches(key)) continue;
            return dateMap.get(key);
        }
        for (String key : dateMap.keySet()) {
            if (!unquote.matches(key.replaceAll("\\.", ".+"))) continue;
            return dateMap.get(key);
        }
        if (unquote.matches("d.+MMMM.+yyyy")) {
            return 6;
        }
        return null;
    }

    static String getDatePattern(int style, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(style, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)dateFormat;
            return simpleFormat.toPattern();
        }
        return "";
    }

    static boolean isYMD(Locale locale) {
        return TTFNumberFormatCallback.getDatePattern(3, locale).matches(".*y+.*M+.*d+.*");
    }

    static String doubleMD(String pattern) {
        return pattern.replaceAll("M+", "MM").replaceAll("d+", "dd");
    }

    static String singleMD(String pattern) {
        return pattern.replaceAll("M+", "M").replaceAll("d+", "d");
    }

    static String doubleM(String pattern) {
        return pattern.replaceAll("M+", "MM");
    }

    static String singleM(String pattern) {
        return pattern.replaceAll("M+", "M");
    }

    static String doubleD(String pattern) {
        return pattern.replaceAll("d+", "dd");
    }

    static String singleD(String pattern) {
        return pattern.replaceAll("d+", "d");
    }

    static String quadY(String pattern) {
        return pattern.replaceAll("y+", "yyyy");
    }

    static String doubleY(String pattern) {
        return pattern.replaceAll("y+", "yy");
    }

    public static String localizeAmigoDatePattern(String inputPattern, Locale locale) {
        assert (inputPattern.startsWith(AmigoCustomDateCookie));
        String pattern = inputPattern.substring(AmigoCustomDateCookie.length() + 1);
        int endIndex = pattern.indexOf(41);
        String remainder = pattern.substring(endIndex + 1);
        pattern = pattern.substring(0, endIndex);
        Integer dateIndex = TTFNumberFormatCallback.findDateIndex(pattern);
        pattern = TTFNumberFormatCallback.getDatePattern(3, locale);
        if (null == dateIndex) {
            assert (false);
            return pattern;
        }
        switch (dateIndex) {
            case 0: {
                pattern = TTFNumberFormatCallback.quadY(pattern);
                break;
            }
            case 1: {
                String pattern1 = pattern.replaceAll("y+.", "");
                String pattern2 = pattern.replaceAll(".y+", "");
                pattern = pattern1.length() < pattern2.length() ? pattern1 : pattern2;
                pattern = TTFNumberFormatCallback.singleMD(pattern);
                break;
            }
            case 2: {
                pattern = TTFNumberFormatCallback.doubleY(pattern);
                pattern = TTFNumberFormatCallback.singleMD(pattern);
                break;
            }
            case 3: {
                assert (false);
                pattern = TTFNumberFormatCallback.doubleY(pattern);
                pattern = TTFNumberFormatCallback.doubleMD(pattern);
                break;
            }
            case 4: {
                if (TTFNumberFormatCallback.isYMD(locale)) {
                    pattern = "yy-MMM";
                    break;
                }
                pattern = "MMM-yy";
                break;
            }
            case 5: {
                if (TTFNumberFormatCallback.isYMD(locale)) {
                    pattern = "yy-MMMM";
                    break;
                }
                pattern = "MMMM-yy";
                break;
            }
            case 6: {
                assert (false);
                pattern = TTFNumberFormatCallback.getDatePattern(1, locale);
                break;
            }
            case 7: {
                pattern = TTFNumberFormatCallback.doubleY(pattern);
                pattern = TTFNumberFormatCallback.doubleD(pattern);
                pattern = TTFNumberFormatCallback.singleM(pattern);
                break;
            }
            case 8: {
                assert (false);
                pattern = TTFNumberFormatCallback.doubleY(pattern);
                pattern = TTFNumberFormatCallback.doubleM(pattern);
                pattern = TTFNumberFormatCallback.singleD(pattern);
            }
        }
        return pattern + remainder;
    }

    static int getDateStyle(String pattern) {
        Integer dateIndex = TTFNumberFormatCallback.findDateIndex(pattern);
        if (null == dateIndex) {
            assert (false);
            return 3;
        }
        switch (dateIndex) {
            case 3: {
                return 3;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    static int getTimeStyle(String pattern) {
        if (pattern.contains("ss")) {
            return 1;
        }
        return 3;
    }

    static {
        for (int i = 0; i < 9; ++i) {
            dateMap.put(dateTableMDY[i], i);
            dateMap.put(dateTableDMY[i], i);
            dateMap.put(dateTableYMD[i], i);
        }
    }
}

