/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class DataTextPosition {
    public static final int DATATEXTPOSITION_CUSTOM = 0;
    public static final int DATATEXTPOSITION_MAX_OUTSIDE = 1;
    public static final int DATATEXTPOSITION_MAX_CENTER = 2;
    public static final int DATATEXTPOSITION_MAX_INSIDE = 3;
    public static final int DATATEXTPOSITION_CENTER = 4;
    public static final int DATATEXTPOSITION_MIN_INSIDE = 5;
    public static final int DATATEXTPOSITION_CENTERBACK = 6;
    public static final int DATATEXTPOSITION_MIN_CENTER = 7;
    public static final int DATATEXTPOSITION_MIN_OUTSIDE = 8;
    private int m_nDataTextPosition;
    private int m_nDataTextPositionSecondary;
    private Point m_ptTwoHalfDOffset;
    private int m_nBaseCoord;
    private Point m_ptCenterTop;
    private int m_width;
    Dimension m_dimLabel;
    Point m_ptFrontOffset;
    boolean m_bHoriz;
    double m_fDataValue;
    boolean m_bIsAxisAscending;
    double m_fStackedCumVal;
    double m_fPercentCumVal;
    double m_fAngle;
    double m_fDist;
    boolean m_bIsCombo;
    int m_nPrevCoord;
    boolean m_bPrevCoordValid;
    boolean m_bIsDateScale;
    JGraphType m_graphType;
    boolean m_invertedRiser;
    final int SMALL_MARGIN = 100;

    public DataTextPosition(int nDataTextPosition, int nDataTextPositionSecondary, JGraphType graphType, Point ptTwoHalfDOffset, int nBaseCoord, Point ptCenterTop, int width, Dimension dimLabel, Point ptFrontOffset, double fDataValue, double fStackedCumVal, double fPercentCumVal, boolean bHoriz, boolean bIsAxisAscending, double fAngle, double fDist, boolean bIsCombo, int nPrevCoord, boolean bPrevCoordValid, boolean bIsDateScale) {
        this.m_nDataTextPositionSecondary = nDataTextPositionSecondary;
        this.m_nDataTextPosition = nDataTextPosition;
        this.m_graphType = graphType;
        this.m_ptTwoHalfDOffset = ptTwoHalfDOffset;
        this.m_nBaseCoord = nBaseCoord;
        this.m_ptCenterTop = ptCenterTop;
        this.m_width = width;
        this.m_dimLabel = dimLabel;
        this.m_ptFrontOffset = ptFrontOffset;
        this.m_fDataValue = fDataValue;
        this.m_fStackedCumVal = fStackedCumVal;
        this.m_fPercentCumVal = fPercentCumVal;
        this.m_bHoriz = bHoriz;
        this.m_bIsAxisAscending = bIsAxisAscending;
        this.m_fAngle = fAngle;
        this.m_fDist = fDist;
        this.m_bIsCombo = bIsCombo;
        this.m_nPrevCoord = nPrevCoord;
        this.m_bPrevCoordValid = bPrevCoordValid;
        this.m_bIsDateScale = bIsDateScale;
        this.m_invertedRiser = bIsAxisAscending && fDataValue < 0.0 || !bIsAxisAscending && fDataValue >= 0.0;
    }

    public Rectangle calcPosition() {
        Rectangle rPos;
        switch (this.m_nDataTextPosition) {
            case 0: {
                rPos = this.calcPositionCustom();
                break;
            }
            case 8: {
                rPos = this.calcPositionMinOutside();
                break;
            }
            default: {
                rPos = this.calcPositionAbove();
                break;
            }
            case 2: {
                rPos = this.calcPositionCenterTop();
                break;
            }
            case 3: {
                rPos = this.calcPositionBelow();
                break;
            }
            case 4: {
                rPos = this.calcPositionCenter();
                break;
            }
            case 5: {
                rPos = this.calcPositionBase();
                break;
            }
            case 6: {
                rPos = this.calcPositionCenterBack();
            }
        }
        if (this.m_nDataTextPositionSecondary != 4 && this.m_width != 0) {
            switch (this.m_nDataTextPositionSecondary) {
                default: {
                    rPos.x -= this.m_width / 2 + this.m_dimLabel.width / 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    rPos.x += this.m_width / 2 + this.m_dimLabel.width / 2;
                }
            }
        }
        if (this.m_ptTwoHalfDOffset != null) {
            rPos.x -= this.m_ptTwoHalfDOffset.x;
            rPos.y -= this.m_ptTwoHalfDOffset.y;
        }
        return rPos;
    }

    private Rectangle calcPositionMinOutside() {
        Rectangle rPos = this.calcPositionBase();
        if (this.m_bHoriz) {
            rPos.x = this.m_invertedRiser ? (rPos.x += this.m_dimLabel.width) : (rPos.x -= this.m_dimLabel.width);
        } else {
            rPos.y = this.m_invertedRiser ? (rPos.y += this.m_dimLabel.height) : (rPos.y -= this.m_dimLabel.height);
        }
        return rPos;
    }

    protected Rectangle calcPositionCenterBack() {
        Point ptCenterBack = new Point();
        ptCenterBack.x = this.m_ptCenterTop.x + this.m_ptFrontOffset.x;
        ptCenterBack.y = this.m_ptCenterTop.y + this.m_ptFrontOffset.y;
        Rectangle rPos = new Rectangle(ptCenterBack.x - this.m_dimLabel.width / 2, ptCenterBack.y - this.m_dimLabel.height / 2, this.m_dimLabel.width, this.m_dimLabel.height);
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending && this.m_fDataValue > 0.0 ? (rPos.x += this.m_dimLabel.width / 2) : (rPos.x -= this.m_dimLabel.width / 2);
        } else {
            rPos.y = this.m_bIsAxisAscending && this.m_fDataValue > 0.0 ? (rPos.y += this.m_dimLabel.height / 2) : (rPos.y -= this.m_dimLabel.height / 2);
        }
        return rPos;
    }

    protected Rectangle calcPositionCenterTop() {
        Rectangle rPos = this.m_nDataTextPosition == 0 ? new Rectangle(this.m_ptCenterTop.x - this.m_dimLabel.width / 2, this.m_ptCenterTop.y, this.m_dimLabel.width, this.m_dimLabel.height) : new Rectangle(this.m_ptCenterTop.x - this.m_dimLabel.width / 2, this.m_ptCenterTop.y - this.m_dimLabel.height / 2, this.m_dimLabel.width, this.m_dimLabel.height);
        return rPos;
    }

    protected Rectangle calcPositionCustom() {
        Rectangle rPos = this.calcPositionBelow();
        if (this.m_bIsAxisAscending && (this.m_fDataValue >= 0.0 || this.m_bIsDateScale)) {
            rPos = this.calcPositionCenterTop();
        }
        if (this.m_bHoriz) {
            this.m_fAngle -= 90.0;
        }
        rPos.x += (int)(Math.cos(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
        rPos.y += (int)(Math.sin(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
        return rPos;
    }

    protected Rectangle calcPositionAbove() {
        Rectangle rPos = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending && this.m_fDataValue >= 0.0 ? (rPos.x += this.m_dimLabel.width / 2 + 100) : (rPos.x -= this.m_dimLabel.width / 2 + 100);
        } else {
            rPos.y = this.m_bIsAxisAscending && this.m_fDataValue >= 0.0 ? (rPos.y += this.m_dimLabel.height / 2 + 100) : (rPos.y -= this.m_dimLabel.height / 2 + 100);
        }
        return rPos;
    }

    protected Rectangle calcPositionBelow() {
        Rectangle rPos = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending ? (rPos.x -= this.m_dimLabel.width / 2 + 100) : (rPos.x += this.m_dimLabel.width / 2 + 100);
            if (this.m_fDataValue < 0.0) {
                rPos.x += this.m_dimLabel.width;
            }
        } else {
            rPos.y = this.m_bIsAxisAscending && this.m_fDataValue >= 0.0 ? (rPos.y -= this.m_dimLabel.height / 2 + 100) : (rPos.y += this.m_dimLabel.height / 2 + 100);
        }
        return rPos;
    }

    protected Rectangle calcPositionCenter() {
        Rectangle rPos = this.calcPositionCenterTop();
        int labelCenteringAmount = this.m_bHoriz ? this.m_dimLabel.width / 2 : this.m_dimLabel.height / 2;
        int riserLabelPosition = this.getRiserCenterCoord() - labelCenteringAmount;
        if (this.m_bHoriz) {
            rPos.x = riserLabelPosition;
        } else {
            rPos.y = riserLabelPosition;
        }
        return rPos;
    }

    private int getRiserTopCoord() {
        return this.m_bHoriz ? this.m_ptCenterTop.x : this.m_ptCenterTop.y;
    }

    private int getRiserCenterCoord() {
        int riserTopVC = this.getRiserTopCoord();
        int riserBaseVC = this.getRiserBaseCoord();
        int halfLengthVC = Math.abs(riserTopVC - riserBaseVC) / 2;
        if (this.m_invertedRiser) {
            return riserTopVC + halfLengthVC;
        }
        return riserTopVC - halfLengthVC;
    }

    private int getRiserBaseCoord() {
        int riserTopVC = this.getRiserTopCoord();
        int riserMaxVC = Math.max(riserTopVC, this.m_nBaseCoord);
        int riserMinVC = Math.min(this.m_nBaseCoord, riserTopVC);
        if (this.m_graphType.isPercent()) {
            if (this.m_bPrevCoordValid) {
                return Math.min(riserMaxVC, this.m_nPrevCoord);
            }
            if (this.m_invertedRiser) {
                return riserMaxVC;
            }
            return riserMinVC;
        }
        if (this.m_graphType.isStacked() && this.m_fStackedCumVal != 0.0) {
            double ratio = this.m_fDataValue / this.m_fStackedCumVal;
            int riserSizeVC = (int)((double)Math.abs(riserMaxVC - riserMinVC) * ratio);
            if (this.m_invertedRiser) {
                return riserTopVC + riserSizeVC;
            }
            return riserTopVC - riserSizeVC;
        }
        return this.m_nBaseCoord;
    }

    protected Rectangle calcPositionBase() {
        Rectangle rPos = this.calcPositionCenterTop();
        int baseVC = this.getRiserBaseCoord();
        if (this.m_bHoriz) {
            rPos.x = baseVC;
        } else {
            rPos.y = baseVC;
            if (this.m_invertedRiser) {
                rPos.y -= this.m_dimLabel.height;
            }
        }
        return rPos;
    }
}

