/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.math;

import com.businessobjects.visualization.pfjgraphics.rendering.common.math.BadNumber;

public final class FloatingPoint {
    public static final Number ZERO = new Double(0.0);
    public static final Number ONE = new Double(1.0);
    public static final double REALLY_BIG_NUMBER = 1.0E20;
    public static final double DEFAULT_TOLERANCE;
    private static double TOLERANCE;

    private FloatingPoint() {
    }

    public static double getTolerance() {
        return TOLERANCE;
    }

    public static void setTolerance(double newValue) {
        TOLERANCE = newValue;
    }

    public static boolean approxEqual(double a, double b) {
        return FloatingPoint.approxEqual(a, b, TOLERANCE);
    }

    public static boolean approxEqual(double a, double b, double tolerance) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            int result = FloatingPoint.compare(a, b);
            return 0 == result;
        }
        if (a == 0.0 || b == 0.0) {
            return Math.abs(a - b) <= tolerance;
        }
        return Math.abs((a - b) / a) <= tolerance;
    }

    public static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static boolean approxEqual(Number a, Number b) {
        return FloatingPoint.approxEqual(a.doubleValue(), b.doubleValue(), TOLERANCE);
    }

    public static boolean approxEqual(Number a, Number b, double tolerance) {
        return FloatingPoint.approxEqual(a.doubleValue(), b.doubleValue(), tolerance);
    }

    public static boolean nonzero(double a) {
        return !FloatingPoint.approxEqual(a, 0.0);
    }

    public static boolean greaterThan(double a, double b) {
        return FloatingPoint.lessThan(b, a);
    }

    public static boolean lessThan(double a, double b) {
        boolean aNotNum = Double.isNaN(a);
        boolean bNotNum = Double.isNaN(b);
        if (aNotNum) {
            return false;
        }
        if (bNotNum) {
            return true;
        }
        return a - b < -TOLERANCE;
    }

    public static boolean between(double a, double min, double max) {
        return FloatingPoint.greaterThan(a, min) && FloatingPoint.lessThan(a, max);
    }

    public static boolean equalOrGreaterThan(double a, double b) {
        return FloatingPoint.approxEqual(a, b) || FloatingPoint.greaterThan(a, b);
    }

    public static boolean isInfinite(double value) {
        return value < -1.0E20 || value > 1.0E20;
    }

    public static boolean isNormalValue(Number number) {
        if (number instanceof BadNumber) {
            return false;
        }
        double value = number.doubleValue();
        if (Double.isNaN(value)) {
            return false;
        }
        return !Double.isInfinite(value);
    }

    static {
        TOLERANCE = DEFAULT_TOLERANCE = Math.exp(-24.0);
    }
}

