/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.gauges;

import com.businessobjects.visualization.pfjgraphics.rendering.common.math.FloatingPoint;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.AutoScaleBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IAutoScale;

public class GaugeAutoScaleBase
extends AutoScaleBase
implements IAutoScale {
    boolean m_bSmallStep;

    public GaugeAutoScaleBase(boolean bAutoScaleMin, boolean bAutoScaleMax, boolean bAutoScaleStep, double dManualStep, boolean bSmallStep) {
        super(bAutoScaleMin, bAutoScaleMax, bAutoScaleStep, dManualStep);
        this.m_bSmallStep = bSmallStep;
    }

    public GaugeAutoScaleBase(boolean bAutoScaleMin, boolean bAutoScaleMax, boolean bAutoScaleStep, double dManualStep, boolean bLog, double dLogBase, boolean bSmallStep) {
        super(bAutoScaleMin, bAutoScaleMax, bAutoScaleStep, dManualStep, bLog, dLogBase);
        this.m_bSmallStep = bSmallStep;
    }

    protected double calcMultiplier(double dSpread) {
        double dMultiplier;
        long nCommonLogSpread;
        double dCommonLogSpread = Math.log(dSpread) / Math.log(10.0);
        if (FloatingPoint.approxEqual(dCommonLogSpread, nCommonLogSpread = Math.round(dCommonLogSpread))) {
            dMultiplier = Math.pow(10.0, nCommonLogSpread - (long)(this.m_bSmallStep ? 2 : 1));
        } else {
            dMultiplier = Math.pow(10.0, Math.floor(dCommonLogSpread) - (double)(this.m_bSmallStep ? 1 : 0));
            if ((int)(dSpread / dMultiplier) - 1 == 0) {
                dMultiplier = Math.pow(10.0, Math.floor(dCommonLogSpread) - (double)(this.m_bSmallStep ? 2 : 1));
            }
        }
        return dMultiplier;
    }
}

