/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common;

import java.awt.Font;

public final class FontCache {
    public static final Font FONT_ARIAL_9 = new Font("Arial", 0, 9);
    public static final Font FONT_DEFAULT_9 = new Font("Default", 0, 9);
    public static final Font FONT_DEFAULT_10 = new Font("Default", 0, 10);
    public static final Font FONT_DIALOG_11 = new Font("Dialog", 0, 11);
    public static final Font FONT_DIALOG_11_BOLD = new Font("Dialog", 1, 11);
    public static final Font FONT_DIALOG_12_BOLD = new Font("Dialog", 1, 12);
    public static final Font FONT_HELVETICA_10 = new Font("Helvetica", 0, 10);
    public static final Font FONT_HELVETICA_12_BOLD = new Font("Helvetica", 1, 12);
    public static final Font FONT_HELVETICA_24_BOLD = new Font("Helvetica", 1, 24);
    public static final Font FONT_SANSSERIF_10 = new Font("SansSerif", 0, 10);
    private static final int NUM_FONTS = 50;
    private static final int NOT_FOUND = -1;
    private static final FontCacheElement[] s_fontStuffArray = new FontCacheElement[50];
    private static int s_nCount = 0;

    private FontCache() {
    }

    private static void addToCache(String szFontName, int nFontStyle, float nFontSize, Font font) {
        FontCacheElement fso = new FontCacheElement(szFontName, nFontStyle, nFontSize, font, s_nCount);
        int lru = s_nCount;
        int lruPos = 49;
        for (int i = 0; i < 50; ++i) {
            if (s_fontStuffArray[i] == null) {
                FontCache.s_fontStuffArray[i] = fso;
                return;
            }
            if (FontCache.s_fontStuffArray[i].m_nCount >= lru) continue;
            lru = FontCache.s_fontStuffArray[i].m_nCount;
            lruPos = i;
        }
        FontCache.s_fontStuffArray[lruPos] = fso;
    }

    private static int cachePosition(String szFontName, int nFontStyle, float nFontSize) {
        FontCacheElement fso;
        int pos = -1;
        for (int i = 0; i < 50 && (fso = s_fontStuffArray[i]) != null; ++i) {
            if (fso.m_fontSize != nFontSize || fso.m_fontStyle != nFontStyle || !fso.m_fontName.equals(szFontName)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static Font getFont(String szFontName, int nFontStyle, float nFontSize) {
        Font font;
        int index = FontCache.cachePosition(szFontName, nFontStyle, nFontSize);
        ++s_nCount;
        if (index == -1) {
            font = new Font(szFontName, nFontStyle, (int)nFontSize);
            if (nFontSize - (float)((int)nFontSize) > 0.0f) {
                font = font.deriveFont(nFontSize);
            }
            FontCache.addToCache(szFontName, nFontStyle, nFontSize, font);
        } else {
            font = FontCache.s_fontStuffArray[index].m_font;
            FontCache.s_fontStuffArray[index].m_nCount = s_nCount;
        }
        return font;
    }

    static class FontCacheElement {
        String m_fontName;
        int m_fontStyle;
        float m_fontSize;
        Font m_font;
        int m_nCount;

        public FontCacheElement(String szFontName, int nFontStyle, float nFontSize, Font font, int counter) {
            this.m_fontName = szFontName;
            this.m_fontStyle = nFontStyle;
            this.m_fontSize = nFontSize;
            this.m_font = font;
            this.m_nCount = counter;
        }
    }
}

