/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphicengine.GraphicEngine;
import com.businessobjects.visualization.legend.IGraphicLegend;
import com.businessobjects.visualization.pfjgraphics.PFJEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartNotSupportedException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import com.businessobjects.visualization.rendering.RenderEngine;
import com.businessobjects.visualization.window.WindowSize;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PFJGraphicEngineImpl
extends GraphicEngine {
    public RenderEngine process(GraphicInstance context, int outputType, int retrieveMap) {
        PFJEngine pfjEngine = PFJEngine.createPFJEngine(context);
        if (outputType == 0) {
            return null;
        }
        return pfjEngine.process(outputType, retrieveMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importNativeTemplate(GraphicInstance graphicInstance, InputStream is) {
        try {
            PFJEngine.import3tf(graphicInstance, is);
        }
        catch (IOException e) {
            throw new VisualizationRuntimeException("VIZ_00001_ERR_CHARPROVIDER_ERROR", (Throwable)e);
        }
        catch (TTFLoadException e) {
            throw new VisualizationRuntimeException("VIZ_00001_ERR_CHARPROVIDER_ERROR", (Throwable)e);
        }
        catch (ChartNotSupportedException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new VisualizationRuntimeException("VIZ_00001_ERR_CHARPROVIDER_ERROR", (Throwable)e);
            }
        }
    }

    public void exportNativeTemplate(GraphicInstance graphicInstance, OutputStream os) {
        try {
            PFJEngine.export3tf(graphicInstance, os);
        }
        catch (IOException e) {
            throw new VisualizationRuntimeException("VIZ_00001_ERR_CHARPROVIDER_ERROR", (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                throw new VisualizationRuntimeException("VIZ_00001_ERR_CHARPROVIDER_ERROR", (Throwable)e);
            }
        }
    }

    public RenderEngine process(GraphicInstance instance, int outputType, int retrieveMap, boolean isOverview) {
        return this.process(instance, outputType, retrieveMap);
    }

    public boolean supportsWindowing(PublicGraphicDef publicGraphicDef) {
        return false;
    }

    public WindowSize getDataWindowBestSize(GraphicInstance instance) {
        return null;
    }

    public IGraphicLegend getLegend(GraphicInstance instance, int outputType) {
        return null;
    }

    public void initSettingsDependency(GraphicInstance instance) {
    }

    public WindowSize getDataWindowBestSize(GraphicInstance instance, int[] axesLimit) {
        throw new NotImplementedException();
    }

    public WindowSize getDataWindowMaximumSize(GraphicInstance instance) {
        throw new NotImplementedException();
    }
}

