/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.events;

import com.businessobjects.visualization.internal.events.EventListeners;
import com.businessobjects.visualization.internal.events.IPropertyListener;
import com.businessobjects.visualization.internal.events.PropertyEvent;
import java.io.Serializable;

public final class PropertyEventHelper
implements Serializable {
    private final EventListeners listeners = new EventListeners();
    private final Object source;

    public PropertyEventHelper(Object source) {
        this.source = source;
    }

    public void addListener(IPropertyListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(IPropertyListener listener) {
        this.listeners.removeListener(listener);
    }

    public void firePropertyChanged(Object propertyID, Object oldValue, Object newValue) {
        Object[] ls = this.listeners.getListeners();
        if (ls.length > 0) {
            PropertyEvent event = new PropertyEvent(this.source, propertyID, oldValue, newValue);
            for (int i = 0; i < ls.length; ++i) {
                IPropertyListener listener = (IPropertyListener)ls[i];
                listener.propertyChanged(event);
            }
        }
    }
}

