/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;

public final class VisuTextureType {
    public static final int I_FIT = 0;
    public static final int I_TILE = 1;
    public static final int I_CENTER = 2;
    private static final String[] SVALUES = new String[]{"FIT", "TILE", "CENTER"};
    public static final VisuTextureType FIT = new VisuTextureType(0);
    public static final VisuTextureType TILE = new VisuTextureType(1);
    public static final VisuTextureType CENTER = new VisuTextureType(2);
    private final int value_;

    private VisuTextureType(int value) {
        this.value_ = value;
    }

    public int value() {
        return this.value_;
    }

    public String toString() {
        return SVALUES[this.value_];
    }

    public static VisuTextureType fromString(String s) {
        int type = 0;
        try {
            type = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new VisualizationRuntimeException("VIZ_00130_ERR_INVALID_STRING_TO_IN", new Object[]{s});
        }
        return VisuTextureType.fromInt(type);
    }

    static VisuTextureType fromInt(int type) {
        VisuTextureType textureType = null;
        switch (type) {
            case 0: {
                textureType = FIT;
                break;
            }
            case 1: {
                textureType = TILE;
                break;
            }
            case 2: {
                textureType = CENTER;
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00131_ERR_INVALID_TYPE_TO_INIT", new Object[]{new Integer(type)});
            }
        }
        return textureType;
    }
}

