/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.common.internal.VisuVersionManager;
import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.graphic.VisuTemplateType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLProperty;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLRegion;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class VisuTemplate
implements Cloneable {
    private static final String VISU_TEMPLATE_ELT = "VisuTemplate";
    private static final String GRAPHIC_ELT = "Graphic";
    private static final String ID_ATT = "Id";
    private static final String NAME_ATT = "Name";
    private static final String TYPE_ATT = "Type";
    private static final String VERSION_ATTR = "Version";
    private XMLGraphic xmlGraphic_;
    private VisuTemplateType type_;
    private String id_;
    private String name_;
    private VisuVersion version_;

    VisuTemplate() {
    }

    VisuTemplate(String id, String name, VisuVersion version, VisuTemplateType type, XMLGraphic xg) {
        this.xmlGraphic_ = xg;
        this.type_ = type;
        this.id_ = id;
        this.name_ = name;
        this.version_ = version;
    }

    public String getId() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public VisuTemplateType getType() {
        return this.type_;
    }

    public boolean unmarshall(XmlReader reader) {
        boolean result = true;
        try {
            reader.next();
            if (reader.getEventType() == XmlEventType.START_ELEMENT && reader.getName() != null && reader.getName().equals(VISU_TEMPLATE_ELT)) {
                this.processAttribute(reader);
            } else {
                result = false;
            }
            while (result && reader.next() != XmlEventType.END_DOCUMENT && (reader.getEventType() != XmlEventType.END_ELEMENT || reader.getName() == null || !reader.getName().equals(VISU_TEMPLATE_ELT))) {
                String sNode = reader.getName();
                if (sNode == null || !sNode.equals(GRAPHIC_ELT)) continue;
                VisuVersionManager vvm = new VisuVersionManager("0.0");
                XmlReaderVersion xrv = new XmlReaderVersion(reader, vvm.getCurrentVersion(), this.version_);
                this.xmlGraphic_ = new XMLGraphic();
                this.xmlGraphic_.unmarshall(xrv);
            }
        }
        catch (XmlException e) {
            throw new VisualizationInternalException(e);
        }
        return result;
    }

    private void processAttribute(XmlReader reader) throws XmlException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String prefixName = reader.getAttributePrefix(i);
            String attName = reader.getAttributeName(i);
            String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
            if (finalName.equals(ID_ATT)) {
                this.id_ = reader.getAttributeValue(i);
                continue;
            }
            if (finalName.equals(NAME_ATT)) {
                this.name_ = reader.getAttributeValue(i);
                continue;
            }
            if (finalName.equals(TYPE_ATT)) {
                this.type_ = VisuTemplateType.fromString(reader.getAttributeValue(i));
                continue;
            }
            if (!finalName.equals(VERSION_ATTR)) continue;
            this.version_ = new VisuVersion(reader.getAttributeValue(i));
        }
        if (this.version_ == null) {
            this.version_ = new VisuVersion("1.0.0.0");
        }
    }

    public void marshall(XmlWriter xw) {
        try {
            xw.startElement(VISU_TEMPLATE_ELT);
            if (this.id_ != null) {
                xw.attribute(null, ID_ATT, this.id_);
            }
            if (this.name_ != null) {
                xw.attribute(null, NAME_ATT, this.name_);
            }
            if (this.type_ != null) {
                xw.attribute(null, TYPE_ATT, this.type_.toString());
            }
            if (this.version_ != null) {
                xw.attribute(null, VERSION_ATTR, this.version_.getXmlVersion());
            }
            if (this.xmlGraphic_ != null) {
                xw.startElement(GRAPHIC_ELT);
                this.xmlGraphic_.marshall2(xw);
                xw.endElement(GRAPHIC_ELT);
            }
            xw.endElement(VISU_TEMPLATE_ELT);
        }
        catch (XmlException e) {
            throw new VisualizationInternalException(e);
        }
    }

    XMLGraphic getXmlGraphic() {
        return this.xmlGraphic_;
    }

    public boolean isInTemplate(String regionId, String propertyId) {
        XMLProperty xp;
        boolean result = false;
        if (regionId == null || propertyId == null) {
            return false;
        }
        XMLRegion xr = this.getRegion(regionId, this.xmlGraphic_.m_list_Region);
        if (xr != null && (xp = this.getProperty(propertyId, xr.m_list_Property)) != null) {
            result = true;
        }
        return result;
    }

    public boolean isInTemplate(String regionId) {
        boolean result = false;
        if (regionId == null) {
            return false;
        }
        XMLRegion xr = this.getRegion(regionId, this.xmlGraphic_.m_list_Region);
        if (xr != null && xr.m_a_Visibility != -1) {
            result = true;
        }
        return result;
    }

    private XMLRegion getRegion(String regionId, ArrayList list) {
        if (list == null) {
            return null;
        }
        XMLRegion result = null;
        Iterator iter = list.iterator();
        while (result == null && iter.hasNext()) {
            XMLRegion xr = (XMLRegion)iter.next();
            if (xr.m_a_Id.equals(regionId)) {
                result = xr;
                continue;
            }
            result = this.getRegion(regionId, xr.m_list_Region);
        }
        return result;
    }

    private XMLProperty getProperty(String propertyId, ArrayList list) {
        if (list == null) {
            return null;
        }
        XMLProperty result = null;
        Iterator iter = list.iterator();
        while (result == null && iter.hasNext()) {
            XMLProperty xp = (XMLProperty)iter.next();
            if (xp.m_a_Id.equals(propertyId)) {
                result = xp;
                continue;
            }
            result = this.getProperty(propertyId, xp.m_list_Property);
        }
        return result;
    }

    public void merge(VisuTemplate vt) {
        XMLGraphic xg = vt.copy("", "").getXmlGraphic();
        for (int i = 0; i < xg.m_list_Region.size(); ++i) {
            XMLRegion xr = (XMLRegion)xg.m_list_Region.get(i);
            this.mergeRegion(this.xmlGraphic_.m_list_Region, xr);
        }
    }

    private void mergeRegion(ArrayList regions, XMLRegion xr) {
        boolean find = false;
        for (int i = 0; i < regions.size() && !find; ++i) {
            XMLRegion xrMaster = (XMLRegion)regions.get(i);
            if (!xrMaster.m_a_Id.equals(xr.m_a_Id)) continue;
            find = true;
            this.mergeProperties(xrMaster, xr);
        }
        if (!find) {
            this.copyRegion(regions, xr);
        }
    }

    private void copyRegion(ArrayList regions, XMLRegion xr) {
        regions.add(xr);
    }

    private void mergeProperties(XMLRegion xrMaster, XMLRegion xr) {
        boolean find = false;
        for (int i = 0; i < xr.m_list_Property.size() && !find; ++i) {
            XMLProperty xp = (XMLProperty)xr.m_list_Property.get(i);
            this.mergeProperties(xrMaster.m_list_Property, xp);
        }
    }

    private void mergeProperties(ArrayList properties, XMLProperty xp) {
        boolean find = false;
        for (int i = 0; i < properties.size() && !find; ++i) {
            XMLProperty xptmp = (XMLProperty)properties.get(i);
            if (!xptmp.m_a_Id.equals(xp.m_a_Id)) continue;
            find = true;
        }
        if (!find) {
            properties.add(xp);
        }
    }

    public VisuTemplate copy(String id, String name) {
        XMLGraphic xg = new XMLGraphic();
        xg.m_a_Id = this.xmlGraphic_.m_a_Id;
        xg.m_GlobalValue = this.xmlGraphic_.m_GlobalValue;
        for (int i = 0; i < this.xmlGraphic_.m_list_Region.size(); ++i) {
            XMLRegion xr = (XMLRegion)this.xmlGraphic_.m_list_Region.get(i);
            xg.m_list_Region.add(this.copyRegion(xr));
        }
        VisuTemplate vt = new VisuTemplate(id, name, this.version_, this.type_, xg);
        return vt;
    }

    private XMLRegion copyRegion(XMLRegion xr) {
        XMLRegion result = new XMLRegion();
        result.m_a_Id = xr.m_a_Id;
        result.m_a_Index = xr.m_a_Index;
        result.m_a_Type = xr.m_a_Type;
        result.m_a_Visibility = xr.m_a_Visibility;
        for (int i = 0; i < xr.m_list_Property.size(); ++i) {
            XMLProperty xp = (XMLProperty)xr.m_list_Property.get(i);
            result.m_list_Property.add(this.copyProperty(xp));
        }
        return result;
    }

    private XMLProperty copyProperty(XMLProperty xp) {
        XMLProperty result = new XMLProperty();
        result.m_a_Id = xp.m_a_Id;
        result.m_a_Type = xp.m_a_Type;
        result.m_Value = xp.m_Value;
        return result;
    }

    public VisuVersion getVersion() {
        return this.version_;
    }
}

