/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuRGBA
extends VisuObject {
    private static final int PARAMSIZE = 4;
    private static VisuObjectType type = VisuObjectType.RGBA;
    private int red_;
    private int green_;
    private int blue_;
    private int alpha_;

    public VisuRGBA(int r, int g, int b) {
        this.red_ = r;
        this.green_ = g;
        this.blue_ = b;
        this.alpha_ = 0;
        this.checkValidity(null);
    }

    public VisuRGBA(int r, int g, int b, int a) {
        this.red_ = r;
        this.green_ = g;
        this.blue_ = b;
        this.alpha_ = a;
        this.checkValidity(null);
    }

    public VisuRGBA(int argb) {
        this.alpha_ = argb >> 24 & 0xFF;
        this.red_ = argb >> 16 & 0xFF;
        this.green_ = argb >> 8 & 0xFF;
        this.blue_ = argb & 0xFF;
        this.checkValidity(null);
    }

    public VisuRGBA(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public String toString() {
        String s = "r:" + this.red_ + " g:" + this.green_ + " b:" + this.blue_ + " a:" + this.alpha_;
        return s;
    }

    public String toRGBHexaString() {
        String result = Integer.toHexString(0x1000000 | this.intValue()).toUpperCase();
        result = result.substring(1, result.length());
        return result;
    }

    public int intValue() {
        int res = (this.alpha_ << 24) + (this.red_ << 16) + (this.green_ << 8) + this.blue_;
        return res;
    }

    public VisuObjectType getType() {
        return type;
    }

    public int getRed() {
        return this.red_;
    }

    public int getGreen() {
        return this.green_;
    }

    public int getBlue() {
        return this.blue_;
    }

    public int getAlpha() {
        return this.alpha_;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuRGBA.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        String xmlValue = String.valueOf(this.red_) + ";" + this.green_ + ";" + this.blue_ + ";" + this.alpha_;
        return xmlValue;
    }

    protected Object clone() {
        VisuRGBA vo = (VisuRGBA)super.clone();
        return vo;
    }

    protected boolean checkValidity(Object params) {
        boolean result = true;
        if (this.red_ < 0 || this.red_ > 255 || this.green_ < 0 || this.green_ > 255 || this.blue_ < 0 || this.blue_ > 255 || this.alpha_ < 0 || this.alpha_ > 255) {
            throw new VisualizationInternalException("Invalid parameter for color red:" + this.red_ + " green:" + this.green_ + " blue:" + this.blue_ + " alpha:" + this.alpha_);
        }
        return result;
    }

    private void setXmlValue(String[] values) {
        this.checkParams(values, 4);
        this.red_ = Integer.decode(values[0]);
        this.green_ = Integer.decode(values[1]);
        this.blue_ = Integer.decode(values[2]);
        this.alpha_ = Integer.decode(values[3]);
        this.checkValidity(null);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuRGBA) {
            VisuRGBA vrgba = (VisuRGBA)obj;
            if (vrgba.red_ == this.red_ && vrgba.green_ == this.green_ && vrgba.blue_ == this.blue_ && vrgba.alpha_ == this.alpha_) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("red", new Integer(this.red_));
            jsonObj.put("green", new Integer(this.green_));
            jsonObj.put("blue", new Integer(this.blue_));
            jsonObj.put("alpha", new Integer(this.alpha_));
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuRGBA(JSONObject jobj) {
        try {
            this.red_ = jobj.getInt("red");
            this.green_ = jobj.getInt("green");
            this.blue_ = jobj.getInt("blue");
            this.alpha_ = jobj.getInt("alpha");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

