/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuInteger
extends VisuObject {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$VisuInteger == null ? (class$com$businessobjects$visualization$graphic$VisuInteger = VisuInteger.class$("com.businessobjects.visualization.graphic.VisuInteger")) : class$com$businessobjects$visualization$graphic$VisuInteger));
    private static VisuObjectType type = VisuObjectType.INT;
    private int value_;
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$VisuInteger;

    public VisuInteger(int i) {
        this.value_ = i;
    }

    public VisuInteger(Integer i) {
        this.value_ = i;
    }

    public VisuInteger(String s) {
        this.setXmlValue(s);
    }

    public String toString() {
        String s = String.valueOf(this.value_);
        return s;
    }

    public int intValue() {
        return this.value_;
    }

    public VisuObjectType getType() {
        return type;
    }

    protected void setXmlValue(String xmlValue) {
        if (xmlValue == null) {
            throw new VisualizationRuntimeException("VIZ_00052_ERR_XMLVALUE_IS_NULL");
        }
        try {
            this.value_ = Integer.parseInt(xmlValue);
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("VisuInteger Invalid string : " + xmlValue));
            this.value_ = 0;
        }
    }

    protected String getXmlValue() {
        String xmlValue = String.valueOf(this.value_);
        return xmlValue;
    }

    protected Object clone() {
        return super.clone();
    }

    protected boolean checkValidity(Object param) {
        if (param != null) {
            VisuInteger[] vis = (VisuInteger[])param;
            int min = vis[0].intValue();
            int max = vis[1].intValue();
            int step = vis[2].intValue();
            int tmp = this.value_ - min;
            int idiv = tmp / step;
            double ddiv = (double)tmp / (double)step;
            if (this.value_ < min || this.value_ > max) {
                throw new VisualizationRuntimeException("VIZ_00126_ERR_VALUE___0___FOR_VISU", new Object[]{new Integer(this.value_), new Integer(min), new Integer(max)});
            }
            if (tmp != 0 && ddiv != (double)idiv) {
                throw new VisualizationRuntimeException("VIZ_00121_ERR_VALUE___0___IS_NOT_I", new Object[]{new Integer(this.value_), new Integer(step), new Integer(min)});
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuInteger) {
            VisuInteger vi = (VisuInteger)obj;
            if (vi.value_ == this.value_) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("value", new Integer(this.value_));
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuInteger(JSONObject jobj) {
        try {
            this.value_ = jobj.getInt("value");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

