/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.transform;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;
import com.businessobjects.visualization.dataexchange.data.impl.SimpleMemberImpl;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNodeArray;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.transform.Helper;
import com.businessobjects.visualization.dataexchange.transform.ITransform;
import java.util.ArrayList;

public class ProjectMeasuresTransform
implements ITransform {
    private final int axisIndex_;
    private final boolean bFront_;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$transform$ProjectMeasuresTransform == null ? (class$com$businessobjects$visualization$dataexchange$transform$ProjectMeasuresTransform = ProjectMeasuresTransform.class$("com.businessobjects.visualization.dataexchange.transform.ProjectMeasuresTransform")) : class$com$businessobjects$visualization$dataexchange$transform$ProjectMeasuresTransform));
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$transform$ProjectMeasuresTransform;

    public ProjectMeasuresTransform(int axisIndex, boolean bFront) {
        this.axisIndex_ = axisIndex;
        this.bFront_ = bFront;
    }

    public boolean isFront() {
        return this.bFront_;
    }

    public int getAxisIndex() {
        return this.axisIndex_;
    }

    public int getTransformType() {
        return 2;
    }

    public int getTransformMode() {
        return 129;
    }

    public DataHolder transform(DataHolder aDataHolder) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Project axisIndex:" + this.axisIndex_ + " bFront:" + this.bFront_));
        }
        DatasetDescriptor srcDatasetDescriptor = aDataHolder.getDataDescriptor().getDatasetDescriptor();
        DatasetAdapter srcDatasetAdapter = aDataHolder.getDataAdapter().getDataset();
        AnalysisAxis[] aaList = srcDatasetDescriptor.getAxisList();
        DatasetDescriptor destDatasetDescriptor = DatasetDescriptor.newInstance(srcDatasetDescriptor);
        AnalysisAxis destAxis = null;
        DimensionLabels[] dlList = new DimensionLabels[]{};
        boolean bNewAxis = false;
        if (this.axisIndex_ >= aaList.length) {
            destAxis = new AnalysisAxis();
            destDatasetDescriptor.addAxis(destAxis);
            bNewAxis = true;
        } else {
            destAxis = destDatasetDescriptor.getAxisList()[this.axisIndex_];
            dlList = aaList[this.axisIndex_].getDimensionLabelsList();
        }
        if (this.bFront_ && !bNewAxis) {
            int i;
            for (i = 0; i < dlList.length; ++i) {
                destAxis.removeDimensionLabels(dlList[i]);
            }
            destAxis.addDimensionLabels(DimensionLabels.MEASURENAMES_DIMENSION);
            for (i = 0; i < dlList.length; ++i) {
                destAxis.addDimensionLabels(dlList[i]);
            }
        } else {
            destAxis.addDimensionLabels(DimensionLabels.MEASURENAMES_DIMENSION);
        }
        int totalDimCount = dlList.length + 1;
        ArrayList[] dataArrays = new ArrayList[totalDimCount];
        double[][] newGrid = null;
        MeasureValues[] allMeasureValues = Helper.getAllMeasureValues(srcDatasetDescriptor);
        MeasureValuesAdapter[] allMeasureValuesAdapter = Helper.getAllMeasureValuesAdapter(srcDatasetAdapter);
        int nSeriesCount = allMeasureValuesAdapter[0].getGridCallback().getSeriesCount();
        int nSeriesLength = allMeasureValuesAdapter[0].getGridCallback().getSerie(0, 0).length;
        newGrid = this.axisIndex_ == 0 ? new double[nSeriesCount][nSeriesLength * allMeasureValues.length] : new double[nSeriesCount * allMeasureValues.length][nSeriesLength];
        IDimensionLabelsIterator rootIterator = bNewAxis ? null : srcDatasetAdapter.getLabelsIterator(this.axisIndex_, 0);
        int line = 0;
        if (bNewAxis) {
            dataArrays[0] = new ArrayList();
            for (int i = 0; i < allMeasureValues.length; ++i) {
                dataArrays[0].add(new SimpleMemberImpl(allMeasureValues[i].getId(), DataType.STRING, null, null));
                ProjectMeasuresTransform.setNewGridValue(this.axisIndex_, line, allMeasureValuesAdapter[i], line, newGrid);
                ++line;
            }
        } else if (!this.bFront_) {
            while (rootIterator.hasLeaves()) {
                IMember[] members = rootIterator.nextLeaf();
                for (int i = 0; i < allMeasureValues.length; ++i) {
                    ProjectMeasuresTransform.addMembers(members, dataArrays, this.bFront_);
                    if (dataArrays[totalDimCount - 1] == null) {
                        dataArrays[totalDimCount - 1] = new ArrayList();
                    }
                    dataArrays[totalDimCount - 1].add(new SimpleMemberImpl(allMeasureValues[i].getId(), DataType.STRING, null, null));
                    ProjectMeasuresTransform.setNewGridValue(this.axisIndex_, members[members.length - 1].getStartIndex(), allMeasureValuesAdapter[i], line++, newGrid);
                }
            }
        } else {
            for (int i = 0; i < allMeasureValues.length; ++i) {
                if (dataArrays[0] == null) {
                    dataArrays[0] = new ArrayList();
                }
                rootIterator.reset();
                while (rootIterator.hasLeaves()) {
                    IMember[] members = rootIterator.nextLeaf();
                    ProjectMeasuresTransform.addMembers(members, dataArrays, this.bFront_);
                    dataArrays[0].add(new SimpleMemberImpl(allMeasureValues[i].getId(), DataType.STRING, null, null));
                    ProjectMeasuresTransform.setNewGridValue(this.axisIndex_, members[members.length - 1].getStartIndex(), allMeasureValuesAdapter[i], line++, newGrid);
                }
            }
        }
        AnalysisAxisAdapter untouchedAxis = null;
        if (aaList.length > 1) {
            untouchedAxis = this.axisIndex_ == 0 ? srcDatasetAdapter.getAxisList()[1] : srcDatasetAdapter.getAxisList()[0];
        } else if (bNewAxis) {
            untouchedAxis = srcDatasetAdapter.getAxisList()[0];
        }
        DatasetAdapter destDatasetAdapter = ProjectMeasuresTransform.rebuildAdaptersFromRawArrays(dataArrays, newGrid, destDatasetDescriptor, untouchedAxis, this.axisIndex_);
        DataDescriptor destDataDescriptor = new DataDescriptor();
        destDataDescriptor.setDatasetDescriptor(destDatasetDescriptor);
        DataAdapter destDataAdapter = new DataAdapter();
        destDataAdapter.setDataset(destDatasetAdapter);
        return new DataHolder(destDataDescriptor, destDataAdapter);
    }

    private static void addMembers(IMember[] members, ArrayList[] dataArrays, boolean bFront) {
        int j;
        int n = j = bFront ? members.length : members.length - 1;
        for (int i = 0; i < members.length; ++i) {
            if (dataArrays[j] == null) {
                dataArrays[j] = new ArrayList();
            }
            dataArrays[j].add(members[i]);
            --j;
        }
    }

    private static DatasetAdapter rebuildAdaptersFromRawArrays(ArrayList[] dataArrays, double[][] newGrid, DatasetDescriptor newDescriptor, AnalysisAxisAdapter untouchedAxis, int axesIndex) {
        int i;
        DatasetAdapter da = newDescriptor.getDatasetAdapter();
        da.setFlat(true);
        if (untouchedAxis != null) {
            AnalysisAxisAdapter newAxis = da.getAxisList()[axesIndex == 0 ? 1 : 0];
            DimensionLabelsAdapter[] dlList = newAxis.getDimensionLabelsList();
            DimensionLabelsAdapter[] origList = untouchedAxis.getDimensionLabelsList();
            for (i = 0; i < dlList.length; ++i) {
                dlList[i].setData(origList[i].getData());
            }
        }
        AnalysisAxisAdapter newAxis2 = da.getAxisList()[axesIndex];
        DimensionLabelsAdapter[] newList = newAxis2.getDimensionLabelsList();
        for (int i2 = 0; i2 < dataArrays.length; ++i2) {
            int nCount = dataArrays[i2].size();
            TreeNode[] treeNodeList = null;
            String[] stringValueData = null;
            IMember currentMember = (IMember)dataArrays[i2].get(0);
            IMember parentMember = currentMember.getParentMember();
            if (parentMember != null) {
                treeNodeList = new TreeNode[nCount];
            } else if (currentMember.getDataType().equals(DataType.STRING)) {
                stringValueData = new String[nCount];
            } else {
                throw new VisualizationInternalException("Not yet supported type:" + currentMember.getDataType());
            }
            for (int j = 0; j < nCount; ++j) {
                currentMember = (IMember)dataArrays[i2].get(j);
                parentMember = currentMember.getParentMember();
                if (parentMember != null) {
                    if (currentMember.getArrayValueImpl() instanceof TreeNode) {
                        treeNodeList[j] = (TreeNode)currentMember.getArrayValueImpl();
                        continue;
                    }
                    throw new NotImplementedException();
                }
                stringValueData[j] = (String)currentMember.getValue();
            }
            if (treeNodeList != null) {
                newList[i2].setData(new TreeNodeArray(DataType.STRING, treeNodeList));
                continue;
            }
            newList[i2].setData(new StringLabelData(stringValueData));
        }
        MeasureValuesGroupAdapter[] mvgaList = da.getValueGroupList();
        for (i = 0; i < mvgaList.length; ++i) {
            MeasureValuesAdapter[] mvList = mvgaList[i].getMeasureValuesList();
            for (int j = 0; j < mvList.length; ++j) {
                mvList[j].setData(new DoubleValueData(newGrid));
            }
        }
        return da;
    }

    private static void setNewGridValue(int axesIndex, int oldLineIndex, MeasureValuesAdapter adapter, int newLineIndex, double[][] newGrid) {
        double[] checkData = null;
        if (axesIndex == 1 && newGrid.length > 1) {
            checkData = adapter.getGridCallback().getSerie(oldLineIndex, 0);
            newGrid[newLineIndex] = checkData;
        } else if (axesIndex == 0 && newGrid.length > 1) {
            int firstAxisLength = adapter.getGridCallback().getSeriesCount();
            checkData = new double[firstAxisLength];
            for (int i = 0; i < firstAxisLength; ++i) {
                checkData[i] = adapter.getGridCallback().getSerie(i, 0)[oldLineIndex];
                newGrid[i][newLineIndex] = checkData[i];
            }
        } else if (axesIndex == 0 && newGrid.length == 1) {
            checkData = new double[]{adapter.getGridCallback().valueAt(oldLineIndex, 0, 0)};
            newGrid[0][newLineIndex] = checkData[0];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

