/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.CalculationAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.definition.Calculation;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLCalculation;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValuesGroup;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValuesRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class MeasureValuesGroup
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$definition$MeasureValuesGroup == null ? (class$com$businessobjects$visualization$dataexchange$definition$MeasureValuesGroup = MeasureValuesGroup.class$("com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup")) : class$com$businessobjects$visualization$dataexchange$definition$MeasureValuesGroup).getName());
    public static final String DEFAULT_GROUPNAME = "Default";
    private String groupName_ = "Default";
    private ArrayList valueList_ = new ArrayList();
    private ArrayList calculationList_ = new ArrayList();
    private DatasetDescriptor dataset_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$definition$MeasureValuesGroup;

    public MeasureValuesGroup() {
    }

    protected MeasureValuesGroup(XMLMeasureValuesGroup xmlGroup, SerializationHelper sh) {
        this();
        this.groupName_ = xmlGroup.m_a_groupName;
        Iterator iter = xmlGroup.m_list_measureValuesRef.iterator();
        while (iter.hasNext()) {
            XMLMeasureValuesRef mesRef = (XMLMeasureValuesRef)iter.next();
            MeasureValues mv = (MeasureValues)sh.getObjectFromSerialUid(mesRef.m_a_dataContainerId.id);
            this.valueList_.add(mv);
        }
        iter = xmlGroup.m_list_calculation.iterator();
        while (iter.hasNext()) {
            XMLCalculation xmlCalc = (XMLCalculation)iter.next();
            this.calculationList_.add(new Calculation(xmlCalc, sh));
        }
    }

    public void clear() {
        Iterator iter = this.getMeasureValuesIterator();
        while (iter.hasNext()) {
            this.notifyRemoved((MeasureValues)iter.next());
        }
        iter = this.getCalculationIterator();
        this.valueList_.clear();
        this.calculationList_.clear();
        this.dataset_ = null;
    }

    public void addMeasureValues(MeasureValues aValue) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding to current:" + this + " mv:" + aValue));
        }
        this.valueList_.add(aValue);
        if (this.dataset_ != null && this.dataset_.getDataDescriptor() != null) {
            this.dataset_.getDataDescriptor().addDataContainer(aValue);
        }
    }

    private void notifyRemoved(MeasureValues measureValues) {
        if (this.dataset_ != null && this.dataset_.getDataDescriptor() != null) {
            this.dataset_.getDataDescriptor().notifyRemoveDataContainer(measureValues);
        }
    }

    public void removeMeasureValues(MeasureValues measureValues) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Removing to current:" + this + " mv:" + measureValues));
        }
        this.valueList_.remove(measureValues);
        this.notifyRemoved(measureValues);
    }

    public void addCalculation(Calculation aCalc) {
        this.calculationList_.add(aCalc);
    }

    public void removeCalculation(Calculation aCalc) {
        this.calculationList_.remove(aCalc);
    }

    public MeasureValues[] getMeasureValuesList() {
        return this.valueList_.toArray(new MeasureValues[0]);
    }

    public Calculation[] getCalculationList() {
        return this.calculationList_.toArray(new Calculation[0]);
    }

    public String getGroupName() {
        return this.groupName_;
    }

    public void setGroupName(String groupName) {
        this.groupName_ = groupName;
    }

    public DatasetDescriptor getDataset() {
        return this.dataset_;
    }

    public void setDataset(DatasetDescriptor aDataset) {
        this.dataset_ = aDataset;
    }

    protected MeasureValuesGroupAdapter getValueGroupAdapter() {
        MeasureValues[] valueList = this.getMeasureValuesList();
        MeasureValuesAdapter[] valueAdapters = new MeasureValuesAdapter[valueList.length];
        for (int i = 0; i < valueAdapters.length; ++i) {
            valueAdapters[i] = valueList[i].getValueAdapter();
        }
        Calculation[] calculations = this.getCalculationList();
        CalculationAdapter[] calculationAdapters = new CalculationAdapter[calculations.length];
        for (int i = 0; i < calculationAdapters.length; ++i) {
            calculationAdapters[i] = calculations[i].getCalculationAdapter();
        }
        return new MeasureValuesGroupAdapter(valueAdapters, calculationAdapters);
    }

    public Iterator getMeasureValuesIterator() {
        return this.valueList_.iterator();
    }

    public Iterator getCalculationIterator() {
        return this.calculationList_.iterator();
    }

    protected static MeasureValuesGroup newInstance(MeasureValuesGroup group) {
        MeasureValuesGroup newValueGroup = new MeasureValuesGroup();
        newValueGroup.setGroupName(group.getGroupName());
        Iterator iter = group.getMeasureValuesIterator();
        while (iter.hasNext()) {
            newValueGroup.addMeasureValues((MeasureValues)iter.next());
        }
        iter = group.getCalculationIterator();
        while (iter.hasNext()) {
            newValueGroup.addCalculation((Calculation)iter.next());
        }
        return newValueGroup;
    }

    public Object getXMLDelegate() {
        XMLMeasureValuesGroup xmlGroup = new XMLMeasureValuesGroup();
        xmlGroup.m_a_groupName = this.groupName_;
        Iterator iter = this.getMeasureValuesIterator();
        while (iter.hasNext()) {
            XMLMeasureValuesRef aRef = new XMLMeasureValuesRef();
            aRef.m_a_dataContainerId.id = ((MeasureValues)iter.next()).getUid();
            xmlGroup.m_list_measureValuesRef.add(aRef);
        }
        iter = this.getCalculationIterator();
        while (iter.hasNext()) {
            xmlGroup.m_list_calculation.add(((Calculation)iter.next()).getXMLDelegate());
        }
        return xmlGroup;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof MeasureValuesGroup)) {
            return false;
        }
        MeasureValuesGroup that = (MeasureValuesGroup)oThat;
        return Arrays.equals(this.getMeasureValuesList(), that.getMeasureValuesList()) && Arrays.equals(this.getCalculationList(), that.getCalculationList());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.getMeasureValuesList());
        result = HashCodeHelper.hash(result, this.getCalculationList());
        return result;
    }

    Collection getAllDataContainers() {
        return this.valueList_;
    }

    public int getMeasureValuesIndex(MeasureValues mv) {
        return this.valueList_.indexOf(mv);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MeasureValuesGroup[");
        buffer.append("calculationList_ = ").append(this.calculationList_);
        buffer.append(", groupName_ = ").append(this.groupName_);
        buffer.append(", valueList_ = ").append(this.valueList_);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

