/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.GroupingDimensionAdapter;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.GroupingDimension;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLAnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDimensionLabelsRef;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLGroupingDimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class AnalysisAxis
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$definition$AnalysisAxis == null ? (class$com$businessobjects$visualization$dataexchange$definition$AnalysisAxis = AnalysisAxis.class$("com.businessobjects.visualization.dataexchange.definition.AnalysisAxis")) : class$com$businessobjects$visualization$dataexchange$definition$AnalysisAxis));
    private ArrayList dimensionLabelsList_ = new ArrayList();
    private ArrayList groupingDimensionList_ = new ArrayList();
    private DatasetDescriptor dataset_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$definition$AnalysisAxis;

    public AnalysisAxis() {
    }

    protected AnalysisAxis(XMLAnalysisAxis xmlAxis, SerializationHelper sh) {
        this();
        Iterator iter = xmlAxis.m_list_dimensionLabelsRef.iterator();
        while (iter.hasNext()) {
            XMLDimensionLabelsRef dimRef = (XMLDimensionLabelsRef)iter.next();
            this.dimensionLabelsList_.add((DimensionLabels)sh.getObjectFromSerialUid(dimRef.m_a_dataContainerId.id));
        }
        iter = xmlAxis.m_list_groupingDimension.iterator();
        while (iter.hasNext()) {
            XMLGroupingDimension group = (XMLGroupingDimension)iter.next();
            this.groupingDimensionList_.add(new GroupingDimension(group, sh));
        }
    }

    public void clear() {
        Iterator iter = this.getDimensionLabelsIterator();
        while (iter.hasNext()) {
            this.notifyRemoved((DimensionLabels)iter.next());
        }
        iter = this.getGroupingDimensionIterator();
        this.dimensionLabelsList_.clear();
        this.groupingDimensionList_.clear();
        this.dataset_ = null;
    }

    public void addDimensionLabels(DimensionLabels aLabel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding to current:" + this + " dl:" + aLabel));
        }
        this.dimensionLabelsList_.add(aLabel);
        if (this.dataset_ != null && this.dataset_.getDataDescriptor() != null) {
            this.dataset_.getDataDescriptor().addDataContainer(aLabel);
        }
    }

    private void notifyRemoved(DimensionLabels aLabel) {
        if (this.dataset_ != null && this.dataset_.getDataDescriptor() != null) {
            this.dataset_.getDataDescriptor().notifyRemoveDataContainer(aLabel);
        }
    }

    public void removeDimensionLabels(DimensionLabels aLabel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Removing from current:" + this + " dl:" + aLabel));
        }
        this.dimensionLabelsList_.remove(aLabel);
        this.notifyRemoved(aLabel);
    }

    public void addGroupingDimension(GroupingDimension groupingDimension) {
        this.groupingDimensionList_.add(groupingDimension);
    }

    public void removeGroupingDimension(GroupingDimension groupingDimension) {
        this.groupingDimensionList_.remove(groupingDimension);
    }

    public DimensionLabels[] getDimensionLabelsList() {
        return this.dimensionLabelsList_.toArray(new DimensionLabels[0]);
    }

    public GroupingDimension[] getGroupingDimensionList() {
        return this.groupingDimensionList_.toArray(new GroupingDimension[0]);
    }

    protected AnalysisAxisAdapter getAxisAdapter() {
        DimensionLabels[] labelList = this.getDimensionLabelsList();
        DimensionLabelsAdapter[] labelAdapters = new DimensionLabelsAdapter[labelList.length];
        for (int i = 0; i < labelAdapters.length; ++i) {
            labelAdapters[i] = labelList[i].getLabelAdapter();
        }
        GroupingDimension[] groupingList = this.getGroupingDimensionList();
        GroupingDimensionAdapter[] groupingAdapters = new GroupingDimensionAdapter[groupingList.length];
        for (int i = 0; i < groupingAdapters.length; ++i) {
            groupingAdapters[i] = groupingList[i].getCalculationAdapter();
        }
        return new AnalysisAxisAdapter(labelAdapters, groupingAdapters);
    }

    public DatasetDescriptor getDataset() {
        return this.dataset_;
    }

    public void setDataset(DatasetDescriptor aDataset) {
        this.dataset_ = aDataset;
    }

    private Iterator getDimensionLabelsIterator() {
        return this.dimensionLabelsList_.iterator();
    }

    private Iterator getGroupingDimensionIterator() {
        return this.groupingDimensionList_.iterator();
    }

    protected static AnalysisAxis newInstance(AnalysisAxis axis) {
        AnalysisAxis newAxis = new AnalysisAxis();
        Iterator iter = axis.getDimensionLabelsIterator();
        while (iter.hasNext()) {
            newAxis.addDimensionLabels((DimensionLabels)iter.next());
        }
        iter = axis.getGroupingDimensionIterator();
        while (iter.hasNext()) {
            newAxis.addGroupingDimension((GroupingDimension)iter.next());
        }
        return newAxis;
    }

    public Object getXMLDelegate() {
        XMLAnalysisAxis xmlAxis = new XMLAnalysisAxis();
        Iterator iter = this.getDimensionLabelsIterator();
        while (iter.hasNext()) {
            XMLDimensionLabelsRef aRef = new XMLDimensionLabelsRef();
            aRef.m_a_dataContainerId.id = ((DimensionLabels)iter.next()).getUid();
            xmlAxis.m_list_dimensionLabelsRef.add(aRef);
        }
        iter = this.getGroupingDimensionIterator();
        while (iter.hasNext()) {
            xmlAxis.m_list_groupingDimension.add((XMLGroupingDimension)((GroupingDimension)iter.next()).getXMLDelegate());
        }
        return xmlAxis;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof AnalysisAxis)) {
            return false;
        }
        AnalysisAxis that = (AnalysisAxis)oThat;
        return Arrays.equals(this.getDimensionLabelsList(), that.getDimensionLabelsList()) && Arrays.equals(this.getGroupingDimensionList(), that.getGroupingDimensionList());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.getDimensionLabelsList());
        result = HashCodeHelper.hash(result, this.getGroupingDimensionList());
        return result;
    }

    Collection getAllDataContainers() {
        ArrayList al = new ArrayList();
        al.addAll(this.dimensionLabelsList_);
        return al;
    }

    public int getDimensionLabelsIndex(DimensionLabels dl) {
        Iterator iter = this.dimensionLabelsList_.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (((DimensionLabels)iter.next()).equals(dl)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AnalysisAxis[");
        buffer.append(", dimensionLabelsList_ = ").append(this.dimensionLabelsList_);
        buffer.append(", groupingDimensionList_ = ").append(this.groupingDimensionList_);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

