/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataType;
import com.businessobjects.visualization.dataexchange.data.impl.Helper;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;

public class DoubleLabelData
implements Data {
    private Double[] values_;
    private Properties[] properties_;

    public DoubleLabelData(Double[] values) {
        this.setValues(values, DataType.DOUBLE, 1);
    }

    public DoubleLabelData(Double[] values, Properties[] props) throws InvalidDataTypeException {
        this(values);
        this.setProperties(props);
    }

    public DoubleLabelData(XMLData xmlValues, SerializationHelper sh) {
        try {
            JSONArray startArray = new JSONArray(xmlValues.m_encodedvalues);
            this.values_ = new Double[startArray.length()];
            for (int i = 0; i < this.values_.length; ++i) {
                this.values_[i] = new Double(startArray.getDouble(i));
            }
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
    }

    public Object getValues() {
        return this.values_;
    }

    public void setValues(Object values, DataType aType, int iCardinality) throws InvalidDataTypeException {
        if (!(values instanceof Double[]) || aType != DataType.DOUBLE || iCardinality != 1) {
            throw new InvalidDataTypeException("VIZ_00019_ERR_DOUBLE___EXPECTED__");
        }
        this.values_ = (Double[])values;
    }

    public DataType getType() {
        return DataType.DOUBLE;
    }

    public int getValuesCount(int iCardinality) {
        if (iCardinality > 3 || iCardinality < 1) {
            throw new InvalidDataTypeException("VIZ_00033_ERR_CARDINALIYT_1_TO_3", new Object[]{String.valueOf(iCardinality)});
        }
        if (iCardinality == 1) {
            return this.values_.length;
        }
        return 0;
    }

    public int getCardinality() {
        return 1;
    }

    public Object getXMLDelegate() {
        XMLData data = new XMLData();
        data.m_a_cardinality = 1;
        data.m_dataType = new XMLDataType(1);
        data.m_dataStructure = Helper.toXML(DataStructure.SIMPLE);
        try {
            data.m_encodedvalues = this.toJSONString();
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00003_ERR_SERIALIZATION_ERROR", e);
        }
        return data;
    }

    public DataStructure getStructure() {
        return DataStructure.SIMPLE;
    }

    public boolean supportProperties() {
        return true;
    }

    public void setProperties(Object properties) {
        if (properties != null && !(properties instanceof Properties[])) {
            throw new InvalidDataTypeException("VIZ_00020_ERR_PROPERTIES___EXPECTE");
        }
        this.properties_ = (Properties[])properties;
    }

    public Object getProperties() {
        return this.properties_;
    }

    public String toJSONString() throws JSONException {
        return new JSONArray(this.values_).toString();
    }
}

