/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.graph.impl;

import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.graph.IAxisTree;
import com.businessobjects.visualization.dataexchange.data.graph.INode;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNodeArray;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import java.util.Iterator;
import java.util.Properties;

public class DimDataBuilder {
    private IAxisTree tree_;
    private int rowCount_;
    private AnalysisAxis aaDescriptor_;
    private AnalysisAxisAdapter aaAdapter_;
    private String[][] flatData_;
    private Properties[][] flatProperties_;
    private TreeNode[] treeNodes_;
    private TreeNode[][] treeNodeArrays_;

    public DimDataBuilder(IAxisTree tree, int rowCount, AnalysisAxis aaDescriptor, AnalysisAxisAdapter aaAdapter) {
        this.tree_ = tree;
        this.aaDescriptor_ = aaDescriptor;
        this.aaAdapter_ = aaAdapter;
        this.rowCount_ = rowCount;
    }

    private boolean wasProcessed() {
        return this.flatData_ != null || this.treeNodeArrays_ != null;
    }

    private void process() {
        if (this.wasProcessed()) {
            return;
        }
        DimensionLabels[] dlList = this.aaDescriptor_.getDimensionLabelsList();
        this.flatData_ = new String[dlList.length][this.rowCount_];
        this.flatProperties_ = new Properties[dlList.length][0];
        this.treeNodes_ = new TreeNode[dlList.length];
        this.treeNodeArrays_ = new TreeNode[dlList.length][this.rowCount_];
        Iterator dfsIter = this.tree_.getDFSIterator(this.tree_.getRootNode());
        while (dfsIter.hasNext()) {
            INode node = (INode)dfsIter.next();
            int dimIndex = node.getDimensionIndex();
            if (dimIndex == -1) continue;
            System.out.println("dfs, node:" + node.getValue());
            this.updateSimpleData(dimIndex, node, null);
        }
        DimensionLabelsAdapter[] dlaList = this.aaAdapter_.getDimensionLabelsList();
        for (int i = 0; i < dlaList.length; ++i) {
            if (dlList[i].getDataStructure() == DataStructure.TREE) {
                dlaList[i].setData(new TreeNodeArray(dlList[i].getDataType(), this.treeNodeArrays_[i]));
                continue;
            }
            if (dlList[i].getDataType() != DataType.STRING) {
                throw new NotImplementedException();
            }
            dlaList[i].setData(new StringLabelData(this.flatData_[i], this.flatProperties_[i]));
        }
    }

    private void updateSimpleData(int dimIndex, INode node, INode walkingNode) {
        int absoluteIndex;
        int n = absoluteIndex = walkingNode == null ? node.getAbsoluteIndex() : walkingNode.getAbsoluteIndex();
        if (absoluteIndex == -1) {
            this.getTreeNode(dimIndex, node);
            Iterator descendantsIter = this.tree_.getBFSIterator(walkingNode == null ? node : walkingNode);
            while (descendantsIter.hasNext()) {
                INode childNode = (INode)descendantsIter.next();
                System.out.println("bfs, node:" + childNode.getValue());
                if (childNode.getAbsoluteIndex() == -1 || childNode.getDimensionIndex() == dimIndex) continue;
                this.updateSimpleData(dimIndex, node, childNode);
            }
            return;
        }
        if (this.aaDescriptor_.getDimensionLabelsList()[dimIndex].getDataStructure() == DataStructure.TREE) {
            this.treeNodeArrays_[dimIndex][absoluteIndex] = this.getTreeNode(dimIndex, node);
        } else {
            this.flatData_[dimIndex][absoluteIndex] = (String)node.getValue();
            if (node.getProperties() != null) {
                if (this.flatProperties_[dimIndex].length == 0) {
                    this.flatProperties_[dimIndex] = new Properties[this.rowCount_];
                }
                this.flatProperties_[dimIndex][absoluteIndex] = node.getProperties();
            }
        }
    }

    private TreeNode addNode(TreeNode startNode, Object parentValue, int level, Object value, Properties props) {
        if (parentValue == null || level == 0) {
            return null;
        }
        if (startNode.getValue().equals(parentValue) && startNode.getLevel() == level - 1) {
            if (!startNode.isLeaf()) {
                Iterator children = startNode.getChildrenCollection().iterator();
                while (children.hasNext()) {
                    TreeNode aNode = (TreeNode)children.next();
                    if (!aNode.getValue().equals(value)) continue;
                    return aNode;
                }
            }
            return new TreeNode((String)value, startNode, props);
        }
        if (!startNode.isLeaf()) {
            Iterator children = startNode.getChildrenCollection().iterator();
            while (children.hasNext()) {
                TreeNode aNode = (TreeNode)children.next();
                TreeNode foundNode = this.addNode(aNode, parentValue, level, value, props);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private TreeNode getTreeNode(int dimIndex, INode node) {
        int level = node.getDimensionBasedLevel();
        if (this.treeNodes_[dimIndex] == null) {
            INode rootNode = null;
            INode parentNode = this.tree_.getParent(node);
            while (parentNode != null && parentNode.getDimensionIndex() == dimIndex) {
                rootNode = parentNode;
                parentNode = this.tree_.getParent(parentNode);
            }
            this.treeNodes_[dimIndex] = rootNode == null ? new TreeNode((String)node.getValue(), null, node.getProperties()) : new TreeNode((String)rootNode.getValue(), null, rootNode.getProperties());
        }
        if (node.getDimensionBasedLevel() == 0) {
            return this.treeNodes_[dimIndex];
        }
        return this.addNode(this.treeNodes_[dimIndex], this.tree_.getParent(node).getValue(), node.getDimensionBasedLevel(), node.getValue(), node.getProperties());
    }

    public AnalysisAxisAdapter getAnalysisAxisAdapter() {
        this.process();
        return this.aaAdapter_;
    }

    public Data getData(DimensionLabelsAdapter adapter) {
        this.process();
        DimensionLabelsAdapter[] dlList = this.aaAdapter_.getDimensionLabelsList();
        for (int i = 0; i < dlList.length; ++i) {
            if (adapter != dlList[i]) continue;
            return adapter.getData();
        }
        throw new VisualizationInternalException("Could not find matching dimensionLabels adapter");
    }
}

