/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.value.FormulaValueType;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ValueType {
    private static final Logger if = Logger.getLogger((String)"com.crystaldecisions.reports.common.value.ValueType");
    public static final int _int8s = 0;
    public static final int _int8u = 1;
    public static final int _int16s = 2;
    public static final int _int16u = 3;
    public static final int _int32s = 4;
    public static final int _int32u = 5;
    public static final int _int64s = 17;
    public static final int _int64u = 18;
    public static final int _decimal = 16;
    public static final int _number = 6;
    public static final int _currency = 7;
    public static final int _boolean = 8;
    public static final int _date = 9;
    public static final int _time = 10;
    public static final int _dateTime = 15;
    public static final int _string = 11;
    public static final int _memo = 13;
    public static final int _blob = 14;
    public static final int _pointer = 100;
    public static final int _interfacePtr = 101;
    public static final int _sameAsInput = 250;
    public static final int _unknown = 255;
    private static final int new = 20;
    private static final int a = 21;
    private static final int do = 22;
    private static final int try = 23;
    private static final int int = 24;
    public static final int baseValueMask = 4095;
    public static final int range = 4096;
    public static final int array = 8192;
    public static final int rangeArray = 12288;
    public static final int _numberRange = 4102;
    public static final int _currencyRange = 4103;
    public static final int _dateRange = 4105;
    public static final int _timeRange = 4106;
    public static final int _dateTimeRange = 4111;
    public static final int _stringRange = 4107;
    public static final int _unknownRange = 4351;
    public static final int _numberArray = 8198;
    public static final int _currencyArray = 8199;
    public static final int _booleanArray = 8200;
    public static final int _dateArray = 8201;
    public static final int _timeArray = 8202;
    public static final int _dateTimeArray = 8207;
    public static final int _stringArray = 8203;
    public static final int _unknownArray = 8447;
    public static final int _numberRangeArray = 12294;
    public static final int _currencyRangeArray = 12295;
    public static final int _dateRangeArray = 12297;
    public static final int _timeRangeArray = 12298;
    public static final int _dateTimeRangeArray = 12303;
    public static final int _stringRangeArray = 12299;
    public static final int _unknownRangeArray = 12543;
    public static final ValueType int8s = new ValueType(0);
    public static final ValueType int8u = new ValueType(1);
    public static final ValueType int16s = new ValueType(2);
    public static final ValueType int16u = new ValueType(3);
    public static final ValueType int32s = new ValueType(4);
    public static final ValueType int32u = new ValueType(5);
    public static final ValueType int64s = new ValueType(17);
    public static final ValueType int64u = new ValueType(18);
    public static final ValueType decimal = new ValueType(16);
    public static final ValueType number = new ValueType(6);
    public static final ValueType currency = new ValueType(7);
    public static final ValueType bool = new ValueType(8);
    public static final ValueType date = new ValueType(9);
    public static final ValueType time = new ValueType(10);
    public static final ValueType dateTime = new ValueType(15);
    public static final ValueType string = new ValueType(11);
    public static final ValueType memo = new ValueType(13);
    public static final ValueType blob = new ValueType(14);
    public static final ValueType pointer = new ValueType(100);
    public static final ValueType interfacePtr = new ValueType(101);
    public static final ValueType sameAsInput = new ValueType(250);
    public static final ValueType unknown = new ValueType(255);
    public static final ValueType numberRange = new ValueType(4102);
    public static final ValueType currencyRange = new ValueType(4103);
    public static final ValueType dateRange = new ValueType(4105);
    public static final ValueType timeRange = new ValueType(4106);
    public static final ValueType dateTimeRange = new ValueType(4111);
    public static final ValueType stringRange = new ValueType(4107);
    public static final ValueType unknownRange = new ValueType(4351);
    public static final ValueType numberArray = new ValueType(8198);
    public static final ValueType currencyArray = new ValueType(8199);
    public static final ValueType booleanArray = new ValueType(8200);
    public static final ValueType dateArray = new ValueType(8201);
    public static final ValueType timeArray = new ValueType(8202);
    public static final ValueType dateTimeArray = new ValueType(8207);
    public static final ValueType stringArray = new ValueType(8203);
    public static final ValueType unknownArray = new ValueType(8447);
    public static final ValueType numberRangeArray = new ValueType(12294);
    public static final ValueType currencyRangeArray = new ValueType(12295);
    public static final ValueType dateRangeArray = new ValueType(12297);
    public static final ValueType timeRangeArray = new ValueType(12298);
    public static final ValueType dateTimeRangeArray = new ValueType(12303);
    public static final ValueType stringRangeArray = new ValueType(12299);
    public static final ValueType unknownRangeArray = new ValueType(12543);
    private final int for;

    private ValueType(int n) {
        this.for = n;
    }

    public static boolean isValidValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 100: 
            case 101: 
            case 250: 
            case 255: 
            case 4102: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4107: 
            case 4111: 
            case 4351: 
            case 8198: 
            case 8199: 
            case 8200: 
            case 8201: 
            case 8202: 
            case 8203: 
            case 8207: 
            case 8447: 
            case 12294: 
            case 12295: 
            case 12297: 
            case 12298: 
            case 12299: 
            case 12303: 
            case 12543: {
                return true;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static ValueType fromInt(int n) {
        switch (n) {
            case 0: {
                return int8s;
            }
            case 1: {
                return int8u;
            }
            case 2: {
                return int16s;
            }
            case 3: {
                return int16u;
            }
            case 4: {
                return int32s;
            }
            case 5: {
                return int32u;
            }
            case 17: {
                return int64s;
            }
            case 18: {
                return int64u;
            }
            case 16: {
                return decimal;
            }
            case 6: {
                return number;
            }
            case 7: {
                return currency;
            }
            case 8: {
                return bool;
            }
            case 9: {
                return date;
            }
            case 10: {
                return time;
            }
            case 15: {
                return dateTime;
            }
            case 11: {
                return string;
            }
            case 13: {
                return memo;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return blob;
            }
            case 100: {
                return pointer;
            }
            case 101: {
                return interfacePtr;
            }
            case 250: {
                return sameAsInput;
            }
            case 255: {
                return unknown;
            }
            case 4102: {
                return numberRange;
            }
            case 4103: {
                return currencyRange;
            }
            case 4105: {
                return dateRange;
            }
            case 4106: {
                return timeRange;
            }
            case 4111: {
                return dateTimeRange;
            }
            case 4107: {
                return stringRange;
            }
            case 4351: {
                return unknownRange;
            }
            case 8198: {
                return numberArray;
            }
            case 8199: {
                return currencyArray;
            }
            case 8200: {
                return booleanArray;
            }
            case 8201: {
                return dateArray;
            }
            case 8202: {
                return timeArray;
            }
            case 8207: {
                return dateTimeArray;
            }
            case 8203: {
                return stringArray;
            }
            case 8447: {
                return unknownArray;
            }
            case 12294: {
                return numberRangeArray;
            }
            case 12295: {
                return currencyRangeArray;
            }
            case 12297: {
                return dateRangeArray;
            }
            case 12298: {
                return timeRangeArray;
            }
            case 12303: {
                return dateTimeRangeArray;
            }
            case 12299: {
                return stringRangeArray;
            }
            case 12543: {
                return unknownRangeArray;
            }
        }
        assert (false);
        if.warn((Object)("Unexpected value used for initializing a ValueType: value=[" + n + "]"));
        return new ValueType(n);
    }

    public int value() {
        return this.for;
    }

    public String toString() {
        switch (this.for) {
            case 0: {
                return "int8s";
            }
            case 1: {
                return "int8u";
            }
            case 2: {
                return "int16s";
            }
            case 3: {
                return "int16u";
            }
            case 4: {
                return "int32s";
            }
            case 5: {
                return "int32u";
            }
            case 17: {
                return "int64s";
            }
            case 18: {
                return "int64u";
            }
            case 16: {
                return "decimal";
            }
            case 6: {
                return "number";
            }
            case 7: {
                return "currency";
            }
            case 8: {
                return "boolean";
            }
            case 9: {
                return "date";
            }
            case 10: {
                return "time";
            }
            case 15: {
                return "dateTime";
            }
            case 11: {
                return "string";
            }
            case 13: {
                return "memo";
            }
            case 14: {
                return "blob";
            }
            case 255: {
                return "unknown";
            }
            case 4102: {
                return "numberRange";
            }
            case 4103: {
                return "currencyRange";
            }
            case 4105: {
                return "dateRange";
            }
            case 4106: {
                return "timeRange";
            }
            case 4111: {
                return "dateTimeRange";
            }
            case 4107: {
                return "stringRange";
            }
            case 4351: {
                return "unknownRange";
            }
            case 8198: {
                return "numberArray";
            }
            case 8199: {
                return "currencyArray";
            }
            case 8200: {
                return "booleanArray";
            }
            case 8201: {
                return "dateArray";
            }
            case 8202: {
                return "timeArray";
            }
            case 8207: {
                return "dateTimeArray";
            }
            case 8203: {
                return "stringArray";
            }
            case 8447: {
                return "unknownArray";
            }
            case 12294: {
                return "numberRangeArray";
            }
            case 12295: {
                return "currencyRangeArray";
            }
            case 12297: {
                return "dateRangeArray";
            }
            case 12298: {
                return "timeRangeArray";
            }
            case 12303: {
                return "dateTimeRangeArray";
            }
            case 12299: {
                return "stringRangeArray";
            }
            case 12543: {
                return "unknownRangeArray";
            }
        }
        return "?";
    }

    public boolean isBlob() {
        switch (this.for & 0xFFF) {
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isGraphic() {
        return this.isBlob();
    }

    public boolean isMemo() {
        switch (this.for & 0xFFF) {
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        switch (this.for & 0xFFF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloat() {
        switch (this.for & 0xFFF) {
            case 6: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        return this.isInteger() || this.isFloat();
    }

    public boolean isNumeric() {
        if (this.isNumber()) {
            return true;
        }
        switch (this.for & 0xFFF) {
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isDateOrTime() {
        switch (this.for & 0xFFF) {
            case 9: 
            case 10: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public ValueType getBaseValueType() {
        return ValueType.fromInt(this.for & 0xFFF);
    }

    public boolean isScalar() {
        return (this.for & 0xFFF) == this.for;
    }

    public boolean isRange() {
        return (this.for & 0x1000) == 4096;
    }

    public boolean isArray() {
        return (this.for & 0x2000) == 8192;
    }

    public boolean isRangeArray() {
        return (this.for & 0x3000) == 12288;
    }

    public ValueType getRangeValueType() {
        return ValueType.fromInt(this.for | 0x1000);
    }

    public ValueType getNonRangeValueType() {
        return ValueType.fromInt(this.for & 0xFFFFEFFF);
    }

    public ValueType getArrayValueType() {
        return ValueType.fromInt(this.for | 0x2000);
    }

    public ValueType getNonArrayValueType() {
        return ValueType.fromInt(this.for & 0xFFFFDFFF);
    }

    public ValueType getRangeArrayValueType() {
        return ValueType.fromInt(this.for | 0x3000);
    }

    public ValueType getUnifiedNumberValueType() {
        if (this.isNumber()) {
            if (this.isRangeArray()) {
                return numberRangeArray;
            }
            if (this.isRange()) {
                return numberRange;
            }
            if (this.isArray()) {
                return numberArray;
            }
            return number;
        }
        return this;
    }

    public final FormulaValueType convertToFormulaValueType() {
        int n = this.for;
        if (this.isNumber()) {
            n = this.a(6);
        } else {
            switch (this.for & 0xFFF) {
                case 13: {
                    n = this.a(11);
                    break;
                }
                case 14: {
                    n = this.a(255);
                }
            }
        }
        if (!FormulaValueType.isValidValue(n)) {
            throw new IllegalStateException("ValueType cannot be converted to a FormulaValueType");
        }
        return FormulaValueType.fromInt(n);
    }

    private final int a(int n) {
        if (this.isRange()) {
            n |= 0x1000;
        }
        if (this.isArray()) {
            n |= 0x2000;
        }
        return n;
    }
}

