/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.filemanagement.DataRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.FixedByteArrayRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.IDataBuffer;
import com.crystaldecisions.reports.common.filemanagement.InsufficientCapacityException;
import com.crystaldecisions.reports.common.filemanagement.RawData;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import java.io.IOException;
import java.io.UTFDataFormatException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DataBuffer
extends FixedByteArrayRandomAccessStorage
implements IDataBuffer {
    public static DataBuffer createBuffer(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length <= 0) {
            throw new IllegalArgumentException();
        }
        DataBuffer dataBuffer = new DataBuffer(byArray);
        return dataBuffer;
    }

    public static DataBuffer createBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n];
        DataBuffer dataBuffer = new DataBuffer(byArray);
        return dataBuffer;
    }

    private DataBuffer(byte[] byArray) {
        super(byArray);
        try {
            this.setLength(byArray.length);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    private void byte(int n) throws IOException {
        if (!this.fits(n)) {
            String string = "Not enough remaining space in buffer (" + this.length() + ") to store/load " + n + '.';
            throw new InsufficientCapacityException(string);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.read(byArray, n, n2);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.read(byArray, 0, byArray.length);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeChar(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeChar(this, n, bl);
    }

    public void writeInt(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeInt(this, n, bl);
    }

    public void writeLong(long l, boolean bl) throws IOException {
        DataRandomAccessStorage.writeLong(this, l, bl);
    }

    public void writeShort(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeShort(this, n, bl);
    }

    public void writeString(String string) throws IOException {
        this.byte(4);
        int n = string.length();
        if (n == 0) {
            this.writeInt(0);
            return;
        }
        this.byte(4 + n * 2);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.a(string.charAt(i));
        }
    }

    public char readChar(boolean bl) throws IOException {
        return DataRandomAccessStorage.readChar(this, bl);
    }

    public int readInt(boolean bl) throws IOException {
        return DataRandomAccessStorage.readInt(this, bl);
    }

    public long readLong(boolean bl) throws IOException {
        return DataRandomAccessStorage.readLong(this, bl);
    }

    public void writeLongUTF(String string) throws IOException {
        int n = 4;
        this.byte(n);
        int n2 = string.length();
        if (n2 == 0) {
            this.new(0);
            return;
        }
        int n3 = UTF8Codec.size(string);
        if (n3 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n3 + " bytes");
        }
        this.byte(n += n3);
        this.new(n3);
        int n4 = UTF8Codec.encode(string, this.buffer, this.pos);
        this.pos += n4;
    }

    public String readLongUTF() throws IOException {
        int n = this.readInt();
        if (n == 0) {
            return StringUtil.EMPTY_STRING;
        }
        return this.int(n);
    }

    private String int(int n) throws IOException {
        this.byte(n);
        char[] cArray = new char[n];
        int n2 = UTF8Codec.decode(this.buffer, this.pos, n, cArray, 0);
        this.pos += n2;
        return new String(cArray, 0, n2);
    }

    public short readShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readShort(this, bl);
    }

    public String readString() throws IOException {
        this.byte(4);
        int n = this.readInt();
        if (n == 0) {
            return StringUtil.EMPTY_STRING;
        }
        this.byte(n * 2);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.int();
        }
        return String.valueOf(cArray);
    }

    public int readUnsignedShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readUnsignedShort(this, bl);
    }

    public boolean readBoolean() throws IOException {
        byte by = this.readByte();
        return by != 0;
    }

    public byte readByte() throws IOException {
        int n = 1;
        this.byte(n);
        return (byte)this.read();
    }

    private char int() throws IOException {
        char c = RawData.charFromData(this.buffer, this.pos);
        this.pos += 2;
        return c;
    }

    public char readChar() throws IOException {
        int n = 2;
        this.byte(n);
        return this.int();
    }

    public double readDouble() throws IOException {
        int n = 8;
        this.byte(n);
        double d = RawData.DoubleFromData(this.buffer, this.pos);
        this.pos += n;
        return d;
    }

    public float readFloat() throws IOException {
        int n = 4;
        this.byte(n);
        float f = RawData.FloatFromData(this.buffer, this.pos);
        this.pos += n;
        return f;
    }

    public int readInt() throws IOException {
        int n = 4;
        this.byte(n);
        int n2 = RawData.Int32sFromData(this.buffer, this.pos);
        this.pos += n;
        return n2;
    }

    public long readLong() throws IOException {
        int n = 8;
        this.byte(n);
        long l = RawData.Int64sFromData(this.buffer, this.pos);
        this.pos += n;
        return l;
    }

    public short readShort() throws IOException {
        int n = 2;
        this.byte(n);
        short s = (short)RawData.Int16sFromData(this.buffer, this.pos);
        this.pos += n;
        return s;
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        if (n == 0) {
            return StringUtil.EMPTY_STRING;
        }
        return this.int(n);
    }

    public int readUnsignedByte() throws IOException {
        int n = 1;
        this.byte(n);
        return this.read();
    }

    public int readUnsignedShort() throws IOException {
        int n = 2;
        this.byte(n);
        int n2 = RawData.Int16uFromData(this.buffer, this.pos);
        this.pos += n;
        return n2;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = this.pos;
        this.seek(this.pos + n);
        return this.pos - n2;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeBytes(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeChar(int n) throws IOException {
        int n2 = 2;
        this.byte(n2);
        this.a((char)n);
    }

    private void a(char c) throws IOException {
        RawData.charToData(c, this.buffer, this.pos);
        this.pos += 2;
    }

    public void writeChars(String string) throws IOException {
        int n = string.length() * 2;
        this.byte(n);
        for (int i = 0; i < string.length(); ++i) {
            this.a(string.charAt(i));
        }
    }

    public void writeDouble(double d) throws IOException {
        int n = 8;
        this.byte(n);
        RawData.DoubleToData(d, this.buffer, this.pos);
        this.pos += n;
    }

    public void writeFloat(float f) throws IOException {
        int n = 4;
        this.byte(n);
        RawData.FloatToData(f, this.buffer, this.pos);
        this.pos += n;
    }

    private void new(int n) throws IOException {
        RawData.Int32ToData(n, this.buffer, this.pos);
        this.pos += 4;
    }

    public void writeInt(int n) throws IOException {
        int n2 = 4;
        this.byte(n2);
        this.new(n);
    }

    public void writeLong(long l) throws IOException {
        int n = 8;
        this.byte(n);
        RawData.Int64ToData(l, this.buffer, this.pos);
        this.pos += n;
    }

    public void writeShort(int n) throws IOException {
        int n2 = 2;
        this.byte(n2);
        this.try(n);
    }

    private void try(int n) throws IOException {
        RawData.Int16ToData(n, this.buffer, this.pos);
        this.pos += 2;
    }

    public void writeUTF(String string) throws IOException {
        int n = 2;
        this.byte(n);
        int n2 = string.length();
        if (n2 == 0) {
            this.try(0);
            return;
        }
        int n3 = UTF8Codec.size(string);
        if (n3 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n3 + " bytes");
        }
        this.byte(n += n3);
        this.try(n3);
        int n4 = UTF8Codec.encode(string, this.buffer, this.pos);
        this.pos += n4;
    }

    public String toString() {
        return "DB-" + super.toString();
    }
}

