/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.queryengine.driverImpl.jdbc;

import com.businessobjects.reports.jdbinterface.common.DBException;
import com.businessobjects.reports.jdbinterface.common.ExpressionFieldInfo;
import com.businessobjects.reports.jdbinterface.common.FieldInfo;
import com.businessobjects.reports.jdbinterface.common.IParameters;
import com.businessobjects.reports.jdbinterface.common.JDBInterfaceResources;
import com.businessobjects.reports.jdbinterface.common.ParameterDirection;
import com.businessobjects.reports.jdbinterface.common.ParameterInfo;
import com.businessobjects.reports.jdbinterface.common.ResultSetReader;
import com.businessobjects.reports.jdbinterface.common.ServerDriverType;
import com.businessobjects.reports.jdbinterface.common.SortFieldInfo;
import com.businessobjects.reports.jdbinterface.common.TableInfo;
import com.businessobjects.reports.jdbinterface.common.TableType;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryBuild;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryDefinition;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryExpressions;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryGroupFilters;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryJoins;
import com.businessobjects.reports.jdbinterface.querydefinition.IQueryRecordFilters;
import com.businessobjects.reports.jdbinterface.querydefinition.IQuerySorts;
import com.businessobjects.reports.jdbinterface.querydefinition.JoinNode;
import com.businessobjects.reports.jdbinterface.querydefinition.QueryOptions;
import com.businessobjects.reports.jdbinterface.querydefinition.RangeInfoNodeJDB;
import com.crystaldecisions.reports.common.CrystalException;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.data.CrystalResultSetMetaData;
import com.crystaldecisions.reports.common.data.JdbcCrystalResultSetMetaData;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.reports.queryengine.driverImpl.DatabaseConnectorResources;
import com.crystaldecisions.reports.queryengine.driverImpl.jdbc.JDBCConnection;
import com.crystaldecisions.reports.queryengine.driverImpl.jdbc.JDBCParameterInfo;
import com.crystaldecisions.reports.queryengine.driverImpl.jdbc.JDBCResultSet;
import com.crystaldecisions.reports.queryengine.driverImpl.jdbc.JDBCTable;
import com.crystaldecisions.reports.queryengine.querybuilder.ExtendableOptions;
import com.crystaldecisions.reports.queryengine.querybuilder.Query;
import com.crystaldecisions.reports.queryengine.querybuilder.QueryBuilder;
import com.crystaldecisions.reports.queryengine.querybuilder.QueryBuilderException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCQueryDefinition
implements IQueryDefinition,
IQueryJoins,
IQueryRecordFilters,
IQueryGroupFilters,
IQuerySorts,
IParameters,
IQueryExpressions,
IQueryBuild {
    private JDBCConnection J = null;
    private ArrayList<FieldInfo> I = new ArrayList();
    private ArrayList<TableInfo> D = new ArrayList();
    private JoinNode F = null;
    private RangeInfoNodeJDB K = null;
    private List<FieldInfo> G = new ArrayList<FieldInfo>();
    private RangeInfoNodeJDB E = null;
    private List<SortFieldInfo> H = new ArrayList<SortFieldInfo>();
    private List<ParameterInfo> L = new ArrayList<ParameterInfo>();
    private QueryOptions M = new QueryOptions();

    public JDBCQueryDefinition(JDBCConnection jDBCConnection) {
        this.J = jDBCConnection;
    }

    public void SetRequiredFields(List<FieldInfo> list) {
        this.I.clear();
        if (list != null) {
            for (FieldInfo fieldInfo : list) {
                this.I.add(fieldInfo);
            }
        }
    }

    public List<FieldInfo> GetRequiredFields() {
        return this.I;
    }

    public void SetRequiredTables(List<TableInfo> list) {
        this.D.clear();
        if (list != null) {
            for (TableInfo tableInfo : list) {
                this.D.add(tableInfo);
            }
        }
    }

    public List<TableInfo> GetRequiredTables() {
        return this.D;
    }

    public void SetJoins(JoinNode joinNode) {
        this.F = joinNode;
    }

    public JoinNode GetJoins() {
        return this.F;
    }

    public void SetEnforceLinkOrder(boolean bl) {
    }

    public void SetRecordFilters(RangeInfoNodeJDB rangeInfoNodeJDB) {
        this.K = rangeInfoNodeJDB;
    }

    public RangeInfoNodeJDB GetRecordFilters() {
        return this.K;
    }

    public RangeInfoNodeJDB GetUnsupportedRecordFilters() {
        return null;
    }

    public void SetGroupFields(List<FieldInfo> list) {
        this.G.clear();
        if (list != null) {
            for (FieldInfo fieldInfo : list) {
                this.G.add(fieldInfo);
            }
        }
    }

    public List<FieldInfo> GetGroupFields() {
        return this.G;
    }

    public void SetGroupFilters(RangeInfoNodeJDB rangeInfoNodeJDB) {
        this.E = rangeInfoNodeJDB;
    }

    public RangeInfoNodeJDB GetGroupFilters() {
        return this.E;
    }

    public RangeInfoNodeJDB GetUnsupportedGroupFilters() {
        return null;
    }

    public void SetSortFields(List<SortFieldInfo> list) {
        this.H.clear();
        if (list != null) {
            for (SortFieldInfo sortFieldInfo : list) {
                this.H.add(sortFieldInfo);
            }
        }
    }

    public List<SortFieldInfo> GetSortFields() {
        return this.H;
    }

    public void setParameters(List<ParameterInfo> list) {
        this.L.clear();
        if (list != null) {
            for (ParameterInfo parameterInfo : list) {
                this.L.add(parameterInfo);
            }
        }
    }

    public List<ParameterInfo> getParameters() {
        return this.L;
    }

    public QueryOptions GetQueryOptions() {
        return this.M;
    }

    public void SetQueryOptions(QueryOptions queryOptions) {
        this.M = queryOptions;
    }

    public FieldInfo ParseExpression(String string, List<TableInfo> list) throws DBException {
        try {
            String string2 = this.a(string, list);
            PreparedStatement preparedStatement = this.J.PrepareStatement(string2);
            ResultSetMetaData resultSetMetaData = null;
            try {
                resultSetMetaData = preparedStatement.getMetaData();
            }
            catch (Throwable throwable) {
                try {
                    preparedStatement.execute();
                    resultSetMetaData = preparedStatement.getMetaData();
                }
                catch (Throwable throwable2) {
                    resultSetMetaData = null;
                }
            }
            if (resultSetMetaData == null) {
                throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "FailedToParseExpression");
            }
            List list2 = ResultSetReader.GetFieldsFromResultSetMetaData((CrystalResultSetMetaData)new JdbcCrystalResultSetMetaData(resultSetMetaData), (ServerDriverType)this.J.GetVendorJDBCDriverType());
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            CrystalAssert.ASSERT((list2.size() == 1 ? 1 : 0) != 0);
            if (list2.isEmpty()) {
                throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "FailedToParseExpression");
            }
            this.J.try();
            return (FieldInfo)list2.get(0);
        }
        catch (SQLException sQLException) {
            throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "FailedToParseExpression");
        }
    }

    String a(String string, List<TableInfo> list) throws DBException {
        ServerDriverType serverDriverType;
        Object object;
        Object object2;
        ExtendableOptions extendableOptions = this.J.GetExtendableOptions();
        QueryBuilder queryBuilder = this.J.GetQueryBuilder();
        ExpressionFieldInfo expressionFieldInfo = new ExpressionFieldInfo();
        expressionFieldInfo.expressionText = this.a(string);
        expressionFieldInfo.m_Name = "expr1";
        if (list.size() == 0) {
            object2 = null;
            object = null;
            serverDriverType = this.J.GetVendorJDBCDriverType();
            if (serverDriverType.isOracle()) {
                object2 = "ALL_USERS";
                object = "SYS.ALL_USERS";
            } else if (serverDriverType.isIBMDB2()) {
                object2 = "SYSDBAUTH";
                object = "SYSIBM.SYSDBAUTH";
            }
            if (object2 != null && object != null) {
                TableInfo tableInfo = new TableInfo();
                tableInfo.m_Name = object2;
                tableInfo.m_Alias = object2;
                tableInfo.m_QualifiedName = object;
                list.add(tableInfo);
            }
        } else {
            object2 = new HashSet<TableInfo>(list);
            list = new ArrayList<TableInfo>((Collection<TableInfo>)object2);
        }
        object2 = new JDBCQueryDefinition(this.J);
        object = new ArrayList();
        object.add(expressionFieldInfo);
        ((JDBCQueryDefinition)object2).SetRequiredFields((List<FieldInfo>)object);
        ((JDBCQueryDefinition)object2).SetRequiredTables(list);
        serverDriverType = new Query();
        try {
            queryBuilder.GenerateQuery((IQueryDefinition)object2, extendableOptions, (Query)serverDriverType);
        }
        catch (QueryBuilderException queryBuilderException) {
            throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "FailedToParseExpression", (Throwable)queryBuilderException);
        }
        return serverDriverType.getQuery(false);
    }

    public JDBCResultSet Execute() throws DBException {
        CrystalAssert.ASSERT((this.D != null ? 1 : 0) != 0);
        String string = this.BuildCommand();
        return this.Execute(string);
    }

    public JDBCResultSet Execute(Object object) throws DBException {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        if (string == null) {
            throw new DBException("RCICRC99999999", "", DatabaseConnectorResources.getFactory(), "UnexpectedDatabaseConnectorError");
        }
        string = this.a(string);
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            ServerDriverType serverDriverType = this.J.GetVendorJDBCDriverType();
            int n = 1;
            CallableStatement callableStatement = null;
            if (this.L != null && this.L.size() > 0) {
                callableStatement = this.J.PrepareCall(string);
                CrystalAssert.ASSERT((this.D.get((int)0).m_Type == TableType.storedProc ? 1 : 0) != 0, (String)"The first required table is not a stored procedure, but it should be. ");
                TableInfo tableInfo = this.D.get(0);
                JDBCTable jDBCTable = new JDBCTable(this.J, tableInfo);
                List<JDBCParameterInfo> list = jDBCTable.GetParametersWithSQLType(this.L);
                if (serverDriverType.isOracle()) {
                    boolean bl = false;
                    for (JDBCParameterInfo jDBCParameterInfo : list) {
                        if (jDBCParameterInfo.dataType == ValueType.pointer) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        throw new DBException("RCICRC99999999", "", DatabaseConnectorResources.getFactory(), "UnexpectedDatabaseConnectorError");
                    }
                    callableStatement.registerOutParameter(n, -10);
                    this.a(callableStatement, n, list);
                    callableStatement.execute();
                } else {
                    this.a(callableStatement, -1, list);
                    callableStatement.execute();
                    statement = callableStatement;
                }
            } else if (this.case()) {
                callableStatement = this.J.PrepareCall(string);
                callableStatement.execute();
                statement = callableStatement;
            } else {
                statement = this.J.CreateStatement();
                if (!statement.execute(string) && statement.getUpdateCount() == -1) {
                    throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "NoResultsReturnedByQuery");
                }
            }
            while ((resultSet = this.L != null && this.L.size() > 0 && serverDriverType.isOracle() ? (ResultSet)callableStatement.getObject(n) : statement.getResultSet()) == null || resultSet.getMetaData().getColumnCount() <= 0) {
                if (statement.getMoreResults() || statement.getUpdateCount() != -1) continue;
                if (serverDriverType.isSQLServer()) {
                    statement.executeUpdate(string);
                    continue;
                }
                throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "NoResultsReturnedByQuery");
            }
            return new JDBCResultSet(this.J, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new DBException("RCICRC99999999", "", DatabaseConnectorResources.getFactory(), "UnexpectedDatabaseConnectorError", (Throwable)sQLException);
        }
    }

    public String ConvertValueToString(CrystalValue crystalValue, ValueType valueType, int n, boolean bl) throws DBException {
        StringBuffer stringBuffer = new StringBuffer();
        ExtendableOptions extendableOptions = this.J.GetExtendableOptions();
        QueryBuilder queryBuilder = this.J.GetQueryBuilder();
        try {
            queryBuilder.ConvertValueToString(valueType, n, crystalValue, bl, extendableOptions, stringBuffer);
        }
        catch (QueryBuilderException queryBuilderException) {
            throw new DBException("RCICRC99999999", "", (CrystalException)queryBuilderException);
        }
        return stringBuffer.toString();
    }

    public String BuildCommand() throws DBException {
        Query query = new Query();
        try {
            ExtendableOptions extendableOptions = this.J.GetExtendableOptions();
            QueryBuilder queryBuilder = this.J.GetQueryBuilder();
            queryBuilder.GenerateQuery((IQueryDefinition)this, extendableOptions, query);
        }
        catch (QueryBuilderException queryBuilderException) {
            throw new DBException("RCICRC99999999", "", DatabaseConnectorResources.getFactory(), "UnexpectedDatabaseConnectorError", (Throwable)queryBuilderException);
        }
        return query.getQuery(false);
    }

    private void a(CallableStatement callableStatement, int n, List<JDBCParameterInfo> list) throws DBException, SQLException {
        Iterator<ParameterInfo> iterator = this.L.iterator();
        Iterator<JDBCParameterInfo> iterator2 = list.iterator();
        int n2 = 0;
        block13: while (iterator.hasNext() && iterator2.hasNext()) {
            if (++n2 == n) {
                ++n2;
                iterator2.next();
                if (!iterator2.hasNext()) break;
            }
            ParameterInfo parameterInfo = iterator.next();
            JDBCParameterInfo jDBCParameterInfo = iterator2.next();
            if (parameterInfo == null || jDBCParameterInfo == null) continue;
            ValueType valueType = parameterInfo.dataType;
            CrystalValue crystalValue = parameterInfo.currentValue;
            if (parameterInfo.parameterDirection != ParameterDirection.input) continue;
            if (crystalValue == null) {
                if (this.J.GetVendorJDBCDriverType().isSQLServer() && jDBCParameterInfo.m_Attributes == 1) {
                    callableStatement.setNull(n2, -2);
                    continue;
                }
                callableStatement.setNull(n2, jDBCParameterInfo.if);
                continue;
            }
            switch (valueType.value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n3 = ((NumberValue)crystalValue).getInt();
                    callableStatement.setInt(n2, n3);
                    continue block13;
                }
                case 17: 
                case 18: {
                    long l = ((NumberValue)crystalValue).getLong();
                    callableStatement.setLong(n2, l);
                    continue block13;
                }
                case 6: {
                    double d = ((NumberValue)crystalValue).getDouble();
                    callableStatement.setDouble(n2, d);
                    continue block13;
                }
                case 7: 
                case 16: {
                    String string = ((NumericValue)crystalValue).toString();
                    String string2 = string.substring(2, string.length() - 1);
                    callableStatement.setBigDecimal(n2, new BigDecimal(string2));
                    continue block13;
                }
                case 8: {
                    boolean bl = ((BooleanValue)crystalValue).getBoolean();
                    callableStatement.setBoolean(n2, bl);
                    continue block13;
                }
                case 9: {
                    String string = ((DateValue)crystalValue).toString();
                    String string3 = string.substring(2, 6) + "-" + string.substring(7, 9) + "-" + string.substring(10, 12);
                    callableStatement.setDate(n2, Date.valueOf(string3));
                    continue block13;
                }
                case 10: {
                    String string = ((TimeValue)crystalValue).toString();
                    String string4 = string.substring(2, 4) + ":" + string.substring(5, 7) + ":" + string.substring(8, 10);
                    callableStatement.setTime(n2, Time.valueOf(string4));
                    continue block13;
                }
                case 15: {
                    String string = ((DateTimeValue)crystalValue).getDateValue().toString();
                    String string5 = ((DateTimeValue)crystalValue).getTimeValue().toString();
                    String string6 = string.substring(2, 6) + "-" + string.substring(7, 9) + "-" + string.substring(10, 12);
                    String string7 = string5.substring(2, 4) + ":" + string5.substring(5, 7) + ":" + string5.substring(8, 10);
                    String string8 = string6 + " " + string7 + ".000000000";
                    callableStatement.setTimestamp(n2, Timestamp.valueOf(string8));
                    continue block13;
                }
                case 11: {
                    String string = this.J.GetVendorJDBCDriverType();
                    if (string.isSQLServer() && (jDBCParameterInfo.if == -2 || jDBCParameterInfo.m_Attributes == 1)) {
                        try {
                            long l = Long.parseLong(((StringValue)crystalValue).getString(), 16);
                            callableStatement.setLong(n2, l);
                            continue block13;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "InvalidParameterValue");
                        }
                    }
                    callableStatement.setString(n2, ((StringValue)crystalValue).getString());
                    continue block13;
                }
            }
            throw new DBException("RCICRC99999999", "", DatabaseConnectorResources.getFactory(), "UnexpectedDatabaseConnectorError");
        }
    }

    private String a(String string) {
        int n;
        if (this.J.GetVendorJDBCDriverType().isSQLServer() && (n = string.indexOf("{fn ")) > 0) {
            return string.replaceAll("\\{fn ", "{ fn ");
        }
        return string;
    }

    private boolean case() {
        boolean bl = false;
        if (this.D.isEmpty() || this.D.get((int)0).m_Type != TableType.storedProc) {
            return false;
        }
        try {
            String string = this.J.GetDatabaseMetaData().getDriverName();
            if (string != null && !string.equals("") && string.indexOf("jTDS") >= 0) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }
}

