/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.InMemoryRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.InsufficientCapacityException;
import java.io.IOException;
import java.io.OutputStream;

public class FixedByteArrayRandomAccessStorage
implements InMemoryRandomAccessStorage {
    final byte[] buffer;
    int pos;
    private int r;

    public FixedByteArrayRandomAccessStorage(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("buf cannot be null");
        }
        this.buffer = byArray;
    }

    public void flush() throws IOException {
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public long length() throws IOException {
        return this.r;
    }

    public int read() throws IOException {
        int n;
        return (n = this.pos++) < this.r ? this.buffer[n] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pos;
        int n4 = this.r - n3;
        if (n4 <= 0) {
            return -1;
        }
        int n5 = n4 < n2 ? n4 : n2;
        System.arraycopy(this.buffer, n3, byArray, n, n5);
        this.pos = n3 + n5;
        return n5;
    }

    public void seek(long l) throws IOException {
        if (l > (long)this.buffer.length) {
            this.pos = this.buffer.length;
        } else if (l >= 0L) {
            this.pos = (int)l;
        } else {
            throw new IllegalArgumentException("Cannot seek to negative offset.");
        }
    }

    public void setLength(long l) throws IOException {
        if (l > (long)this.buffer.length) {
            throw new InsufficientCapacityException("Cannot grow beyond array length.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("New length cannot be negative.");
        }
        this.r = (int)l;
    }

    public Object sync() {
        return this.buffer;
    }

    public void write(int n) throws IOException {
        int n2 = this.pos;
        byte[] byArray = this.buffer;
        if (n2 >= byArray.length) {
            throw new InsufficientCapacityException("Cannot grow beyond array length.");
        }
        byArray[n2++] = (byte)n;
        this.pos = n2;
        if (this.r < n2) {
            this.r = n2;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pos;
        byte[] byArray2 = this.buffer;
        if (n3 > byArray2.length - n2) {
            throw new InsufficientCapacityException("Cannot grow beyond array length.");
        }
        System.arraycopy(byArray, n, byArray2, n3, n2);
        this.pos = n3 += n2;
        if (this.r < n3) {
            this.r = n3;
        }
    }

    public void close() throws IOException {
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public boolean fits(int n) {
        return this.pos <= this.buffer.length - n;
    }

    public void setLength(long l, boolean bl) throws IOException {
        this.setLength(l);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.r);
    }

    public long limit() {
        return this.buffer.length;
    }

    public String toString() {
        return "FBARAS[p=" + this.pos + ",s=" + this.r + ']';
    }
}

