/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.filemanagement.FilterRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorages;
import com.crystaldecisions.reports.common.filemanagement.RawData;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataRandomAccessStorage
extends FilterRandomAccessStorage
implements ExtendedDataInput,
ExtendedDataOutput {
    private static final int s = 131072;
    private byte[] t = new byte[8];
    private char[] u;

    private byte[] for(int n) {
        byte[] byArray = this.t;
        if (byArray.length < n) {
            if (n > 131072) {
                return new byte[n];
            }
            this.t = byArray = new byte[n > 65536 ? n + 1024 : n * 2];
        }
        return byArray;
    }

    private char[] do(int n) {
        char[] cArray = this.u;
        if (cArray == null || cArray.length < n) {
            if (n > 131072) {
                return new char[n];
            }
            this.u = cArray = new char[n > 65536 ? n + 1024 : n * 2];
        }
        return cArray;
    }

    public void releaseBuffers() {
        if (this.t.length > 8) {
            this.t = new byte[8];
        }
        this.u = null;
    }

    public DataRandomAccessStorage(RandomAccessStorage randomAccessStorage) {
        super(randomAccessStorage);
    }

    public void write(byte[] byArray) throws IOException {
        this.ras.write(byArray, 0, byArray.length);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.ras.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.ras.write(n);
    }

    public void writeBytes(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.ras.write(byArray, 0, byArray.length);
    }

    public void writeChar(int n) throws IOException {
        byte[] byArray = this.t;
        RawData.charToData((char)n, byArray, 0);
        this.ras.write(byArray, 0, 2);
    }

    public void writeChar(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeChar(this, n, bl);
    }

    static void writeChar(DataOutput dataOutput, int n, boolean bl) throws IOException {
        dataOutput.writeChar(bl ? Short.reverseBytes((short)n) & 0xFFFF : n);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = this.for(n2);
        char[] cArray = this.do(n);
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n3++] = (byte)(cArray[i] >>> 8);
            byArray[n3++] = (byte)cArray[i];
        }
        this.ras.write(byArray, 0, n2);
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = this.t;
        RawData.Int32ToData(n, byArray, 0);
        this.ras.write(byArray, 0, 4);
    }

    public void writeInt(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeInt(this, n, bl);
    }

    static void writeInt(DataOutput dataOutput, int n, boolean bl) throws IOException {
        dataOutput.writeInt(bl ? Integer.reverseBytes(n) : n);
    }

    public void writeLong(long l) throws IOException {
        byte[] byArray = this.t;
        RawData.Int64ToData(l, byArray, 0);
        this.ras.write(byArray, 0, 8);
    }

    public void writeLong(long l, boolean bl) throws IOException {
        DataRandomAccessStorage.writeLong(this, l, bl);
    }

    static void writeLong(DataOutput dataOutput, long l, boolean bl) throws IOException {
        dataOutput.writeLong(bl ? Long.reverseBytes(l) : l);
    }

    public void writeShort(int n) throws IOException {
        byte[] byArray = this.t;
        RawData.Int16ToData(n, byArray, 0);
        this.ras.write(byArray, 0, 2);
    }

    public void writeShort(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeShort(this, n, bl);
    }

    static void writeShort(DataOutput dataOutput, int n, boolean bl) throws IOException {
        dataOutput.writeShort(bl ? (int)Short.reverseBytes((short)n) : n);
    }

    public void writeUTF(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this.writeShort(0);
            return;
        }
        int n2 = UTF8Codec.size(string);
        if (n2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n2 + " bytes");
        }
        this.writeShort(n2);
        byte[] byArray = this.for(n2);
        UTF8Codec.encode(string, byArray, 0);
        this.write(byArray, 0, n2);
    }

    public void writeLongUTF(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this.writeInt(0);
            return;
        }
        int n2 = UTF8Codec.size(string);
        this.writeInt(n2);
        byte[] byArray = this.for(n2);
        UTF8Codec.encode(string, byArray, 0);
        this.write(byArray, 0, n2);
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this.writeInt(0);
            return;
        }
        this.writeInt(n);
        byte[] byArray = this.for(n * 2);
        for (int i = 0; i < n; ++i) {
            RawData.charToData(string.charAt(i), byArray, i * 2);
        }
        this.write(byArray, 0, n * 2);
    }

    public boolean readBoolean() throws IOException {
        int n = this.ras.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.ras.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public char readChar() throws IOException {
        byte[] byArray = this.t;
        if (this.ras.read(byArray, 0, 2) != 2) {
            throw new EOFException();
        }
        return RawData.charFromData(byArray, 0);
    }

    public char readChar(boolean bl) throws IOException {
        return DataRandomAccessStorage.readChar(this, bl);
    }

    static char readChar(DataInput dataInput, boolean bl) throws IOException {
        char c = dataInput.readChar();
        return bl ? (char)(Short.reverseBytes((short)c) & 0xFFFF) : c;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        RandomAccessStorages.readFully(this, byArray, n, n2);
    }

    public int readInt() throws IOException {
        byte[] byArray = this.t;
        if (this.ras.read(byArray, 0, 4) != 4) {
            throw new EOFException();
        }
        return RawData.Int32sFromData(byArray, 0);
    }

    public int readInt(boolean bl) throws IOException {
        return DataRandomAccessStorage.readInt(this, bl);
    }

    static int readInt(DataInput dataInput, boolean bl) throws IOException {
        int n = dataInput.readInt();
        return bl ? Integer.reverseBytes(n) : n;
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine not supported");
    }

    public long readLong() throws IOException {
        byte[] byArray = this.t;
        if (this.ras.read(byArray, 0, 8) != 8) {
            throw new EOFException();
        }
        return RawData.Int64sFromData(byArray, 0);
    }

    public long readLong(boolean bl) throws IOException {
        return DataRandomAccessStorage.readLong(this, bl);
    }

    static long readLong(DataInput dataInput, boolean bl) throws IOException {
        long l = dataInput.readLong();
        return bl ? Long.reverseBytes(l) : l;
    }

    public short readShort() throws IOException {
        byte[] byArray = this.t;
        if (this.ras.read(byArray, 0, 2) != 2) {
            throw new EOFException();
        }
        return (short)RawData.Int16sFromData(byArray, 0);
    }

    public short readShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readShort(this, bl);
    }

    static short readShort(DataInput dataInput, boolean bl) throws IOException {
        short s = dataInput.readShort();
        return bl ? Short.reverseBytes(s) : s;
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        return this.if(n);
    }

    public String readLongUTF() throws IOException {
        int n = this.readInt();
        return this.if(n);
    }

    private String if(int n) throws IOException {
        if (n == 0) {
            return "";
        }
        byte[] byArray = this.for(n);
        this.readFully(byArray, 0, n);
        char[] cArray = this.do(n);
        int n2 = UTF8Codec.decode(byArray, 0, n, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = this.for(n * 2);
        this.readFully(byArray, 0, n * 2);
        char[] cArray = this.do(n);
        for (int i = 0; i < n; ++i) {
            cArray[i] = RawData.charFromData(byArray, i * 2);
        }
        return String.valueOf(cArray, 0, n);
    }

    public int readUnsignedByte() throws IOException {
        int n = this.ras.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int readUnsignedShort() throws IOException {
        byte[] byArray = this.t;
        if (this.ras.read(byArray, 0, 2) != 2) {
            throw new EOFException();
        }
        return RawData.Int16uFromData(byArray, 0);
    }

    public int readUnsignedShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readUnsignedShort(this, bl);
    }

    static int readUnsignedShort(DataInput dataInput, boolean bl) throws IOException {
        int n = dataInput.readUnsignedShort();
        return bl ? Short.reverseBytes((short)n) & 0xFFFF : n;
    }

    public int skipBytes(int n) throws IOException {
        return (int)RandomAccessStorages.skip(this.ras, n);
    }

    public boolean isBypassable() {
        return true;
    }

    public String toString() {
        return "DRAS(" + this.ras + ')';
    }
}

