/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.AngularGradientPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class AngularGradientPaint
implements Paint {
    private Color color1;
    private Color color2;
    private Rectangle2D.Float gradientBounds;
    private Point2D.Float gradientCenter;
    private float centralAngle;
    private static final float DEFAULT_ANGLE = 1.5707964f;
    private float deltaAngle;
    private static final float DEFAULT_DELTA = 0.7853982f;
    private int transparency;

    public Color getCenterColor() {
        return this.color1;
    }

    public Color getBoundaryColor() {
        return this.color2;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.gradientBounds.clone();
    }

    public Point2D.Float getCenter() {
        return (Point2D.Float)this.gradientCenter.clone();
    }

    float getCentralAngle() {
        return this.centralAngle;
    }

    float getDeltaAngle() {
        return this.deltaAngle;
    }

    public AngularGradientPaint(Rectangle2D bounds, Color color1, Color color2) {
        this(bounds, color1, color2, new Point2D.Float((float)bounds.getCenterX(), (float)bounds.getCenterY()), 1.5707964f, 0.7853982f);
    }

    public AngularGradientPaint(Rectangle2D bounds, Color color1, Color color2, Point2D center, Point2D angles) {
        this(bounds, color1, color2, center, (float)angles.getX(), (float)angles.getY());
    }

    public AngularGradientPaint(Rectangle2D bounds, Color color1, Color color2, Point2D center, float centralAngle, float deltaAngle) {
        this.color1 = color1;
        this.color2 = color2;
        this.gradientCenter = new Point2D.Float((float)center.getX(), (float)center.getY());
        this.centralAngle = centralAngle;
        this.deltaAngle = deltaAngle;
        this.gradientBounds = new Rectangle2D.Float();
        this.gradientBounds.setRect((float)bounds.getX(), (float)bounds.getY(), (float)bounds.getWidth(), (float)bounds.getHeight());
        int a1 = color1.getAlpha();
        int a2 = color2.getAlpha();
        this.transparency = (a1 & a2) == 255 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new AngularGradientPaintContext(this.gradientBounds, this.color1, this.color2, this.gradientCenter, this.centralAngle, this.deltaAngle, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }
}

