/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DFlatFace;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

public class Model3DSurface
extends Model3DFlatFace {
    private static final int[][] m_myfacesFront = new int[][]{{0, 1, 2}};
    private static final int[][] m_myfacesBack = new int[][]{{0, 2, 1}};
    private boolean m_bFrontTriangle;

    public Model3DSurface(JChart_3D chart, IdentObj id, IBlackBox bb, Point3d[] vertices, boolean[][] bGridStatus, boolean bFrontTriangle, boolean bAutoshading) {
        super(chart, id, bb, 1, 3, bGridStatus, bAutoshading);
        this.m_faces = bFrontTriangle ? m_myfacesFront : m_myfacesBack;
        this.m_bFrontTriangle = bFrontTriangle;
        this.m_vertices[0] = new Point3d(vertices[0]);
        this.m_vertices[1] = bFrontTriangle ? new Point3d(vertices[1]) : new Point3d(vertices[3]);
        this.m_vertices[2] = new Point3d(vertices[2]);
        vertices[1] = vertices[3];
    }

    public Point3d getCenter() {
        return new Point3d((this.m_vertices[0].x + this.m_vertices[1].x + this.m_vertices[2].x) / 3.0, 0.0, (this.m_vertices[0].z + this.m_vertices[1].z + this.m_vertices[2].z) / 3.0);
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                double dx = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                if (this.m_bFrontTriangle) {
                    return new Point3d(d, this.m_vertices[0].y + dx * (this.m_vertices[2].y - this.m_vertices[0].y), this.m_vertices[0].z - dx * (this.m_vertices[0].z - this.m_vertices[2].z));
                }
                return new Point3d(d, this.m_vertices[0].y + dx * (this.m_vertices[2].y - this.m_vertices[0].y), this.m_vertices[0].z - dx * (this.m_vertices[0].z - this.m_vertices[2].z));
            }
            case 1: {
                boolean v5_over;
                boolean v3_over = this.m_vertices[0].y > d;
                boolean v4_over = this.m_vertices[1].y > d;
                boolean bl = v5_over = this.m_vertices[2].y > d;
                if (v3_over == v4_over && v3_over == v5_over) {
                    return null;
                }
                if (v3_over != v5_over) {
                    double dy = (d - this.m_vertices[0].y) / (this.m_vertices[2].y - this.m_vertices[0].y);
                    return new Point3d(this.m_vertices[0].x + dy * (this.m_vertices[2].x - this.m_vertices[0].x), d, this.m_vertices[0].z + dy * (this.m_vertices[2].z - this.m_vertices[0].z));
                }
                if (this.m_bFrontTriangle) {
                    double dy = (d - this.m_vertices[2].y) / (this.m_vertices[1].y - this.m_vertices[2].y);
                    return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z + dy * (this.m_vertices[1].z - this.m_vertices[2].z));
                }
                double dy = (d - this.m_vertices[1].y) / (this.m_vertices[2].y - this.m_vertices[1].y);
                return new Point3d(this.m_vertices[1].x + dy * (this.m_vertices[2].x - this.m_vertices[1].x), d, this.m_vertices[2].z);
            }
            case 2: {
                double dz = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                if (this.m_bFrontTriangle) {
                    return new Point3d(this.m_vertices[2].x, this.m_vertices[2].y + dz * (this.m_vertices[1].y - this.m_vertices[2].y), d);
                }
                return new Point3d(this.m_vertices[0].x, this.m_vertices[1].y + dz * (this.m_vertices[0].y - this.m_vertices[1].y), d);
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                double dx = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                if (this.m_bFrontTriangle) {
                    return new Point3d(d, this.m_vertices[0].y + dx * (this.m_vertices[1].y - this.m_vertices[0].y), this.m_vertices[0].z);
                }
                return new Point3d(d, this.m_vertices[1].y + (1.0 - dx) * (this.m_vertices[2].y - this.m_vertices[1].y), this.m_vertices[2].z);
            }
            case 1: {
                boolean v5_over;
                boolean v3_over = this.m_vertices[0].y > d;
                boolean v4_over = this.m_vertices[1].y > d;
                boolean bl = v5_over = this.m_vertices[2].y > d;
                if (v3_over == v4_over && v3_over == v5_over) {
                    return null;
                }
                if (this.m_bFrontTriangle) {
                    if (v3_over != v4_over) {
                        double dy = (d - this.m_vertices[1].y) / (this.m_vertices[0].y - this.m_vertices[1].y);
                        return new Point3d(this.m_vertices[1].x + dy * (this.m_vertices[0].x - this.m_vertices[1].x), d, this.m_vertices[0].z);
                    }
                    double dy = (d - this.m_vertices[2].y) / (this.m_vertices[1].y - this.m_vertices[2].y);
                    return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z + dy * (this.m_vertices[1].z - this.m_vertices[2].z));
                }
                if (v3_over != v4_over) {
                    double dy = (d - this.m_vertices[1].y) / (this.m_vertices[0].y - this.m_vertices[1].y);
                    return new Point3d(this.m_vertices[0].x, d, this.m_vertices[1].z + dy * (this.m_vertices[0].z - this.m_vertices[1].z));
                }
                double dy = (d - this.m_vertices[1].y) / (this.m_vertices[2].y - this.m_vertices[1].y);
                return new Point3d(this.m_vertices[1].x + dy * (this.m_vertices[2].x - this.m_vertices[1].x), d, this.m_vertices[2].z);
            }
            case 2: {
                double dz = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                if (this.m_bFrontTriangle) {
                    return new Point3d(this.m_vertices[2].x, this.m_vertices[2].y + dz * (this.m_vertices[1].y - this.m_vertices[2].y), d);
                }
                return new Point3d(this.m_vertices[0].x, this.m_vertices[1].y + dz * (this.m_vertices[0].y - this.m_vertices[1].y), d);
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int f) {
        return 3;
    }

    public Point3d visibility(int f) {
        return this.getFaceNormal(f);
    }
}

