/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.math;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.ShapeUtility;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Interpolation2D {
    public static int getDefaultPointsCount() {
        return 60;
    }

    public static void findOpenControlPoints(float[] Px, float[] Py, float[] dx, float[] dy) {
        int i;
        int nLen = Px.length;
        if (nLen < 3 || Py.length != nLen) {
            throw new RuntimeException("Minimal number of points is 3.");
        }
        int n1 = nLen - 1;
        float fSection = 0.5f;
        dx[0] = (Px[1] - Px[0]) * fSection;
        dy[0] = (Py[1] - Py[0]) * fSection;
        dx[n1] = (Px[n1] - Px[n1 - 1]) * fSection;
        dy[n1] = (Py[n1] - Py[n1 - 1]) * fSection;
        float[] Bi = new float[n1];
        float[] Ax = new float[n1];
        float[] Ay = new float[n1];
        Bi[1] = 0.0f;
        Ax[1] = (Px[2] - Px[0] - dx[0]) / 4.0f;
        Ay[1] = (Py[2] - Py[0] - dy[0]) / 4.0f;
        for (i = 2; i < n1; ++i) {
            Bi[i] = -1.0f / (4.0f + Bi[i - 1]);
            Ax[i] = -(Px[i + 1] - Px[i - 1] - Ax[i - 1]) * Bi[i];
            Ay[i] = -(Py[i + 1] - Py[i - 1] - Ay[i - 1]) * Bi[i];
        }
        for (i = n1 - 1; i > 0; --i) {
            dx[i] = Ax[i] + dx[i + 1] * Bi[i];
            dy[i] = Ay[i] + dy[i + 1] * Bi[i];
        }
    }

    public static void findOpenControlPointsPreservingExtrema(float[] Px, float[] Py, float[] dx, float[] dy) {
        int nLen = Px.length;
        if (nLen < 3 || Py.length != nLen) {
            throw new RuntimeException("Minimal number of points is 3.");
        }
        int n1 = nLen - 1;
        float fSection = 0.5f;
        dx[0] = (Px[1] - Px[0]) * fSection;
        dy[0] = (Py[1] - Py[0]) * fSection;
        dx[n1] = (Px[n1] - Px[n1 - 1]) * fSection;
        dy[n1] = (Py[n1] - Py[n1 - 1]) * fSection;
        float[] Bi = new float[n1];
        float[] Ax = new float[n1];
        float[] Ay = new float[n1];
        Bi[1] = 0.0f;
        Ax[1] = (Px[2] - Px[0] - dx[0]) / 4.0f;
        Ay[1] = (Py[2] - Py[0] - dy[0]) / 4.0f;
        for (int i = 2; i < n1; ++i) {
            Bi[i] = -1.0f / (4.0f + Bi[i - 1]);
            Ax[i] = -(Px[i + 1] - Px[i - 1] - Ax[i - 1]) * Bi[i];
            Ay[i] = -(Py[i + 1] - Py[i - 1] - Ay[i - 1]) * Bi[i];
        }
        boolean bAscendingRight = Py[n1 - 1] < Py[n1];
        boolean bDescendingRight = Py[n1 - 1] > Py[n1];
        boolean bAscendingLeft = false;
        boolean bDescendingLeft = false;
        boolean bEqualLeft = false;
        float temp = dy[n1];
        for (int i = n1 - 1; i > 0; --i) {
            dx[i] = Ax[i] + dx[i + 1] * Bi[i];
            temp = Ay[i] + temp * Bi[i];
            bAscendingLeft = i > 0 && Py[i - 1] < Py[i];
            bDescendingLeft = i > 0 && Py[i - 1] > Py[i];
            bEqualLeft = !bAscendingLeft && !bAscendingLeft;
            dy[i] = !bAscendingLeft && bAscendingRight || !bDescendingLeft && bDescendingRight ? 0.0f : temp;
            bAscendingRight = bAscendingLeft || bEqualLeft && bAscendingRight;
            bDescendingRight = bDescendingLeft || bEqualLeft && bDescendingRight;
        }
    }

    public static void findOpenControlPoints1(Point2D[] points, float[] dx, float[] dy) {
        int nLen = points.length;
        float[] Px = new float[nLen];
        float[] Py = new float[nLen];
        for (int i = 0; i < nLen; ++i) {
            Point2D point = points[i];
            Px[i] = (float)point.getX();
            Py[i] = (float)point.getY();
        }
        Interpolation2D.findOpenControlPointsPreservingExtrema(Px, Py, dx, dy);
    }

    public static boolean findClosedControlPoints(float[] Px, float[] Py, float[] dx, float[] dy) {
        dx[0] = 0.0f;
        dx[1] = 0.0f;
        dy[0] = 0.0f;
        dy[1] = 0.0f;
        Interpolation2D.linearProcedure(Px, Py, dx, dy);
        float Cx0 = dx[0];
        float Cy0 = dy[0];
        float Cx1 = dx[1];
        float Cy1 = dy[1];
        dx[0] = 1.0f;
        dx[1] = 0.0f;
        dy[0] = 1.0f;
        dy[1] = 0.0f;
        Interpolation2D.linearProcedure(Px, Py, dx, dy);
        float x00 = dx[0] - Cx0;
        float x10 = dx[1] - Cx1;
        float Mx00 = 1.0f - x00;
        float Mx10 = -x10;
        float y00 = dy[0] - Cy0;
        float y10 = dy[1] - Cy1;
        float My00 = 1.0f - y00;
        float My10 = -y10;
        dx[0] = 0.0f;
        dx[1] = 1.0f;
        dy[0] = 0.0f;
        dy[1] = 1.0f;
        Interpolation2D.linearProcedure(Px, Py, dx, dy);
        float x01 = dx[0] - Cx0;
        float x11 = dx[1] - Cx1;
        float Mx01 = -x01;
        float Mx11 = 1.0f - x11;
        float y01 = dy[0] - Cy0;
        float y11 = dy[1] - Cy1;
        float My01 = -y01;
        float My11 = 1.0f - y11;
        dx[0] = Float.NaN;
        dx[1] = Float.NaN;
        float dDet = Mx00 * Mx11 - Mx01 * Mx10;
        if (!((double)Math.abs(dDet) > 1.0E-6)) {
            System.out.println("Interpolation2D : Algorithm x invalid. - noninvertible transform.");
            return false;
        }
        dx[0] = (Cx0 * Mx11 - Cx1 * Mx01) / dDet;
        dx[1] = (Cx1 * Mx00 - Cx0 * Mx10) / dDet;
        dy[0] = Float.NaN;
        dy[1] = Float.NaN;
        dDet = My00 * My11 - My01 * My10;
        if (!((double)Math.abs(dDet) > 1.0E-6)) {
            System.out.println("Interpolation2D :Algorithm y invalid. - noninvertible transform.");
            return false;
        }
        dy[0] = (Cy0 * My11 - Cy1 * My01) / dDet;
        dy[1] = (Cy1 * My00 - Cy0 * My10) / dDet;
        Interpolation2D.linearProcedure(Px, Py, dx, dy);
        return true;
    }

    private static void linearProcedure(float[] Px, float[] Py, float[] dx, float[] dy) {
        int n = Px.length;
        for (int i = 0; i < n; ++i) {
            int i1 = (i + 1) % n;
            int i2 = (i + 2) % n;
            dx[i1] = (Px[i2] - Px[i] - dx[i] - dx[i2]) / 4.0f;
            dy[i1] = (Py[i2] - Py[i] - dy[i] - dy[i2]) / 4.0f;
        }
    }

    public static void createPolygon(GeneralPath path, float[] Px, float[] Py, boolean isClosed) {
        if (path == null) {
            throw new RuntimeException("Path is null");
        }
        path.reset();
        int nLen = Px.length;
        if (nLen < 1) {
            return;
        }
        path.moveTo(Px[0], Py[0]);
        if (nLen == 1) {
            return;
        }
        if (nLen == 2) {
            path.lineTo(Px[1], Py[1]);
            return;
        }
        for (int i = 1; i < nLen; ++i) {
            path.lineTo(Px[i], Py[i]);
        }
        if (isClosed) {
            path.closePath();
        }
    }

    public static void createPolygon(GeneralPath path, List list, boolean isClosed) {
        Interpolation2D.createPolygon(path, list.toArray(), isClosed);
    }

    public static void createPolygon(GeneralPath path, Object[] point, boolean isClosed) {
        if (path == null) {
            throw new RuntimeException("Path is null");
        }
        path.reset();
        int nLen = point.length;
        if (nLen < 1) {
            return;
        }
        Point2D.Float pt = (Point2D.Float)point[0];
        if (pt == null) {
            RuntimeException ex = new RuntimeException();
            System.out.println("Interpolation2D  - the method sending bad data must be fixed.");
            ex.printStackTrace();
            return;
        }
        path.moveTo(pt.x, pt.y);
        if (nLen == 1) {
            return;
        }
        if (nLen == 2) {
            path.lineTo(pt.x, pt.y);
            return;
        }
        for (int i = 1; i < nLen; ++i) {
            pt = (Point2D.Float)point[i];
            if (pt == null) continue;
            path.lineTo(pt.x, pt.y);
        }
        if (isClosed) {
            path.closePath();
        }
    }

    public static void createSmoothPath(GeneralPath path, float[] Px, float[] Py, boolean isClosed) {
        if (path == null) {
            throw new RuntimeException("Path is null");
        }
        path.reset();
        int nLen = Px.length;
        if (nLen < 1) {
            return;
        }
        path.moveTo(Px[0], Py[0]);
        if (nLen == 1) {
            return;
        }
        if (nLen == 2) {
            path.lineTo(Px[1], Py[1]);
            return;
        }
        float[] dx = new float[nLen];
        float[] dy = new float[nLen];
        if (isClosed) {
            boolean isOK = false;
            if (!isOK) {
                Interpolation2D.createPolygon(path, Px, Py, true);
                return;
            }
        } else {
            Interpolation2D.findOpenControlPointsPreservingExtrema(Px, Py, dx, dy);
        }
        int nLast = nLen - 1;
        for (int i = 0; i < nLast; ++i) {
            path.curveTo(Px[i] + dx[i], Py[i] + dy[i], Px[i + 1] - dx[i + 1], Py[i + 1] - dy[i + 1], Px[i + 1], Py[i + 1]);
        }
        if (isClosed) {
            path.curveTo(Px[nLast] + dx[nLast], Py[nLast] + dy[nLast], Px[0] - dx[0], Py[0] - dy[0], Px[0], Py[0]);
        }
    }

    public static void createSmoothPath(GeneralPath path, int[] Px, int[] Py, boolean isClosed) {
        int nLen = Px.length;
        float[] Pfx = new float[nLen];
        float[] Pfy = new float[nLen];
        for (int i = 0; i < nLen; ++i) {
            Pfx[i] = Px[i];
            Pfy[i] = Py[i];
        }
        Interpolation2D.createSmoothPath(path, Pfx, Pfy, isClosed);
    }

    public static void createSmoothPath(GeneralPath path, Polygon polygon, boolean isClosed) {
        Interpolation2D.createSmoothPath(path, polygon.xpoints, polygon.ypoints, isClosed);
    }

    public static void createSmoothPath(GeneralPath path, Object[] points, boolean isClosed) {
        Interpolation2D.createSmoothPath(path, Arrays.asList(points), isClosed);
    }

    public static void createSmoothPath(GeneralPath path, List list, boolean isClosed) {
        Object[] points = Interpolation2D.listToArrayNoDuplicates(list);
        int nLen = points.length;
        float[] Px = new float[nLen];
        float[] Py = new float[nLen];
        for (int i = 0; i < nLen; ++i) {
            Object obj = points[i];
            if (!(obj instanceof Point2D)) continue;
            Point2D p = (Point2D)obj;
            Px[i] = (float)p.getX();
            Py[i] = (float)p.getY();
        }
        Interpolation2D.createSmoothPath(path, Px, Py, isClosed);
    }

    public static final Object[] listToArrayNoDuplicates(List list) {
        Object lastObj = null;
        Object obj = null;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null || obj.equals(lastObj)) {
                it.remove();
                continue;
            }
            lastObj = obj;
        }
        return list.toArray();
    }

    public static final GeneralPath polygon2D(Object[] points) {
        return Interpolation2D.polygon2D(points, true);
    }

    public static final GeneralPath polygon2D(Object[] points, boolean isClosed) {
        GeneralPath path = new GeneralPath();
        int nLen = points.length;
        ShapeUtility.createLinearPath(path, points, nLen, isClosed);
        return path;
    }
}

