/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineProperties;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IChartSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.text.Format;
import java.text.NumberFormat;

public class TrendlineSettings {
    private IChartSettings properties;
    private static NumberFormat format = NumberFormat.getInstance();

    public TrendlineSettings(IChartSettings properties) {
        this.properties = properties;
    }

    public TrendlineType getTrendlineType(IdentObj id) {
        Integer m_Obj = (Integer)this.properties.getValue(id, Attr.CurveFitType);
        return TrendlineType.fromInt(m_Obj);
    }

    public TrendlineType getTrendlineType(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getTrendlineType(id);
    }

    public void setTrendlineType(IdentObj id, TrendlineType newValue) {
        this.properties.setValue(id, Attr.CurveFitType, new Integer(newValue.ordinal()));
    }

    public void setTrendlineType(int seriesID, TrendlineType newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setTrendlineType(id, newValue);
    }

    public void setTrendlineType(int seriesID, TrendlineType curveIndex, TrendlineType newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3, curveIndex.ordinal());
        this.setTrendlineType(id, newValue);
    }

    public TrendlineType getTrendlineType(int seriesID, TrendlineType curveIndex) {
        IdentObj id = new IdentObj(-3, seriesID, -3, curveIndex.ordinal());
        return this.getTrendlineType(id);
    }

    public void setColorAsSeries(boolean newValue) {
        this.properties.setValue(Identity.ID_GLOBAL, Attr.CurveFitColorAsSeries, newValue);
    }

    public boolean getColorAsSeries() {
        return (Boolean)this.properties.getValue(Identity.ID_GLOBAL, Attr.CurveFitColorAsSeries, true);
    }

    public void setSciMovAvg(boolean newValue) {
        this.properties.setValue(Identity.ID_GLOBAL, Attr.SciMovAvg, newValue);
    }

    public boolean getSciMovAvg() {
        return (Boolean)this.properties.getValue(Identity.ID_GLOBAL, Attr.SciMovAvg, true);
    }

    public void setCurveMoving(int newValue) {
        this.properties.setValue(Identity.ID_GLOBAL, Attr.CurveMoving, new Integer(newValue));
    }

    public int getCurveMoving() {
        return (Integer)this.properties.getValue(Identity.ID_GLOBAL, Attr.CurveMoving, true);
    }

    public void setSmoothFactor(int newValue) {
        this.properties.setValue(Identity.ID_GLOBAL, Attr.CurveSmooth, new Integer(newValue));
    }

    public int getSmoothFactor() {
        return (Integer)this.properties.getValue(Identity.ID_GLOBAL, Attr.CurveSmooth, true);
    }

    public int getPolynomialOrder(IdentObj id) {
        Integer m_Obj = (Integer)this.properties.getValue(id, Attr.CurveFitPolynomialOrder);
        return m_Obj;
    }

    public int getPolynomialOrder(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPolynomialOrder(id);
    }

    public void setPolynomialOrder(IdentObj id, int newValue) {
        this.properties.setValue(id, Attr.CurveFitPolynomialOrder, new Integer(newValue));
    }

    public void setPolynomialOrder(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPolynomialOrder(id, newValue);
    }

    public int getTrendlineNumSegments() {
        Integer m_Obj = (Integer)this.properties.getValue(Identity.ID_GLOBAL, Attr.CurveFitNumSegments);
        return m_Obj;
    }

    public void setTrendlineNumSegments(int newValue) {
        this.properties.setValue(Identity.ID_GLOBAL, Attr.CurveFitNumSegments, new Integer(newValue));
    }

    public boolean getDisplayEquation(int series) {
        Boolean value = (Boolean)this.properties.getValue(TrendlineSettings.getEquationText(series), Attr.Display);
        return value;
    }

    public void setDisplayEquation(int series, boolean newValue) {
        this.properties.setValue(TrendlineSettings.getEquationText(series), Attr.Display, newValue);
    }

    public boolean getDisplayCorrelation(int series) {
        Boolean value = (Boolean)this.properties.getValue(TrendlineSettings.getCorrelationText(series), Attr.Display);
        return value;
    }

    public Format getEquationFormat() {
        return format;
    }

    public static IdentObj getLineRiser(int s, TrendlineType index) {
        return new IdentObj(41, s, -3, index.ordinal());
    }

    public static IdentObj getLineRiser(int seriesId) {
        return new IdentObj(41, seriesId);
    }

    public static IdentObj getEquationText(int seriesId) {
        return new IdentObj(42, seriesId);
    }

    public static IdentObj getEquationText(int seriesId, TrendlineType type) {
        return new IdentObj(42, seriesId, -3, type.ordinal());
    }

    public static IdentObj getCorrelationText(int seriesId) {
        return new IdentObj(43, seriesId);
    }

    public static IdentObj getEquationTextBox(int seriesId) {
        return new IdentObj(63, seriesId);
    }

    public static IdentObj getCorrelationTextBox() {
        return new IdentObj(64);
    }

    public TrendlineProperties getSeriesOptions(int s) {
        TrendlineProperties props = new TrendlineProperties();
        props.smoothFactor = this.getSmoothFactor();
        props.polynomialOrder = this.getPolynomialOrder(s);
        props.movingAvgOrder = this.getCurveMoving();
        props.isSciMovingAvg = this.getSciMovAvg();
        return props;
    }

    static {
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        format.setGroupingUsed(false);
    }
}

