/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitGeometric
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitGeometric() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        double y = a[1] * Math.pow(x, a[2]);
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        assert (x > 0.0);
        a[1] = 1.0;
        a[2] = Math.log(x);
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        assert (y > 0.0);
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        if (ia == 1) {
            return Math.exp(a);
        }
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = "x^" + strCoeffs[2];
        return "y = " + strTerm1 + " * " + strTerm2;
    }
}

