/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateScaleUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IIntervalScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Interval;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IntervalScale;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

final class IntervalScaleFactory {
    private static final Logger _logger = Logger.getLogger((String)"IntervalScaleFactory");

    IntervalScaleFactory() {
    }

    public static IIntervalScale getIntervalScale(GregorianCalendar start, GregorianCalendar end, int base, int interval, int q1StartMonth) {
        IntervalScale intervalScale = null;
        double[] offsets = null;
        switch (interval) {
            case 1: {
                offsets = DateScaleUtils.getSecondOffsetArray(base, start, end);
                break;
            }
            case 2: {
                offsets = DateScaleUtils.getMinuteOffsetArray(base, start, end);
                break;
            }
            case 3: {
                offsets = DateScaleUtils.getHourOffsetArray(base, start, end);
                break;
            }
            case 4: {
                offsets = DateScaleUtils.getDayOffsetArray(base, start, end);
                break;
            }
            case 5: {
                offsets = DateScaleUtils.getWeekOffsetArray(base, start, end);
                break;
            }
            case 6: {
                offsets = DateScaleUtils.getMonthOffsetArray(base, start, end);
                break;
            }
            case 7: {
                offsets = DateScaleUtils.getQuarterOffsetArray(base, start, end, q1StartMonth);
                break;
            }
            case 8: {
                offsets = DateScaleUtils.getYearOffsetArray(base, start, end, q1StartMonth);
                break;
            }
            default: {
                _logger.warn((Object)("IntervalScaleFactory.getIntervalScale() was passed an unknown interval " + interval + "."));
            }
        }
        Interval intervalObj = new Interval(interval, start, end, q1StartMonth);
        intervalScale = new IntervalScale(intervalObj, offsets);
        return intervalScale;
    }
}

