/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataRange;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.RelativeAxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CircularAxisObj
extends RelativeAxisObj
implements IOrdinalAxis {
    private static final int TICKSIZE = 250;
    private static final double TICK_RADIUS_LENGTH = 0.05;
    protected static final double RELATIVE_Y1AXIS_BODY_ANGLE = 0.75;
    protected static final double RELATIVE_Y2AXIS_BODY_ANGLE = 0.0;
    protected static final double MAJOR_GRID_ANCOR = 0.33;
    protected static final double MINOR_GRID_ANCOR = 0.66;
    protected boolean m_bRadiusAxis;
    private Dimension m_frameDimVC;
    private Point m_centerFramePosVC;
    private boolean m_bVertScale;

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bAscending, boolean bVertical, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = bVertical;
        this.initVariables();
    }

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, 9, !bAscending);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = false;
        this.initVariables();
    }

    @Override
    protected void calcMajorTickLine(double fRelPos) {
    }

    @Override
    protected void calcMinorTickLine(double fRelPos) {
    }

    @Override
    protected void adjustTitlePosPass1(int nSide, List<Rectangle> labelRects, Rectangle titleRect) {
        if (titleRect != null && this.m_bRadiusAxis) {
            Rectangle r = labelRects.size() == 1 ? labelRects.get(0) : labelRects.get(1);
            if (this.m_bVertScale) {
                if (nSide == 0) {
                    titleRect.width = r.x - titleRect.x;
                    titleRect.x = r.x - titleRect.width - 50;
                } else {
                    titleRect.width = titleRect.width + titleRect.x - (r.x + r.width);
                    titleRect.x = r.x + r.width + 50;
                }
            } else {
                titleRect.y = nSide == 0 ? r.y - titleRect.height : r.y + r.height;
            }
        }
    }

    @Override
    protected void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension labelDim) {
        if (this.m_bVertScale) {
            if (nSide == 0) {
                int nRight = rTitle.x + rTitle.width;
                rTitle.width = Math.min(rTitle.width, labelDim.width);
                rTitle.x = nRight - rTitle.width;
            } else {
                rTitle.width = Math.min(rTitle.width, labelDim.width);
            }
        } else if (nSide == 0) {
            int nTop = rTitle.y + rTitle.height;
            rTitle.height = Math.min(rTitle.height, labelDim.height);
            rTitle.y = nTop - rTitle.height;
        } else {
            rTitle.height = Math.min(rTitle.height, labelDim.height);
        }
    }

    @Override
    public void calc() {
        this.initAxis();
        super.calc();
        if (this.isNumericAxis() && this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange()) {
            this.calcZeroLine();
        }
    }

    @Override
    public void calcAxisBody() {
        if (!this.m_Perspective.getDisplay(this.m_template.getBody())) {
            return;
        }
        BlackBoxObj blackBox = this.m_Perspective.getJGraphType().isPolar() ? new BlackBoxObj(this.m_Perspective, Identity.O1AxisLine) : (this.m_Perspective.getJGraphType().isPolar() ? new BlackBoxObj(this.m_Perspective, Identity.X1AxisLine) : new BlackBoxObj(this.m_Perspective, this.m_template.getBody()));
        if (this.m_bRadiusAxis) {
            Point pt1 = new Point(0, 0);
            Point pt2 = new Point(0, 0);
            double relAxisBodyAngle = this.m_template.getAxis().getObjectID() == Identity.Y1Axis.getObjectID() ? 0.75 : 0.0;
            AxisUtils.polarToCartesian(pt1, this.getAngleFromRelAngle(relAxisBodyAngle), 0.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
            AxisUtils.polarToCartesian(pt2, this.getAngleFromRelAngle(relAxisBodyAngle), 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            IdentObj idZeroLine = this.m_template.getZeroLine();
            line2D.createLine(idZeroLine, idZeroLine, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getBody()));
        } else {
            if (this.m_Perspective.getUsePGSDKViewing()) {
                return;
            }
            DrawFactory.createOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y - this.m_frameDimVC.height / 2, this.m_frameDimVC.width, this.m_frameDimVC.height, blackBox, null, true);
        }
    }

    @Override
    protected void calcMajorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMajor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMajor()), 0.33);
    }

    @Override
    protected void calcMinorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMinor()), 0.66);
    }

    protected void calcZeroLine() {
        assert (this.isNumericAxis());
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine());
        if (this.m_bRadiusAxis) {
            Rectangle rOval = this.getValueOval(this.getValueRelCoord(0.0));
            DrawFactory.createOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, true);
        } else {
            Point pt2 = new Point(0, 0);
            double angle = this.getValueCoord(0.0);
            AxisUtils.polarToCartesian(pt2, angle, 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            IdentObj idZeroLine = this.m_template.getZeroLine();
            line2D.createLine(idZeroLine, idZeroLine, this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, pt2.x, pt2.y, blackBox, null, this.m_Perspective.getLineWidth(idZeroLine));
        }
    }

    public static void cartesianToPolar(Point pt, Double angle, Double relRadius) {
    }

    @Override
    protected boolean doDisplayOnCalc() {
        return true;
    }

    @Override
    public void setDisplayOnCalc(boolean bDoNothing) {
    }

    @Override
    public boolean isVertical() {
        return this.m_bVertScale;
    }

    private double getAngleFromRelAngle(double fRelAngle) {
        double angle = fRelAngle * 360.0 + 90.0 + (double)this.m_Perspective.getPieRotate();
        if (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    @Override
    public int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    @Override
    protected boolean isAxisLabelVisible(int nSide) {
        return true;
    }

    @Override
    public double getBaseCoord() {
        assert (this.isNumericAxis());
        if (this.m_bRadiusAxis) {
            return this.getBaseRelCoord();
        }
        return this.getAngleFromRelAngle(this.getBaseRelCoord());
    }

    @Override
    public double getCenterCoord(int g) {
        if (!this.isNumericAxis()) {
            if (this.m_bRadiusAxis) {
                return this.getCenterRelCoord(g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle(this.getCenterRelCoord(g));
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new RuntimeException("Ordinal method called by numerical axis");
    }

    @Override
    public int getGroupAboveCoord(int nCoord) {
        if (!this.isNumericAxis()) {
            return 0;
        }
        throw new RuntimeException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public int getGroupBelowCoord(int nCoord) {
        if (!this.isNumericAxis()) {
            return 0;
        }
        throw new RuntimeException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public double getHighCoord(int s, int g) {
        if (!this.isNumericAxis()) {
            if (this.m_bRadiusAxis) {
                return this.getHighRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle((double)g / (double)this.m_numGroups);
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new RuntimeException("Ordinal method called by numerical axis");
    }

    @Override
    protected void getLabelAndTitlePos(int nSide, int nLabels, List<Rectangle> rLabels, List<Double> fRelPos, List<Integer> align, Rectangle rTitle, boolean bRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, ITextStyle textStyleLabel) {
        int nMaxDim;
        Integer nAlign = null;
        Rectangle rSpace = this.getSpaceAvailable(nSide, this.m_Perspective.getVC());
        int[] nPos = new int[nLabels];
        int titleHeight = 0;
        if (this.m_bRadiusAxis) {
            int i;
            titleHeight = rTitle != null ? (this.m_bVertScale ? Math.min(rSpace.width / 3, 2300) : Math.min(rSpace.height / 3, 2300)) : 0;
            for (int i2 = 0; i2 < nLabels; ++i2) {
                Point pt = new Point(0, 0);
                double radius = fRelPos.get(i2);
                if (this.m_bVertScale) {
                    AxisUtils.polarToCartesian(pt, 90.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
                    nPos[i2] = pt.y;
                    continue;
                }
                AxisUtils.polarToCartesian(pt, 0.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
                nPos[i2] = pt.x;
            }
            nMaxDim = Math.abs(nPos[1] - nPos[0]);
            nAlign = nSide == 0 ? (this.m_bVertScale ? new Integer(5) : new Integer(3)) : (this.m_bVertScale ? new Integer(1) : new Integer(7));
            for (i = 0; i < nLabels; ++i) {
                align.add(i, nAlign);
            }
            for (i = 0; i < nLabels; ++i) {
                Rectangle r = this.m_bVertScale ? new Rectangle(rSpace.x, nPos[i] - nMaxDim / 2, rSpace.width, nMaxDim) : new Rectangle(nPos[i] - nMaxDim / 2, rSpace.y, nMaxDim, rSpace.height);
                rLabels.add(i, r);
            }
        } else {
            Dimension dim = this.m_Perspective.getVC().getVirtDimension();
            Point pt = new Point(0, 0);
            double radiusFudge = 1.0;
            if (this.m_Perspective.getJGraphType().isPolar() || this.m_Perspective.getJGraphType().isRadarType()) {
                radiusFudge = 1.1;
            }
            for (int i = 0; i < nLabels; ++i) {
                int maxHalfWidth;
                Rectangle r;
                int maxHalfHeight;
                double angle = this.getAngleFromRelAngle(fRelPos.get(i));
                AxisUtils.polarToCartesian(pt, angle, radiusFudge, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
                if (angle > 355.0 || angle < 5.0) {
                    maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(pt.x, pt.y - maxHalfHeight, dim.width / 2 - pt.x, 2 * maxHalfHeight);
                    nAlign = new Integer(1);
                } else if (angle < 80.0) {
                    r = new Rectangle(pt.x, pt.y, dim.width / 2 - pt.x, dim.height / 2 - pt.y);
                    nAlign = new Integer(8);
                } else if (angle < 100.0) {
                    maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, pt.y, maxHalfWidth * 2, dim.height / 2 - pt.y);
                    nAlign = new Integer(7);
                } else if (angle < 175.0) {
                    r = new Rectangle(-dim.width / 2, pt.y, pt.x + dim.width / 2, dim.height / 2 - pt.y);
                    nAlign = new Integer(6);
                } else if (angle < 185.0) {
                    maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(-dim.width / 2, pt.y - maxHalfHeight, pt.x + dim.width / 2, 2 * maxHalfHeight);
                    nAlign = new Integer(5);
                } else if (angle < 260.0) {
                    r = new Rectangle(-dim.width / 2, -dim.height / 2, pt.x + dim.width / 2, dim.height / 2 + pt.y);
                    nAlign = new Integer(4);
                } else if (angle < 280.0) {
                    maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, -dim.height / 2, maxHalfWidth * 2, dim.height / 2 + pt.y);
                    nAlign = new Integer(3);
                } else {
                    r = new Rectangle(pt.x, -dim.height / 2, dim.width / 2 - pt.x, pt.y + dim.height / 2);
                    nAlign = new Integer(2);
                }
                align.add(i, nAlign);
                rLabels.add(i, r);
            }
        }
        if (rTitle != null) {
            if (this.m_bRadiusAxis) {
                nMaxDim = Math.abs(nPos[1] - nPos[0]);
                if (this.m_bVertScale) {
                    rTitle.y = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                    rTitle.height = nMaxDim * nLabels;
                    rTitle.width = rSpace.width;
                    rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - titleHeight;
                } else {
                    rTitle.x = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                    rTitle.width = nMaxDim * nLabels;
                    rTitle.height = rSpace.height;
                    rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - titleHeight;
                }
            } else {
                VC vc = this.m_Perspective.getVC();
                rTitle.setBounds(vc.getVirtCoords());
                int half = Math.min(this.m_centerFramePosVC.x - vc.getMinX(), vc.getMaxX() - this.m_centerFramePosVC.x);
                rTitle.x = this.m_centerFramePosVC.x - half;
                rTitle.width = 2 * half;
                rTitle.height = 2500;
                if (nSide == 0) {
                    rTitle.y = vc.getMinY() + rTitle.height;
                }
            }
        }
    }

    @Override
    public List<String> getLabels() {
        if (this.isNumericAxis()) {
            return this.getNumericLabels();
        }
        int nLabels = this.getNumLabels();
        ArrayList<String> szLabels = new ArrayList<String>(nLabels);
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_Access.getNumTotalGroups());
            String szLabel = this.m_Perspective.getGroupLabel(g);
            szLabels.add(szLabel.trim());
        }
        return szLabels;
    }

    protected Vector<IdentObj> getLabelIdents() {
        if (this.isNumericAxis()) {
            return null;
        }
        Vector<IdentObj> idents = new Vector<IdentObj>(this.getNumLabels());
        DataRange drViewSG = this.m_Perspective.getViewableDataRangeSG();
        int nViewGroupStart = drViewSG.getColStart();
        int nViewGroupStop = drViewSG.getColStop();
        for (int g = nViewGroupStart; g <= nViewGroupStop; ++g) {
            idents.addElement(new IdentObj(-3, -3, g));
        }
        return idents;
    }

    @Override
    public double getLowCoord(int s, int g) {
        if (!this.isNumericAxis()) {
            if (this.m_bRadiusAxis) {
                return this.getLowRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle((double)g / (double)this.m_numGroups);
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new RuntimeException("Ordinal method called by numerical axis");
    }

    @Override
    protected boolean getMajorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajor());
    }

    @Override
    protected boolean getMinorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinor());
    }

    @Override
    protected boolean getMajorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajorTick());
    }

    @Override
    protected boolean getMinorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinorTick());
    }

    private Rectangle getSpaceAvailable(int nSide, VC vc) {
        Rectangle rSpace = this.m_bRadiusAxis ? (nSide == 0 ? (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y - 300 - this.m_frameDimVC.height / 2, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2)) : (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2))) : new Rectangle(0, 0, 0, 0);
        return rSpace;
    }

    @Override
    protected int getTitleRotation(AxisTemplate template, int nSide) {
        int nRotation = this.m_bRadiusAxis ? (nSide == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 2 ? 2 : 1) : (nSide == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 1 ? 1 : 2) : 0)) : 0;
        return nRotation;
    }

    @Override
    public double getValueCoord(double fValue) {
        if (this.m_bRadiusAxis) {
            return this.getValueRelCoord(fValue);
        }
        return this.getAngleFromRelAngle(this.getValueRelCoord(fValue));
    }

    @Override
    public double getValueFromCoord(int nCoord) {
        return 0.0;
    }

    public Rectangle getValueOval(double fRelValue) {
        if (this.m_bRadiusAxis) {
            return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_frameDimVC.width / 2) * fRelValue), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_frameDimVC.height / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.width / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.height / 2) * fRelValue));
        }
        throw new RuntimeException("Radius method called by non Radius axis");
    }

    private void initAxis() {
        Rectangle rFrame = this.m_Perspective.getFrameRect(false);
        this.m_frameDimVC.width = rFrame.width;
        this.m_frameDimVC.height = rFrame.height;
        this.m_centerFramePosVC.x = rFrame.x + rFrame.width / 2;
        this.m_centerFramePosVC.y = rFrame.y + rFrame.height / 2;
    }

    private void initVariables() {
        this.m_frameDimVC = new Dimension(0, 0);
        this.m_centerFramePosVC = new Point(0, 0);
    }

    private void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, IBlackBox blackBox, double fLineWidth, double ancor) {
        Point pt1 = new Point(0, 0);
        Point pt2 = new Point(0, 0);
        if (this.m_bRadiusAxis) {
            if (nStyle == 0 || nStyle == 1) {
                Rectangle rOval = this.getValueOval(fRelPos);
                DrawFactory.createOval(this.m_Perspective.getDetectiv(), id, rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, true);
            } else {
                int nSide = this.getAxisSide();
                if (this.m_bVertScale) {
                    pt1.y = pt2.y = (int)((double)this.m_centerFramePosVC.y + (double)(this.m_frameDimVC.height / 2) * fRelPos + 0.5);
                    pt1.x = this.m_centerFramePosVC.x;
                    if (nSide == 0 && nStyle == 3 || nSide == 1 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt1.x -= 250;
                    }
                    pt2.x = this.m_centerFramePosVC.x;
                    if (nSide == 1 && nStyle == 3 || nSide == 0 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt2.x += 250;
                    }
                } else {
                    pt1.x = pt2.x = (int)((double)this.m_centerFramePosVC.x + (double)(this.m_frameDimVC.width / 2) * fRelPos + 0.5);
                    pt1.y = this.m_centerFramePosVC.y;
                    if (nSide == 0 && nStyle == 2 || nSide == 1 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt1.y += 250;
                    }
                    pt2.y = this.m_centerFramePosVC.y;
                    if (nSide == 1 && nStyle == 2 || nSide == 0 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt2.y -= 250;
                    }
                }
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(id, id, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, fLineWidth);
            }
        } else {
            double fPosOut;
            double fPosIn;
            switch (nStyle) {
                case 1: {
                    fPosIn = ancor;
                    fPosOut = 1.05;
                    break;
                }
                case 2: {
                    fPosIn = 0.95;
                    fPosOut = 1.0;
                    break;
                }
                case 3: {
                    fPosIn = 1.0;
                    fPosOut = 1.05;
                    break;
                }
                case 4: {
                    fPosIn = 0.95;
                    fPosOut = 1.05;
                    break;
                }
                default: {
                    fPosIn = ancor;
                    fPosOut = 1.0;
                }
            }
            double angle = this.getAngleFromRelAngle(fRelPos);
            AxisUtils.polarToCartesian(pt1, angle, fPosIn, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
            AxisUtils.polarToCartesian(pt2, angle, fPosOut, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.getVC());
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            IdentObj idMajor = this.m_template.getMajor();
            line2D.createLine(idMajor, idMajor, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, this.m_Perspective.getLineWidth(idMajor));
        }
    }
}

