/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.IModel3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DSurfaceSide;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DSurfaceTopo;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.util.ArrayList;

class JChart_3D_Surf
extends JChart_3D {
    public static final boolean FIRST_RISER_FOR_ID = true;
    public static final int FIRST_OFFSET = 100;
    protected SeriesEnumerator m_sEnum = null;
    protected GroupsEnumerator m_gEnum = null;
    protected boolean[][] m_bGridStatus = new boolean[2][3];
    protected double m_dFirstPointX = 0.0;
    protected double m_dFirstPointZ = 0.0;
    protected double m_dLastPointX = 0.0;
    protected double m_dLastPointZ = 0.0;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_3D_Surf(perspective);
        }
    };

    JChart_3D_Surf(Perspective perspective) {
        super(perspective);
    }

    public void define3DMatrixObjects() {
        boolean bInternalSides = false;
        boolean bBorderSides = false;
        boolean bTop = false;
        this.m_sEnum = this.getResetSeriesEnumerator();
        this.m_gEnum = this.getResetGroupsEnumerator();
        this.m_objectList = new ArrayList(this.m_nSeries * this.m_nGroups);
        this.m_bGridStatus[0][0] = false;
        this.m_bGridStatus[0][1] = false;
        this.m_bGridStatus[0][2] = false;
        this.m_bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        this.m_bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        this.m_bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        bTop = this.hasTop();
        bBorderSides = this.hasBorderSides();
        bInternalSides = this.hasInternalSides();
        int sFirst = this.m_sEnum.get(0);
        int sLast = this.m_sEnum.getLast();
        if (this.m_sEnum.hasNext()) assert (sFirst >= 0 && sLast >= 0);
        int sFirstRel = this.m_sEnum.getRelative(sFirst);
        assert (sFirstRel >= 0 && sFirstRel < this.m_nSeries);
        int sLastRel = this.m_sEnum.getRelative(sLast);
        assert (sLastRel >= 0 && sLastRel < this.m_nSeries);
        int gFirst = this.m_gEnum.get(0);
        int gLast = this.m_gEnum.getLast();
        if (this.m_gEnum.hasNext()) assert (gFirst >= 0 && gLast >= 0);
        int gFirstRel = this.m_gEnum.getRelative(gFirst);
        assert (gFirstRel >= 0 && gFirstRel < this.m_nGroups);
        int gLastRel = this.m_gEnum.getRelative(gLast);
        assert (gLastRel >= 0 && gLastRel < this.m_nGroups);
        this.m_dFirstPointX = this.m_O2Axis.getCenterCoord(sFirstRel);
        this.m_dFirstPointZ = this.m_O1Axis.getCenterCoord(gFirstRel);
        this.m_dLastPointX = this.m_O2Axis.getCenterCoord(sLastRel);
        this.m_dLastPointZ = this.m_O1Axis.getCenterCoord(gLastRel);
        this.defineRisers(bTop, bInternalSides, bBorderSides);
    }

    protected void defineRisers(boolean bTop, boolean bInternalSides, boolean bBorderSides) {
        if (bTop) {
            this.getTopRisers();
        }
        if (bInternalSides) {
            this.getSideRisers(true);
            this.getSideRisers(false);
        }
        if (bBorderSides) {
            this.getFrontConnectedSeries();
            this.getFrontConnectedGroups();
        }
    }

    protected boolean hasTop() {
        return !this.m_gt.equals(14);
    }

    protected boolean hasBorderSides() {
        return !this.m_gt.equals(12);
    }

    protected boolean hasInternalSides() {
        return this.m_gt.equals(14);
    }

    protected void getTopRisers() {
        int sNextRel = 0;
        int gNextRel = 0;
        double hx = this.m_dFirstPointX;
        Point3d[] vertices = new Point3d[4];
        while (this.m_sEnum.hasNext()) {
            int s = this.m_sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (!this.m_sEnum.hasNext()) continue;
            int sNext = this.m_sEnum.peekNext();
            assert (sNext >= 0 && sNext < this.m_nTotalSeries);
            sNextRel = this.m_sEnum.getRelative(sNext);
            assert (sNextRel >= 0 && sNextRel < this.m_nSeries);
            double lx = hx;
            hx = this.m_O2Axis.getCenterCoord(sNextRel);
            double hz = this.m_dFirstPointZ;
            this.m_gEnum.reset();
            while (this.m_gEnum.hasNext()) {
                int g = this.m_gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_gEnum.hasNext()) continue;
                int gNext = this.m_gEnum.peekNext();
                assert (gNext >= 0 && gNext < this.m_nTotalGroups);
                gNextRel = this.m_gEnum.getRelative(gNext);
                assert (gNextRel >= 0 && gNextRel < this.m_nGroups);
                double lz = hz;
                hz = this.m_O1Axis.getCenterCoord(gNextRel);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext] || !this.m_dataOK[sNext][g] || !this.m_dataOK[sNext][gNext]) continue;
                double y1 = this.m_numYCoords[s][g];
                double y2 = this.m_numYCoords[sNext][g];
                double y3 = this.m_numYCoords[sNext][gNext];
                double y4 = this.m_numYCoords[s][gNext];
                IdentObj id = new IdentObj(1005, s, g);
                for (int i = 0; i < 4; ++i) {
                    vertices[i] = new Point3d(0.0, 0.0, 0.0);
                }
                vertices[0].x = lx;
                vertices[1].x = vertices[2].x = hx;
                vertices[2].z = hz;
                vertices[0].z = vertices[1].z = lz;
                vertices[0].y = y1;
                vertices[1].y = y2;
                vertices[2].y = y3;
                vertices[3].x = lx;
                vertices[3].z = hz;
                vertices[3].y = y4;
                this.defineRiserSurfaceObjectForRectangle(id, vertices);
            }
        }
    }

    protected void defineRiserSurfaceObjectForRectangle(IdentObj id, Point3d[] vertices) {
        IModel3D riser2;
        IModel3D riser1 = this.defineRiserSurfaceObjectForTriangle(id, vertices, true, true);
        if (riser1 != null) {
            this.m_objectList.add(riser1);
        }
        if ((riser2 = this.defineRiserSurfaceObjectForTriangle(id, vertices, false, false)) != null) {
            this.m_objectList.add(riser2);
        }
    }

    protected void getSideRisers(boolean bConnectedSeries) {
        double y0 = this.getOriginYCoord();
        int sNextRel = 0;
        int gNextRel = 0;
        double hx = this.m_dFirstPointX;
        Point3d[] vertices = new Point3d[4];
        this.m_sEnum.reset();
        this.m_gEnum.reset();
        while (this.m_sEnum.hasNext()) {
            int s = this.m_sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (!this.m_sEnum.hasNext()) continue;
            int sNext = this.m_sEnum.peekNext();
            assert (sNext >= 0 && sNext < this.m_nTotalSeries);
            sNextRel = this.m_sEnum.getRelative(sNext);
            assert (sNextRel >= 0 && sNextRel < this.m_nSeries);
            double lx = hx;
            hx = this.m_O2Axis.getCenterCoord(sNextRel);
            double hz = this.m_dFirstPointZ;
            this.m_gEnum.reset();
            while (this.m_gEnum.hasNext()) {
                int i;
                int g = this.m_gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_gEnum.hasNext()) continue;
                int gNext = this.m_gEnum.peekNext();
                assert (gNext >= 0 && gNext < this.m_nTotalGroups);
                gNextRel = this.m_gEnum.getRelative(gNext);
                assert (gNextRel >= 0 && gNextRel < this.m_nGroups);
                double lz = hz;
                hz = this.m_O1Axis.getCenterCoord(gNextRel);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext] || !this.m_dataOK[sNext][g] || !this.m_dataOK[sNext][gNext]) continue;
                IdentObj id = new IdentObj(1005, s, g);
                if (bConnectedSeries) {
                    for (i = 0; i < 4; ++i) {
                        vertices[i] = new Point3d(0.0, y0, hz);
                    }
                    vertices[0].x = vertices[3].x = lx;
                    vertices[1].x = vertices[2].x = hx;
                    vertices[2].y = this.m_numYCoords[sNext][gNext];
                    vertices[3].y = this.m_numYCoords[s][gNext];
                } else {
                    for (i = 0; i < 4; ++i) {
                        vertices[i] = new Point3d(lx, y0, 0.0);
                    }
                    vertices[0].z = vertices[3].z = lz;
                    vertices[1].z = vertices[2].z = hz;
                    vertices[2].y = this.m_numYCoords[s][gNext];
                    vertices[3].y = this.m_numYCoords[s][g];
                }
                IModel3D riser1 = this.defineRiserSurfaceObjectForTriangle(id, vertices, true, true);
                if (riser1 != null) {
                    this.m_objectList.add(riser1);
                }
                vertices[1] = vertices[3];
                IModel3D riser2 = this.defineRiserSurfaceObjectForTriangle(id, vertices, false, true);
                if (riser2 == null) continue;
                this.m_objectList.add(riser2);
            }
        }
    }

    protected void getFrontConnectedSeries() {
        double y0 = this.getOriginYCoord();
        int sNextRel = 0;
        int gNextRel = 0;
        double hx = this.m_dFirstPointX;
        Point3d[] vertices = new Point3d[4];
        this.m_sEnum.reset();
        this.m_gEnum.reset();
        int g = this.m_gEnum.next();
        int gNext = this.m_gEnum.peekNext();
        gNextRel = this.m_gEnum.getRelative(gNext);
        double lz = this.m_dFirstPointZ;
        while (this.m_sEnum.hasNext() && gNext >= 0) {
            int s = this.m_sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (!this.m_sEnum.hasNext()) continue;
            int sNext = this.m_sEnum.peekNext();
            assert (sNext >= 0 && sNext < this.m_nTotalSeries);
            sNextRel = this.m_sEnum.getRelative(sNext);
            assert (sNextRel >= 0 && sNextRel < this.m_nSeries);
            double lx = hx;
            hx = this.m_O2Axis.getCenterCoord(sNextRel);
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext] || !this.m_dataOK[sNext][g] || !this.m_dataOK[sNext][gNext]) continue;
            IdentObj id = new IdentObj(1005, s, g);
            for (int i = 0; i < 4; ++i) {
                vertices[i] = new Point3d(0.0, y0, lz);
            }
            vertices[0].x = vertices[3].x = lx;
            vertices[1].x = vertices[2].x = hx;
            vertices[2].y = this.m_numYCoords[sNext][g];
            vertices[3].y = this.m_numYCoords[s][g];
            IModel3D riser1 = this.defineRiserSideObject(id, vertices, true);
            if (riser1 == null) continue;
            this.m_objectList.add(riser1);
        }
    }

    private void getFrontConnectedGroups() {
        double y0 = this.getOriginYCoord();
        int sNextRel = 0;
        int gNextRel = 0;
        double hz = this.m_dFirstPointZ;
        Point3d[] vertices = new Point3d[4];
        this.m_gEnum.reset();
        SeriesEnumerator reverseNum = this.getResetSeriesEnumerator(false);
        int s = reverseNum.next();
        boolean bOneSeries = reverseNum.size() == 1;
        int sNext = reverseNum.peekNext();
        sNextRel = reverseNum.getRelative(sNext);
        double lx = this.m_dLastPointX;
        while (this.m_gEnum.hasNext()) {
            int g = this.m_gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_gEnum.hasNext()) continue;
            int gNext = this.m_gEnum.peekNext();
            assert (gNext >= 0 && gNext < this.m_nTotalGroups);
            gNextRel = this.m_gEnum.getRelative(gNext);
            assert (gNextRel >= 0 && gNextRel < this.m_nGroups);
            double lz = hz;
            hz = this.m_O1Axis.getCenterCoord(gNextRel);
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext] || (bOneSeries || !this.m_dataOK[sNext][g] || !this.m_dataOK[sNext][gNext]) && !bOneSeries) continue;
            IdentObj id = !bOneSeries ? new IdentObj(1005, sNext, g) : new IdentObj(1005, s, g);
            for (int i = 0; i < 4; ++i) {
                vertices[i] = new Point3d(lx, y0, 0.0);
            }
            vertices[0].z = vertices[3].z = lz;
            vertices[1].z = vertices[2].z = hz;
            vertices[2].y = this.m_numYCoords[s][gNext];
            vertices[3].y = this.m_numYCoords[s][g];
            IModel3D riser1 = this.defineRiserSideObject(id, vertices, true);
            if (riser1 == null) continue;
            this.m_objectList.add(riser1);
        }
    }

    public IModel3D defineRiserSurfaceObjectForTriangle(IdentObj id, Point3d[] vertices, boolean bFrontTriangle, boolean bFirstRiserForID) {
        IdentObj newID = id;
        if (bFirstRiserForID) {
            newID = newID.changeMisc(100);
        }
        Model3DSurfaceTopo riser = new Model3DSurfaceTopo((JChart_3D)this, newID, null, vertices, this.m_bGridStatus, bFrontTriangle, this.m_bColorAutoshading);
        riser.calcGrids();
        return riser;
    }

    public IModel3D defineRiserSideObject(IdentObj id, Point3d[] vertices, boolean bFirstRiserForID) {
        IdentObj newID = id;
        if (bFirstRiserForID) {
            newID = newID.changeMisc(100);
        }
        Model3DSurfaceSide riser = new Model3DSurfaceSide(this, newID, null, vertices, this.m_bGridStatus, this.m_bColorAutoshading);
        riser.calcGrids();
        return riser;
    }

    protected int getYCoordForHeight(int s, int g) {
        SeriesEnumerator m_sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator m_gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        int yCoord = 0;
        int sNext = m_sEnum.peekAfter(s);
        int gNext = m_gEnum.peekAfter(g);
        if (this.m_dataOK[s][g]) {
            yCoord = this.m_numYCoords[s][g];
        }
        if (sNext != -1 && this.m_dataOK[sNext][g] && this.m_numYCoords[sNext][g] > yCoord) {
            yCoord = this.m_numYCoords[sNext][g];
        }
        if (gNext != -1 && this.m_dataOK[s][gNext] && this.m_numYCoords[s][gNext] > yCoord) {
            yCoord = this.m_numYCoords[s][gNext];
        }
        if (sNext != -1 && gNext != -1 && this.m_dataOK[sNext][gNext] && this.m_numYCoords[sNext][gNext] > yCoord) {
            yCoord = this.m_numYCoords[sNext][gNext];
        }
        return yCoord;
    }

    public boolean wantLegend() {
        return this.m_nEffColorMode == 3;
    }

    final float[] calcCoordsArray(SeriesEnumerator senum, IOrdinalAxis axis) {
        return this.calcCoordsArray(senum, axis, 0.0f);
    }

    float[] calcCoordsArray(SeriesEnumerator senum, IOrdinalAxis axis, float fShift) {
        senum.reset();
        int nLen = senum.size();
        float[] xx = new float[nLen];
        int nIndex = 0;
        while (senum.hasNext()) {
            int s = senum.next();
            int sNextRel = senum.getRelative(s);
            xx[nIndex] = (float)axis.getCenterCoord(sNextRel) + fShift;
            ++nIndex;
        }
        senum.reset();
        return xx;
    }

    final float[] calcCoordsArray(GroupsEnumerator genum, IOrdinalAxis axis) {
        return JChart_3D_Surf.calcCoordsArray(genum, axis, 0.0f);
    }

    static float[] calcCoordsArray(GroupsEnumerator genum, IOrdinalAxis axis, float fShift) {
        genum.reset();
        int nLen = genum.size();
        float[] xx = new float[nLen];
        for (int nIndex = nLen - 1; nIndex >= 0; --nIndex) {
            int g = genum.next();
            int gNextRel = genum.getRelative(g);
            xx[nIndex] = (float)axis.getCenterCoord(gNextRel) + fShift;
        }
        genum.reset();
        return xx;
    }

    final float[][] calcValuesArray(SeriesEnumerator sEnum, GroupsEnumerator gEnum) {
        return this.calcValuesArray(sEnum, gEnum, 0.0f);
    }

    float[][] calcValuesArray(SeriesEnumerator sEnum, GroupsEnumerator gEnum, float fShift) {
        int indexG = 0;
        int indexS = 0;
        int gLen = gEnum.size();
        sEnum.reset();
        int sLen = sEnum.size();
        float[][] yy = new float[sLen][gLen];
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            gEnum.reset();
            for (indexG = gLen - 1; indexG >= 0; --indexG) {
                int g = gEnum.next();
                yy[indexS][indexG] = (float)this.m_numYCoords[s][g] + fShift;
            }
            ++indexS;
        }
        sEnum.reset();
        gEnum.reset();
        return yy;
    }

    public IBlackBox getModelBlackBox(IdentObj id) {
        int series = id.getSeriesID();
        int group = id.getGroupID();
        if (this.m_Perspective.isColorByHeight() && series != -3) {
            return super.getModelBlackBox(id);
        }
        return this.assignSeriesColor(series + 1, group + 1);
    }
}

