/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataTextPositionWaterfall;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.AxisSplits;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Bar2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Scaling;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.WaterfallStackedBar;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

class JChart_2D_Waterfall
extends JChart_2D {
    private IOrdinalAxis m_O1Axis;
    private INumericAxis m_Y1Axis;
    private INumericAxis m_Y1RelAxisObj;
    private boolean m_bBarAsPictograph;
    private boolean m_bHorz = false;
    private List<WaterfallStackedBar> m_vectWaterfallStackedBars;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Waterfall(perspective);
        }
    };

    private JChart_2D_Waterfall(Perspective perspective) {
        super(perspective);
    }

    public IOrdinalAxis getO1Axis() {
        return this.m_O1Axis;
    }

    public INumericAxis getY1Axis() {
        return this.m_Y1Axis;
    }

    public void calc() {
        super.calc();
        this.m_bar2D = new Bar2D(this.m_Perspective, this.getDrawContainer());
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        boolean bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        boolean bDisplayWaterfallLine = this.m_Perspective.getDisplay(Identity.WaterfallLine);
        this.calcDataSign();
        this.createStackedBars();
        this.calcDataCumulative();
        this.createAxes();
        this.drawAxisBody();
        this.calcBarOrdinalCoords();
        this.calcBarRectsAndDataText(bDataTextDisplay);
        if (this.wantDepthEffect()) {
            if (this.m_bHorz) {
                if (bDisplayWaterfallLine) {
                    this.drawAllWaterfallLines(this.m_bHorz);
                }
                this.drawBarRisersStacked();
            } else {
                this.drawBarRisersStacked();
                if (bDisplayWaterfallLine) {
                    this.drawAllWaterfallLines(this.m_bHorz);
                }
            }
        } else {
            this.drawBarRisersStacked();
            if (bDisplayWaterfallLine) {
                this.drawAllWaterfallLines(this.m_bHorz);
            }
        }
        if (bDataTextDisplay) {
            this.drawAllDataTextLabels();
        }
    }

    private void calcDataSign() {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            int sFirst = sEnum.get(0);
            double fFirstSeriesValue = 0.0;
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                DatumObj dObj = this.getDataValue(s, g);
                if (dObj.m_bOK) {
                    double fValue = dObj.value;
                    if (s == sFirst) {
                        fFirstSeriesValue = fValue;
                        continue;
                    }
                    if (!(fFirstSeriesValue <= 0.0 && fValue > 0.0) && (!(fFirstSeriesValue > 0.0) || !(fValue < 0.0))) continue;
                    this.getDataView().setDataAsDouble(s, g, DataItem.DI_GENERAL, -fValue, true);
                    continue;
                }
                this.getDataView().setDataAsDouble(s, g, DataItem.DI_GENERAL, 0.0, true);
            }
        }
    }

    private WaterfallStackedBar getWaterfallStackedBar(int g) {
        WaterfallStackedBar stackedBar = this.m_vectWaterfallStackedBars.get(g);
        return stackedBar;
    }

    private void createStackedBars() {
        this.m_vectWaterfallStackedBars = new ArrayList<WaterfallStackedBar>();
        for (int g = 0; g < this.m_nTotalGroups; ++g) {
            WaterfallStackedBar stackedBar = new WaterfallStackedBar();
            stackedBar.createSeriesArrays(this.m_nTotalSeries);
            this.m_vectWaterfallStackedBars.add(stackedBar);
        }
    }

    private MinMaxObj findLimits(int nAxis, int nScaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        MinMaxObj minMaxObj = this.findPreScaledLimits(nAxis, nScaling, bMustIncludeZero);
        if (minMaxObj == null) {
            DataFormat dataFormat = this.getDataView().getDataFormat();
            Scaling scaleNew = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
            minMaxObj = scaleNew.findLimits(nAxis, nScaling, bMustIncludeZero, mmZoom, dataFormat);
        }
        return minMaxObj;
    }

    private void createAxes() {
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] offsetArray = axisSplits.getAxisOffsets();
        int[] sizeArray = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bVerticalChart = this.m_gt.getOrientation() == 2;
        this.m_O1Axis = AxisFactory.create2DOrdinalAxis(this.m_Perspective, this.getDataView(), AxisTemplate.O1_AXIS, 1, !bVerticalChart, bVerticalChart);
        this.calcAxis(this.m_O1Axis);
        this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
        if (this.m_Y1Axis != null) {
            this.calcAxis(this.m_Y1Axis);
        }
    }

    private void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        int nScaling = this.m_gt.getScalingMethod();
        MinMaxObj y1MinMaxObj = this.findLimits(0, nScaling, bMustIncludeZero, null);
        this.m_Y1RelAxisObj = this.m_Y1Axis = AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    private void calcAxis(IAxis axis) {
        if (axis != null) {
            axis.calc();
            if (axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(axis.getAxisTextLabelSizeVC());
            }
        }
    }

    private void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
    }

    private void calcBarOrdinalCoords() {
        int nAxisOffset = 0;
        int nBarThicknessVC = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        GroupsEnumerator gEnum = this.m_gEnumForward;
        for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
            int g = gEnum.get(gRel);
            assert (g >= 0 && g < this.m_nTotalGroups);
            WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
            int nCoord = (int)this.m_O1Axis.getLowCoord(nAxisOffset, gRel);
            stackedBar.setOrdCoord(nCoord);
            stackedBar.setBarThickness(nBarThicknessVC);
        }
    }

    private void calcDataCumulative() {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int gFirst = gEnum.get(0);
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
            switch (nGroupMode) {
                case 1: 
                case 2: {
                    this.calcDataGroupSubtotal(g, gFirst);
                    break;
                }
                case 0: 
                case 3: 
                case 4: {
                    DatumObj dObj = this.getDataValue(0, g);
                    double fValue = dObj.value;
                    if (fValue >= 0.0) {
                        this.calcDataGroupNormalPositive(g, gEnum);
                        break;
                    }
                    this.calcDataGroupNormalNegative(g, gEnum);
                }
            }
        }
    }

    private void calcDataGroupNormalPositive(int g, GroupsEnumerator gEnum) {
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        double fSum = this.getEndOfPrevStack(g, gEnum, sEnum);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            DatumObj dObj = this.getDataValue(s, g);
            double fValue = dObj.value;
            stackedBar.setStackedCumulativeValue(s, fSum += fValue);
        }
    }

    private void calcDataGroupNormalNegative(int g, GroupsEnumerator gEnum) {
        int sLast;
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        SeriesEnumerator seriesIter = this.getResetSeriesEnumerator();
        double fSum = this.getEndOfPrevStack(g, gEnum, seriesIter);
        for (int sBack = sLast = seriesIter.get(seriesIter.size() - 1); sBack != -1; --sBack) {
            int s = seriesIter.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            DatumObj dObj = this.getDataValue(sBack, g);
            double fValue = dObj.value;
            stackedBar.setStackedCumulativeValue(s, fSum += fValue);
        }
    }

    private double getSumSeriesUpToThisGroup(GroupsEnumerator gEnumForwardNew, int s, int g) {
        double fSum = 0.0;
        gEnumForwardNew.reset();
        int gIdx = gEnumForwardNew.next();
        while (gIdx < g) {
            int nGroupMode = this.m_Perspective.getWaterfallGroupMode(gIdx);
            if (nGroupMode == 0) {
                DatumObj dObj = this.getDataValue(s, gIdx);
                double fValue = dObj.value;
                if (dObj.m_bOK) {
                    fSum += fValue;
                }
            }
            gIdx = gEnumForwardNew.next();
        }
        return fSum;
    }

    private void calcDataGroupSubtotal(int g, int gFirst) {
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        boolean bPositive = this.isSubtotalPositive(g, gFirst);
        stackedBar.setSubtotalPositive(bPositive);
        GroupsEnumerator gEnumForwardNew = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fCumulSum = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int sBack = sEnum.getLast();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            double fSum = 0.0;
            if (g != gFirst) {
                fSum = this.getSumSeriesUpToThisGroup(gEnumForwardNew, s, g);
            }
            if (bPositive) {
                this.getDataView().setDataAsDouble(s, g, DataItem.DI_GENERAL, fSum, true);
                fCumulSum += fSum;
            } else {
                this.getDataView().setDataAsDouble(sBack, g, DataItem.DI_GENERAL, fSum, true);
                if (g != gFirst) {
                    double fBackSum = this.getSumSeriesUpToThisGroup(gEnumForwardNew, sBack, g);
                    fCumulSum += fBackSum;
                }
            }
            stackedBar.setStackedCumulativeValue(s, fCumulSum);
            --sBack;
        }
    }

    private boolean isSubtotalPositive(int g, int gFirst) {
        GroupsEnumerator gEnumForwardNew = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        double fCumulativeSum = 0.0;
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            double fSum = 0.0;
            if (g != gFirst) {
                fSum = this.getSumSeriesUpToThisGroup(gEnumForwardNew, s, g);
            }
            fCumulativeSum += fSum;
        }
        boolean bPositive = fCumulativeSum >= 0.0;
        return bPositive;
    }

    private double getEndOfPrevStack(int g, GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        double fEndOfPreviousStack = 0.0;
        int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
        switch (nGroupMode) {
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                fEndOfPreviousStack = this.searchBackForEndOfPrevStack(g, gEnum, sEnum);
            }
        }
        return fEndOfPreviousStack;
    }

    private double searchBackForEndOfPrevStack(int g, GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        double fEndOfPreviousStack = 0.0;
        int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
        int gFirst = gEnum.get(0);
        if (g != gFirst) {
            boolean bStayInLoop;
            int gPrev = g;
            do {
                if (--gPrev == -1) continue;
                int nGroupModePrev = this.m_Perspective.getWaterfallGroupMode(gPrev);
                if (nGroupModePrev == 2) {
                    fEndOfPreviousStack = 0.0;
                    continue;
                }
                nGroupMode = this.m_Perspective.getWaterfallGroupMode(gPrev);
                if (nGroupMode != 0 && nGroupMode != 4) continue;
                WaterfallStackedBar stackedBarPrev = this.getWaterfallStackedBar(gPrev);
                int sLast = sEnum.getLast();
                fEndOfPreviousStack = stackedBarPrev.getStackedCumulativeValue(sLast);
            } while (bStayInLoop = nGroupMode != 4 && nGroupMode != 0 && gPrev != -1);
        }
        return fEndOfPreviousStack;
    }

    private void calcBarRectsAndDataText(boolean bDataTextDisplay) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
            switch (nGroupMode) {
                case 0: 
                case 3: 
                case 4: {
                    DatumObj dObj = this.getDataValue(0, g);
                    double fValue = dObj.value;
                    if (fValue >= 0.0) {
                        this.calcBarRectPositive(g, gEnum, bDataTextDisplay);
                        break;
                    }
                    this.calcBarRectNegative(g, gEnum, bDataTextDisplay);
                    break;
                }
                case 1: 
                case 2: {
                    WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
                    boolean bPositive = stackedBar.getSubtotalPositive();
                    this.calcBarRectSubtotal(g, gEnum, bDataTextDisplay, bPositive);
                }
            }
        }
    }

    private void calcBarRectSubtotal(int g, GroupsEnumerator gEnum, boolean bDataTextDisplay, boolean bPositive) {
        int sLast;
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        double fEndOfPreviousStack = 0.0;
        int nLow = (int)this.m_Y1RelAxisObj.getValueCoord(fEndOfPreviousStack);
        int sBack = sLast = sEnum.get(sEnum.size() - 1);
        double fCumulVal = 0.0;
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            DatumObj dObj = this.getDataValue(s, g);
            double fValue = dObj.value;
            int nHigh = (int)this.m_Y1RelAxisObj.getValueCoord(fCumulVal += fValue);
            int nOrdCoordVC = stackedBar.getOrdCoord();
            int nBarThicknessVC = stackedBar.getBarThickness();
            Rectangle rBarVC = this.createBarRect(this.m_bHorz, nLow, nHigh, nOrdCoordVC, nBarThicknessVC);
            if (bPositive) {
                stackedBar.setBarRect(s, rBarVC.x, rBarVC.y, rBarVC.width, rBarVC.height);
                if (bDataTextDisplay) {
                    this.calcDataTextLabelPositive(stackedBar, s, g);
                }
            } else {
                stackedBar.setBarRect(sBack, rBarVC.x, rBarVC.y, rBarVC.width, rBarVC.height);
                if (bDataTextDisplay) {
                    this.calcDataTextLabelSubtotalNegative(stackedBar, sBack, g, s);
                }
            }
            nLow = nHigh;
            --sBack;
        }
        stackedBar.setDrawStackUp(true);
    }

    private void calcBarRectPositive(int g, GroupsEnumerator gEnum, boolean bDataTextDisplay) {
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        double fEndOfPreviousStack = this.getEndOfPrevStack(g, gEnum, sEnum);
        int nLow = (int)this.m_Y1RelAxisObj.getValueCoord(fEndOfPreviousStack);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            double fNewSum = stackedBar.getStackedCumulativeValue(s);
            int nHigh = (int)this.m_Y1RelAxisObj.getValueCoord(fNewSum);
            int nOrdCoordVC = stackedBar.getOrdCoord();
            int nBarThicknessVC = stackedBar.getBarThickness();
            Rectangle rBarVC = this.createBarRect(this.m_bHorz, nLow, nHigh, nOrdCoordVC, nBarThicknessVC);
            stackedBar.setBarRect(s, rBarVC.x, rBarVC.y, rBarVC.width, rBarVC.height);
            if (bDataTextDisplay) {
                this.calcDataTextLabelPositive(stackedBar, s, g);
            }
            nLow = nHigh;
        }
        stackedBar.setDrawStackUp(true);
    }

    private void calcBarRectNegative(int g, GroupsEnumerator gEnum, boolean bDataTextDisplay) {
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        double fEndOfPreviousStack = this.getEndOfPrevStack(g, gEnum, sEnum);
        int nHigh = (int)this.m_Y1RelAxisObj.getValueCoord(fEndOfPreviousStack);
        int sForward = sEnum.get(0);
        for (int sBack = sEnum.getLast(); sBack != -1; --sBack) {
            assert (sBack >= 0 && sBack < this.m_nTotalSeries);
            double fNewSum = stackedBar.getStackedCumulativeValue(sForward);
            int nLow = (int)this.m_Y1RelAxisObj.getValueCoord(fNewSum);
            int nOrdCoordVC = stackedBar.getOrdCoord();
            int nBarThicknessVC = stackedBar.getBarThickness();
            Rectangle rBarVC = this.createBarRect(this.m_bHorz, nLow, nHigh, nOrdCoordVC, nBarThicknessVC);
            stackedBar.setBarRect(sBack, rBarVC.x, rBarVC.y, rBarVC.width, rBarVC.height);
            if (bDataTextDisplay) {
                this.calcDataTextLabelNegative(stackedBar, sBack, g, sForward);
            }
            nHigh = nLow;
            ++sForward;
        }
        stackedBar.setDrawStackUp(false);
    }

    private void calcDataTextLabelPositive(WaterfallStackedBar stackedBar, int s, int g) {
        double fSum;
        if (this.m_Perspective.getStackedDataValueSum()) {
            fSum = stackedBar.getStackedCumulativeValue(s);
        } else {
            DatumObj dObj = this.getDataValue(s, g);
            fSum = dObj.value;
        }
        String strLabel = this.formatDataTextLabel(s, g, fSum);
        stackedBar.setDataLabel(s, strLabel);
    }

    private void calcDataTextLabelSubtotalNegative(WaterfallStackedBar stackedBar, int sBack, int g, int sForward) {
        if (this.m_Perspective.getStackedDataValueSum()) {
            double fSum = stackedBar.getStackedCumulativeValue(sBack);
            String strLabel = this.formatDataTextLabel(sBack, g, fSum);
            stackedBar.setDataLabel(sForward, strLabel);
        } else {
            DatumObj dObj = this.getDataValue(sBack, g);
            double fBackValue = dObj.value;
            String strLabel = this.formatDataTextLabel(sBack, g, fBackValue);
            stackedBar.setDataLabel(sForward, strLabel);
        }
    }

    private void calcDataTextLabelNegative(WaterfallStackedBar stackedBar, int sBack, int g, int sForward) {
        double fSum;
        if (this.m_Perspective.getStackedDataValueSum()) {
            fSum = stackedBar.getStackedCumulativeValue(sBack);
        } else {
            DatumObj dObj = this.getDataValue(sForward, g);
            fSum = dObj.value;
        }
        String strLabel = this.formatDataTextLabel(sBack, g, fSum);
        stackedBar.setDataLabel(sForward, strLabel);
    }

    private String formatDataTextLabel(int s, int g, double fSum) {
        return this.getY1Axis().getDataTextFormat().format(fSum);
    }

    private Rectangle createBarRect(boolean bHorz, int nLow, int nHigh, int nOrdCoordVC, int nBarThicknessVC) {
        int top;
        int bottom;
        int right;
        int left;
        if (nHigh < nLow) {
            int nTemp = nHigh;
            nHigh = nLow;
            nLow = nTemp;
        }
        if (bHorz) {
            left = nLow;
            right = nHigh;
            bottom = nOrdCoordVC;
            top = bottom + nBarThicknessVC;
        } else {
            bottom = nLow;
            top = nHigh;
            left = nOrdCoordVC;
            right = left + nBarThicknessVC;
        }
        Rectangle rBarVC = new Rectangle(left, bottom, right - left, top - bottom);
        return rBarVC;
    }

    private void drawBarRisersStacked() {
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            this.drawBarGroup(g);
        }
    }

    private void drawBarGroup(int g) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            this.drawBar(s, g);
        }
    }

    private void drawBar(int s, int g) {
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        Rectangle rBarVC = stackedBar.getBarRect(s);
        IBlackBox blackBox = this.assignSeriesColor(s, g);
        if (this.wantDepthEffect() && this.getFrame() != null) {
            this.m_bar2D.drawTwoHalfDBarRiser(s, g, rBarVC, blackBox, this.m_depth2D.getSeriesFrontOffset(s), this.m_depth2D.getSeriesBackOffset(s), this.m_nDepthAngle, this.m_bColorAutoshadeRisers);
        } else {
            IdentObj idFront = new IdentObj(521, s, g);
            boolean bDrawPictograph = false;
            if (this.m_bBarAsPictograph) {
                bDrawPictograph = this.m_bar2D.isSeriesBarPictoGraph(s, this.m_Y1Axis);
            }
            if (bDrawPictograph) {
                this.m_bar2D.drawBarAsPictograph(this.m_Y1Axis, this.m_bHorz, rBarVC, idFront, blackBox, this.m_rClip);
            } else {
                this.m_bar2D.drawBarBasic(idFront, rBarVC, blackBox, this.m_rClip);
            }
        }
    }

    private void drawAllWaterfallLines(boolean bHorz) {
        IdentObj id = Identity.WaterfallLine;
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        double fLineWidth = this.m_Perspective.getLineWidth(id);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int sLast = sEnum.getLast();
        int sFirst = sEnum.get(0);
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            int gPrev = this.getPreviousGroupForWaterfallLines(g);
            int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
            if (nGroupMode == 3 || nGroupMode == 4) continue;
            this.drawOneWaterFallLine(bHorz, sFirst, sLast, g, gPrev, id, bb, fLineWidth);
        }
    }

    private int getPreviousGroupForWaterfallLines(int g) {
        boolean bStayInLoop;
        int gPrev = g;
        int nGroupModePrev = this.m_Perspective.getWaterfallGroupMode(gPrev);
        do {
            if ((nGroupModePrev = this.m_Perspective.getWaterfallGroupMode(--gPrev)) != 2) continue;
            gPrev = -1;
        } while (bStayInLoop = gPrev != -1 && nGroupModePrev != 0 && nGroupModePrev != 4);
        if (gPrev == -1) {
            gPrev = g;
        }
        return gPrev;
    }

    private void drawOneWaterFallLine(boolean bHorz, int sFirst, int sLast, int g, int gPrev, IdentObj id, IBlackBox bb, double fLineWidth) {
        int x2;
        int y2;
        int y1;
        int x1;
        assert (gPrev != -1);
        WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
        WaterfallStackedBar stackedBarPrev = this.getWaterfallStackedBar(gPrev);
        Rectangle rBarPrevLastVC = stackedBarPrev.getBarRect(sLast);
        Rectangle rBarPrevFirstVC = stackedBarPrev.getBarRect(sFirst);
        int nOrdCoord = stackedBar.getOrdCoord();
        int nBarThicknessVC = stackedBar.getBarThickness();
        int nOrdCoordPrev = stackedBarPrev.getOrdCoord();
        if (bHorz) {
            x1 = stackedBarPrev.getDrawStackUp() ? rBarPrevLastVC.x + rBarPrevLastVC.width : rBarPrevFirstVC.x;
            y1 = nOrdCoordPrev + nBarThicknessVC;
            y2 = nOrdCoord;
            x2 = x1;
        } else {
            y1 = stackedBarPrev.getDrawStackUp() ? rBarPrevLastVC.y + rBarPrevLastVC.height : rBarPrevFirstVC.y;
            x1 = nOrdCoordPrev;
            x2 = nOrdCoord + nBarThicknessVC;
            y2 = y1;
            if (this.wantDepthEffect()) {
                Point pt1FrontOffset = this.m_depth2D.getSeriesFrontOffset(sFirst);
                x1 -= pt1FrontOffset.x;
                x2 -= pt1FrontOffset.x;
            }
        }
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        line2D.createLine(id, id, x1, y1, x2, y2, bb, null, fLineWidth);
    }

    private void drawAllDataTextLabels() {
        IdentObj id = Identity.DataText;
        int nTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, id);
        int nDataTextPosition = this.m_Perspective.getDataTextPosition();
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                Rectangle rBarVC;
                Rectangle rLabelVC;
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                WaterfallStackedBar stackedBar = this.getWaterfallStackedBar(g);
                String strLabel = stackedBar.getDataLabel(s);
                if (strLabel == null || (rLabelVC = DataTextPositionWaterfall.calcWaterfallDataValuePosition(nDataTextPosition, rBarVC = stackedBar.getBarRect(s), nTextHeightVC)) == null) continue;
                Rectangle rNewLabelVC = this.patchOneSeriesLabelDoesntFitRiser(id, rLabelVC);
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                DrawFactory.createLabel(this.m_Perspective.getDetectiv(), newID, strLabel, rNewLabelVC, textStyle, blackBox, null);
            }
        }
    }

    Rectangle patchOneSeriesLabelDoesntFitRiser(IdentObj id, Rectangle rLabelVC) {
        int nHeightVC;
        Rectangle rLabelMovedUpVC = new Rectangle(rLabelVC);
        if (this.m_nTotalSeries == 1 && (nHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, id)) > rLabelVC.height) {
            rLabelMovedUpVC.y += nHeightVC;
        }
        return rLabelMovedUpVC;
    }

    public IAxis getAxis(int axisId) {
        if (axisId == 514) {
            return this.getO1Axis();
        }
        return this.getY1Axis();
    }
}

