/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ProportionalChart;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Slice;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

abstract class JChart_2D_Multi
extends JChart_2D
implements ProportionalChart {
    boolean m_bGTMultiple;
    Rectangle m_rSuperFrame;
    public static final int PPR_AUTOMATIC = 0;
    int m_nSubChartsPerRow;
    int m_nGroupLabelHeight;
    Rectangle m_rSubFrame;
    int m_nRows = 1;
    int m_nCols = 1;
    List<Slice> groupDataSlices;

    protected abstract double drawSubChart(int var1);

    protected abstract void processSubRect(Rectangle var1);

    protected abstract IdentObj getGroupLabelID(int var1, int var2);

    protected abstract IdentObj getGroupLabelBoxID(int var1, int var2);

    JChart_2D_Multi(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
        if (this.m_bGTMultiple) {
            this.calcMultiple();
        } else {
            this.calcSingle();
        }
    }

    public void calcMultiple() {
        int nNumSubChartsLeftOver;
        double fSumTotal = 0.0;
        this.m_nCols = this.m_nSubChartsPerRow;
        if (this.m_nCols == 0) {
            this.m_nCols = (int)Math.sqrt(this.m_nGroups);
            if (this.m_rSuperFrame.width < (int)((double)this.m_rSuperFrame.height * 0.2) && this.m_nCols > 1) {
                --this.m_nCols;
            }
            if (this.m_rSuperFrame.width < (int)((double)this.m_rSuperFrame.height * 0.4) && this.m_nCols > 1) {
                --this.m_nCols;
            }
            if (this.m_rSuperFrame.width > (int)((double)this.m_rSuperFrame.height * 1.3)) {
                ++this.m_nCols;
            }
            if (this.m_rSuperFrame.width > (int)((double)this.m_rSuperFrame.height * 2.3)) {
                ++this.m_nCols;
            }
            if (this.m_nCols < 1) {
                this.m_nCols = 1;
            }
        }
        if (this.m_nCols > this.m_nGroups) {
            this.m_nRows = 1;
            this.m_nCols = this.m_nGroups;
            nNumSubChartsLeftOver = 0;
        } else {
            this.m_nRows = (this.m_nGroups - 1) / this.m_nCols + 1;
            nNumSubChartsLeftOver = this.m_nGroups % this.m_nCols;
        }
        this.m_nGroupLabelHeight = this.getLabelHeight(this.m_Perspective);
        int spaceBetweenSubRects = 500;
        int totalTitleHeight = this.m_nRows * this.m_nGroupLabelHeight;
        Rectangle subRect = new Rectangle(this.m_rSuperFrame.x, this.m_rSuperFrame.y, this.m_rSuperFrame.width / this.m_nCols, (this.m_rSuperFrame.height - totalTitleHeight) / this.m_nRows);
        subRect.width -= spaceBetweenSubRects * (this.m_nCols - 1) / this.m_nCols;
        this.processSubRect(subRect);
        int nTopX = this.m_rSuperFrame.x;
        int nTopY = this.m_rSuperFrame.y + this.m_rSuperFrame.height - subRect.height;
        int nCurrentGroup = 0;
        for (int nRowY = 0; nRowY < this.m_nRows; ++nRowY) {
            nTopY -= this.m_nGroupLabelHeight;
            int nCenterLeftOverXOffset = this.m_nGroups < nCurrentGroup + this.m_nCols ? this.m_rSuperFrame.width / 2 - nNumSubChartsLeftOver * subRect.width / 2 : 0;
            for (int nColX = 0; nColX < this.m_nCols; ++nColX) {
                if (nCurrentGroup >= this.m_nGroups) continue;
                subRect.x = nTopX + nColX * subRect.width + nCenterLeftOverXOffset + spaceBetweenSubRects * nColX;
                subRect.y = nTopY - nRowY * subRect.height;
                subRect.y += this.m_nGroupLabelHeight;
                this.m_rSubFrame = new Rectangle(subRect);
                this.calculateSlices(nCurrentGroup);
                if (!this.m_Perspective.getPDECalc()) {
                    fSumTotal += this.drawSubChart(nCurrentGroup);
                }
                ++nCurrentGroup;
            }
        }
    }

    public void calcSingle() {
        this.m_rSubFrame = this.m_rSuperFrame;
        this.m_nGroupLabelHeight = this.getLabelHeight(this.m_Perspective);
        this.processSubRect(this.m_rSubFrame);
        if (this.m_nGroupLabelHeight > 0) {
            this.m_rSubFrame.y += this.m_nGroupLabelHeight;
            this.m_rSubFrame.height -= this.m_nGroupLabelHeight;
        }
        this.calculateSlices(0);
        if (!this.m_Perspective.getPDECalc()) {
            this.drawSubChart(0);
        }
    }

    final void calculateSlices(int groupIndex) {
        double groupTotal = this.getGroupTotal(groupIndex);
        if (groupTotal == 0.0) {
            groupTotal = 1.0;
        }
        int nTotalSeries = this.getDataView().getNumTotalSeries();
        this.groupDataSlices = new ArrayList<Slice>(nTotalSeries);
        for (int nSeries = 0; nSeries < nTotalSeries; ++nSeries) {
            DatumObj dObj = this.getDataValue(nSeries, groupIndex);
            if (!dObj.m_bOK) continue;
            double seriesValue = dObj.value;
            double fPercent = seriesValue / groupTotal;
            this.groupDataSlices.add(new Slice(seriesValue, fPercent, nSeries, groupIndex));
        }
    }

    protected abstract double getGroupTotal(int var1);

    public double getTotal() {
        return this.getGroupTotal(0);
    }

    public int getNPieces() {
        return this.groupDataSlices.size();
    }

    public int getNthPieceSeries(int n) {
        return this.groupDataSlices.get(n).getSeriesID();
    }

    public int getNthPieceGroup(int n) {
        return this.groupDataSlices.get(n).getGroupID();
    }

    public double getNthPieceValue(int n) {
        return this.groupDataSlices.get(n).getValue();
    }

    public double getNthPiecePercent(int n) {
        return this.groupDataSlices.get(n).getPercentage();
    }

    public abstract Format getTextFormat();

    private int getLabelHeight(Perspective p) {
        IdentObj id = this.getGroupLabelID(-3, -3);
        if (!this.m_Perspective.getDisplay(id)) {
            return 0;
        }
        int maxWidth = this.m_bGTMultiple && this.m_nSubChartsPerRow != 0 ? 28800 / this.m_nSubChartsPerRow : 28800;
        Dimension d = PlaceUtilities.getDimLargestLabelVC(p, id, maxWidth);
        return d.height;
    }

    protected void drawGroupLabel(int nGroup, Rectangle rGroupLabel) {
        String strLabel = this.m_Perspective.getGroupLabel(nGroup);
        AnnotationBox.calcBorderedBox(this.m_Perspective, this.getGroupLabelBoxID(-3, nGroup), rGroupLabel, true);
        IdentObj id = this.getGroupLabelID(-3, nGroup);
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        ITextStyle textStyleObj = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        DrawFactory.createLabel(this.m_Perspective.getDetectiv(), id, strLabel, rGroupLabel, textStyleObj, blackBoxLabel, null);
    }
}

