/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.AnnotationType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.MathUtilities;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class AnnotationObj {
    private IdentObj id;
    private Perspective perspective;
    private Rectangle bounds;
    private IBlackBox blackBox;
    private AnnotationType type;
    private static final int SIDE_LEAD = 0;
    private static final int SIDE_TRAIL = 1;
    private static final int SIDE_BOTH = 2;
    private static final int SIDE_NONE = 3;
    private int m_arrowHeadLength;
    private double m_thickness;

    public AnnotationObj(Perspective perspective, IdentObj id, AnnotationType type) {
        this.perspective = perspective;
        this.id = id;
        this.type = type;
    }

    public void calc() {
        this.bounds = this.perspective.getRect(this.id);
        this.blackBox = new BlackBoxObj(this.perspective, this.id);
        this.blackBox.setTransparentBorderColor(this.perspective.getTransparentBorderColor(this.id));
        this.blackBox.setTransparentFillColor(this.perspective.getTransparentFillColor(this.id));
    }

    public void draw() {
        switch (this.type) {
            case TEXT: {
                this.drawTextbox();
                break;
            }
            case RECTANGLE: {
                this.drawRectangle();
                break;
            }
            case LINE: {
                this.drawLine();
                break;
            }
            case ARROWOBJ: {
                this.drawArrow();
                break;
            }
            case POLYGON: {
                this.drawPolygon();
                break;
            }
            case ELLIPSE: {
                this.drawEllipse();
                break;
            }
            case ARC: {
                this.drawArc();
                break;
            }
            case POLYLINE: {
                this.drawPolyline();
                break;
            }
        }
    }

    private void drawTextbox() {
        Rectangle rLabel = this.perspective.getRect(this.id);
        String text = this.perspective.getTextString(this.id);
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.perspective, this.id);
        ITextStyle textStyleObj = TextStyleObjFactory.newTextStyleObj(this.perspective, this.id);
        DrawFactory.createLabel(this.perspective.getDetectiv(), this.id, text, rLabel, textStyleObj, blackBoxLabel, null);
    }

    private void drawRectangle() {
        DrawFactory.createRectangle(this.perspective.getDetectiv(), this.id, this.blackBox, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    private void drawLine() {
        Point p1 = (Point)this.perspective.getAnnotationObject(this.id, 0);
        Point p2 = (Point)this.perspective.getAnnotationObject(this.id, 1);
        Java2DLine line = new Java2DLine(this.perspective);
        line.createLine(this.id, this.id, p1.x, p1.y, p2.x, p2.y, this.blackBox, this.bounds, this.perspective.getLineWidth(this.id));
    }

    private void drawArrow() {
        Point a = (Point)this.perspective.getAnnotationObject(this.id, 0);
        Point b = (Point)this.perspective.getAnnotationObject(this.id, 1);
        double xs = Math.pow(a.x - b.x, 2.0);
        double ys = Math.pow(a.y - b.y, 2.0);
        double theta = MathUtilities.calcAngle(b.x - a.x, b.y - a.y);
        this.m_arrowHeadLength = this.perspective.getArrowHeadLength(this.id);
        this.m_thickness = this.perspective.getLineWidth(this.id);
        this.drawArrow(a.x, a.y, theta, (int)Math.sqrt(xs + ys), 0);
    }

    private void drawPolygon() {
        Polygon polygon = (Polygon)this.perspective.getAnnotationObject(this.id, 0);
        DrawFactory.createPolygon(this.perspective.getDetectiv(), this.id, polygon, this.blackBox, this.bounds);
    }

    private void drawEllipse() {
        DrawFactory.createOval(this.perspective.getDetectiv(), this.id, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.blackBox, this.bounds, this.perspective.getTransparentFillColor(this.id), this.perspective.getLineWidth(this.id));
    }

    private void drawArc() {
    }

    private void drawPolyline() {
        int numPoints = this.perspective.getNumAnnotationObjects(this.id);
        Point p1 = (Point)this.perspective.getAnnotationObject(this.id, 0);
        Java2DLine line = new Java2DLine(this.perspective);
        for (int i = 1; i < numPoints; ++i) {
            Point p2 = (Point)this.perspective.getAnnotationObject(this.id, i);
            line.createLine(this.id, this.id, p1.x, p1.y, p2.x, p2.y, this.blackBox, this.bounds, this.perspective.getLineWidth(this.id));
            p1 = p2;
        }
    }

    public void drawArrow(int x, int y, double theta, int length, int side) {
        if (length < 0) {
            theta += Math.PI;
            length *= -1;
        }
        int x1 = (int)Math.ceil((double)x + (double)length * Math.cos(theta));
        int y1 = (int)Math.ceil((double)y + (double)length * Math.sin(theta));
        Java2DLine line = new Java2DLine(this.perspective);
        line.createLine(this.id, this.id, x, y, x1, y1, this.blackBox, this.bounds, this.m_thickness);
        switch (side) {
            case 0: {
                this.drawArrow(x1, y1, theta + 3.9269908169872414, this.m_arrowHeadLength, 3);
                this.drawArrow(x1, y1, theta + 2.356194490192345, this.m_arrowHeadLength, 3);
                break;
            }
            case 1: {
                this.drawArrow(x, y, theta - 0.7853981633974483, this.m_arrowHeadLength, 3);
                this.drawArrow(x, y, theta + 0.7853981633974483, this.m_arrowHeadLength, 3);
                break;
            }
            case 2: {
                this.drawArrow(x, y, theta - 0.7853981633974483, this.m_arrowHeadLength, 3);
                this.drawArrow(x, y, theta + 0.7853981633974483, this.m_arrowHeadLength, 3);
                this.drawArrow(x1, y1, theta + 3.9269908169872414, this.m_arrowHeadLength, 3);
                this.drawArrow(x1, y1, theta + 2.356194490192345, this.m_arrowHeadLength, 3);
                break;
            }
        }
    }
}

