/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class RoundRectangleShape
extends RoundRectangle2D {
    public static final int TOP_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    private Insets m_insets = null;
    private Area m_area = null;
    private final RoundRectangle2D.Float m_external = new RoundRectangle2D.Float();
    private RoundRectangle2D.Float m_internal = new RoundRectangle2D.Float();

    public RoundRectangleShape(float x, float y, float w, float h, float arcw, float arch, Insets insets) {
        this.m_external.setRoundRect(x, y, w, h, arcw, arch);
        this.m_insets = insets;
        this.calcInternalRectangle();
    }

    public RoundRectangleShape(Rectangle rect, float arcw, float arch, Insets insets) {
        this(rect.x, rect.y, rect.width, rect.height, arcw, arch, insets);
    }

    private void calcInternalRectangle() {
        if (this.m_insets == null) {
            this.m_internal = this.m_external;
            this.m_area = null;
        } else {
            float x = this.m_external.x + (float)this.m_insets.left;
            float y = this.m_external.y + (float)this.m_insets.top;
            float w = this.m_external.width - (float)(this.m_insets.left + this.m_insets.right);
            float h = this.m_external.height - (float)(this.m_insets.top + this.m_insets.bottom);
            float arcw = this.m_external.arcwidth - (float)Math.min(this.m_insets.left, this.m_insets.right);
            float arch = this.m_external.archeight - (float)Math.min(this.m_insets.top, this.m_insets.bottom);
            if (arcw < 0.0f) {
                arcw = 0.0f;
            }
            if (arch < 0.0f) {
                arch = 0.0f;
            }
            this.m_internal.setRoundRect(x, y, w, h, arcw, arch);
            this.m_area = new Area(this.m_external);
            this.m_area.subtract(new Area(this.m_internal));
        }
    }

    public Area getClip(int nType) {
        int X0 = (int)Math.floor(this.m_external.x);
        int Y0 = (int)Math.floor(this.m_external.y);
        int X2 = (int)Math.ceil((float)X0 + this.m_external.width);
        int Y2 = (int)Math.ceil((float)Y0 + this.m_external.height);
        int X1 = X2;
        int Y1 = Y0;
        int X3 = X0;
        int Y3 = Y2;
        int x0 = (int)Math.floor(this.m_internal.x);
        int y0 = (int)Math.floor(this.m_internal.y);
        int x2 = (int)Math.ceil((float)x0 + this.m_internal.width);
        int y2 = (int)Math.ceil((float)y0 + this.m_internal.height);
        int x1 = x2;
        int y1 = y0;
        int x3 = x0;
        int y3 = y2;
        Polygon polygon = new Polygon();
        switch (nType) {
            case 0: {
                polygon.addPoint(X0, Y0);
                polygon.addPoint(X1, Y1);
                polygon.addPoint(x1, y1);
                polygon.addPoint(x3, y3);
                polygon.addPoint(X3, Y3);
                break;
            }
            case 1: {
                polygon.addPoint(X2, Y2);
                polygon.addPoint(X3, Y3);
                polygon.addPoint(x3, y3);
                polygon.addPoint(x1, y1);
                polygon.addPoint(X1, Y1);
                break;
            }
            case 2: {
                polygon.addPoint(X1, Y1);
                polygon.addPoint(X2, Y2);
                polygon.addPoint(x2, y2);
                polygon.addPoint(x0, y0);
                polygon.addPoint(X0, Y0);
                break;
            }
            case 3: {
                polygon.addPoint(X3, Y3);
                polygon.addPoint(X0, Y0);
                polygon.addPoint(x0, y0);
                polygon.addPoint(x2, y2);
                polygon.addPoint(X2, Y2);
            }
        }
        Area clippedArea = new Area(this.m_area);
        clippedArea.intersect(new Area(polygon));
        return clippedArea;
    }

    public double getX() {
        return this.m_external.getX();
    }

    public double getY() {
        return this.m_external.getY();
    }

    public double getWidth() {
        return this.m_external.getWidth();
    }

    public double getHeight() {
        return this.m_external.getHeight();
    }

    public double getArcWidth() {
        return this.m_external.getArcWidth();
    }

    public double getArcHeight() {
        return this.m_external.getArcHeight();
    }

    public boolean isEmpty() {
        return this.m_external.isEmpty();
    }

    public void setRoundRect(float x, float y, float w, float h, float arcw, float arch) {
        this.m_external.setRoundRect(x, y, w, h, arcw, arch);
        this.calcInternalRectangle();
    }

    public void setRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.m_external.setRoundRect(x, y, w, h, arcw, arch);
        this.calcInternalRectangle();
    }

    public void setRoundRect(RoundRectangleShape rr) {
        this.m_external.setRoundRect(rr.m_external);
        this.m_internal.setRoundRect(rr.m_internal);
        this.m_area = new Area(rr.m_area);
    }

    public Rectangle2D getBounds2D() {
        return this.m_external.getBounds2D();
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    public boolean contains(double x, double y) {
        if (this.m_area == null) {
            return false;
        }
        return this.m_area.contains(x, y);
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.m_area == null || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double rrx0 = this.getX();
        double rry0 = this.getY();
        double rrx1 = rrx0 + this.getWidth();
        double rry1 = rry0 + this.getHeight();
        if (x + w <= rrx0 || x >= rrx1 || y + h <= rry0 || y >= rry1) {
            return false;
        }
        return this.m_area.intersects(x, y, w, h);
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.m_area == null || w <= 0.0 || h <= 0.0) {
            return false;
        }
        return this.m_area.contains(x, y);
    }
}

