/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import org.apache.log4j.Logger;

public abstract class FillObj {
    private static final Logger LOG = Logger.getLogger((String)"FillObj");
    public static final int FILL_COLOR = 1;
    public static final int FILL_GRADIENT = 2;
    public static final int FILL_TEXTURE = 3;
    protected double internalBorderThickness = 0.0;

    public void fillOval(Graphics2D g, Rectangle r) {
        this.fillOval(g, r.x, r.y, r.width, r.height);
    }

    public void fillPolygon(Graphics2D g, Polygon p) {
        this.fillPolygon(g, p.xpoints, p.ypoints, p.npoints);
    }

    public void fillArc(Graphics2D g, Arc2D arc2D) {
        g.fill(arc2D);
    }

    public void fillRect(Graphics2D g, Rectangle r) {
        this.fillRect(g, r.x, r.y, r.width, r.height);
    }

    protected int[] extractPixels(Image img, Rectangle r) {
        int[] pixels = new int[r.width * r.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, r.width, r.height, pixels, 0, r.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"extractPixels was interrupted waiting for pixels!");
            return null;
        }
        catch (Throwable e) {
            LOG.error((Object)"FillObj.extractPixels: unexpected error grabbing pixels: ", e);
            return null;
        }
        if ((pg.status() & 0x80) != 0) {
            LOG.warn((Object)"image fetch aborted or errored");
            return null;
        }
        return pixels;
    }

    protected void applyFilter(Shape polyClip, Graphics2D g, Image img, Image imgMask, Rectangle rFill, Rectangle rBounds, ITextStyle textStyle) {
        int[] pixels = this.extractPixels(img, rFill);
        int[] pixelsMask = this.extractPixels(imgMask, rFill);
        BufferedImage dest = new BufferedImage(rFill.width, rFill.height, 6);
        for (int y = 0; y < rFill.height; ++y) {
            for (int x = 0; x < rFill.width; ++x) {
                int idx = y * rFill.width + x;
                dest.setRGB(x, y, pixels[idx] & 0xFFFFFF | pixelsMask[idx] & 0xFF000000 & pixels[idx]);
            }
        }
        imgMask.flush();
        Point pt = new Point(rBounds.x, rBounds.y);
        if (polyClip != null) {
            Shape clip = g.getClip();
            g.setClip(polyClip);
            g.drawImage((Image)dest, pt.x, pt.y, null);
            g.setClip(clip);
        } else {
            g.drawImage((Image)dest, pt.x, pt.y, null);
        }
        dest.flush();
    }

    protected double getRadians(double dAngle) {
        return dAngle * (Math.PI / 180);
    }

    public int getGradientDirection() {
        return 1;
    }

    public abstract void copy(FillObj var1);

    public void setInternalFillBorder(double thickness) {
        this.internalBorderThickness = thickness;
    }

    public void setIntensity(double intensity) {
    }

    public double getIntensity() {
        return 1.0;
    }

    public abstract void fillOval(Graphics2D var1, int var2, int var3, int var4, int var5);

    public abstract void fillPolygon(Graphics2D var1, int[] var2, int[] var3, int var4);

    public abstract void fillRect(Graphics2D var1, int var2, int var3, int var4, int var5);

    public abstract void fillShape(Graphics2D var1, Shape var2);
}

