/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;

public class BorderObj {
    private static final int DOTTED_SIZE = 2;
    private Color color;
    private Stroke penStroke;
    private Stroke origStroke = null;
    private boolean m_antiAlias = true;
    private boolean m_suppressAntiAliasingOnVerticalAndHorizontalLines = false;
    private Object m_oldAntiAliasValue;

    public BorderObj() {
        this(Color.BLACK);
    }

    public BorderObj(Color c) {
        this.color = c;
        this.penStroke = new BasicStroke(1.0f, 1, 1);
    }

    public BorderObj(Perspective p, IdentObj id) {
        this.color = p.getBorderColor(id);
        this.penStroke = Java2DLine.getPenStroke(p, id, p.getLineWidth(id));
    }

    public Color getColor() {
        return this.color;
    }

    public void paintLine(Graphics2D g, Point a, Point b) {
        this.m_antiAlias = !this.m_suppressAntiAliasingOnVerticalAndHorizontalLines || a.x != b.x && a.y != b.y;
        this.preDraw(g);
        g.drawLine(a.x, a.y, b.x, b.y);
        this.postDraw(g);
    }

    public void paintLine(Graphics2D g, Point pt1, Point pt2, Stroke penStroke) {
        this.penStroke = penStroke;
        this.m_antiAlias = !this.m_suppressAntiAliasingOnVerticalAndHorizontalLines || pt1.x != pt2.x && pt1.y != pt2.y;
        this.preDraw(g);
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
        this.postDraw(g);
    }

    public void paint(Graphics2D g2, Polygon p) {
        Stroke saveStroke = g2.getStroke();
        BasicStroke strokeRounded = new BasicStroke(1.0f, 1, 1);
        g2.setStroke(strokeRounded);
        this.m_antiAlias = true;
        this.preDraw(g2);
        g2.drawPolygon(p.xpoints, p.ypoints, p.npoints);
        this.postDraw(g2);
        g2.setStroke(saveStroke);
    }

    public void paint(Graphics2D g, Rectangle r) {
        this.m_antiAlias = !this.m_suppressAntiAliasingOnVerticalAndHorizontalLines;
        this.preDraw(g);
        g.drawRect(r.x, r.y, r.width, r.height);
        this.postDraw(g);
    }

    public void paintNoAntialias(Graphics2D g, Rectangle r) {
        this.preDraw(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawRect(r.x, r.y, r.width, r.height);
        this.postDraw(g);
    }

    public void paint(Graphics2D g2D, Arc2D arc2D) {
        this.m_antiAlias = true;
        this.preDraw(g2D);
        g2D.draw(arc2D);
        this.postDraw(g2D);
    }

    public void paint(Graphics2D g, Rectangle r, boolean bDotted) {
        int nY;
        int nX;
        g.setColor(this.color);
        int nXRight = r.x + r.width - 2;
        for (nX = r.x; nX <= nXRight; nX += 4) {
            g.drawLine(nX, r.y, nX + 2, r.y);
        }
        for (nX = r.x; nX <= nXRight; nX += 4) {
            g.drawLine(nX, r.y + r.height, nX + 2, r.y + r.height);
        }
        int nYBot = r.y + r.height - 2;
        for (nY = r.y; nY <= nYBot; nY += 4) {
            g.drawLine(r.x, nY, r.x, nY + 2);
        }
        nYBot = r.y + r.height - 2;
        for (nY = r.y; nY <= nYBot; nY += 4) {
            g.drawLine(r.x + r.width, nY, r.x + r.width, nY + 2);
        }
        g.drawLine(r.x, r.y, r.x + 1, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + 1, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y + r.height, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width, r.y + r.height - 1, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width, r.y);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + 1);
    }

    void paintOval(Graphics2D g, Rectangle r) {
        this.m_antiAlias = true;
        this.preDraw(g);
        g.drawOval(r.x, r.y, r.width, r.height);
        this.postDraw(g);
    }

    public void paintShape(Graphics2D g2, Shape shapeDC) {
        this.m_antiAlias = true;
        this.preDraw(g2);
        g2.draw(shapeDC);
        this.postDraw(g2);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private void preDraw(Graphics2D g2) {
        g2.setColor(this.color);
        this.origStroke = g2.getStroke();
        g2.setStroke(this.penStroke);
        this.m_oldAntiAliasValue = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.m_antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void postDraw(Graphics2D g2) {
        g2.setStroke(this.origStroke);
        if (this.m_oldAntiAliasValue == null) {
            g2.getRenderingHints().remove(RenderingHints.KEY_ANTIALIASING);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.m_oldAntiAliasValue);
        }
    }

    public Stroke getPenStroke() {
        return this.penStroke;
    }

    public void suppressAntiAliasingOnHorizontalAndVerticalLines(boolean val) {
        this.m_suppressAntiAliasingOnVerticalAndHorizontalLines = val;
    }
}

