/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class ClassInstanceComparer {
    protected boolean showAll;
    Map<Object, String> visitedObjects1 = new HashMap<Object, String>();
    Map visitedObjects2 = new HashMap();

    ClassInstanceComparer() {
    }

    public void diff(String name, Object object1, Object object2) throws Exception {
        if (this.comparedBaseClasses(name, object1, object2)) {
            return;
        }
        Class<?> class1 = object1.getClass();
        Class<?> class2 = object2.getClass();
        Field[] fields1 = class1.getDeclaredFields();
        Field[] fields2 = class2.getDeclaredFields();
        for (int i = 0; i < fields1.length; ++i) {
            fields1[i].setAccessible(true);
            fields2[i].setAccessible(true);
            Object fieldObject1 = fields1[i].get(object1);
            Object fieldObject2 = fields2[i].get(object2);
            String newName = name + "." + fields1[i].getName();
            if (this.filter(fields1[i])) continue;
            this.diff(newName, fieldObject1, fieldObject2);
        }
    }

    private boolean filter(Field field) {
        int modifiers = field.getDeclaringClass().getModifiers();
        return Modifier.isFinal(modifiers);
    }

    private boolean compareArray(String name, Object object1, Object object2) throws Exception {
        if (object1.getClass().isArray()) {
            int len = Array.getLength(object1);
            for (int i = 0; i < len; ++i) {
                Object innerObject1 = Array.get(object1, i);
                Object innerObject2 = Array.get(object2, i);
                this.diff(name + "[" + i + "]", innerObject1, innerObject2);
            }
            return true;
        }
        return false;
    }

    private boolean comparedBaseClasses(String name, Object object1, Object object2) throws Exception {
        if (this.compareNulls(name, object1, object2)) {
            return true;
        }
        if (this.comparePrimatives(name, object1, object2)) {
            return true;
        }
        if (this.compareArray(name, object1, object2)) {
            return true;
        }
        if (this.visitedObjects1.containsKey(object1)) {
            String obj = this.visitedObjects1.get(object1);
            if (obj != null) {
                if (this.showAll) {
                    this.print(name, this.visitedObjects1.get(object1), object1);
                }
                return true;
            }
        } else {
            this.visitedObjects1.put(object1, name);
        }
        return this.compareUserDefined(name, object1, object2);
    }

    protected boolean compareUserDefined(String name, Object object1, Object object2) throws Exception {
        return true;
    }

    private boolean compareNulls(String name, Object object1, Object object2) {
        if (object1 == null & object2 == null) {
            return true;
        }
        if (object1 == null & object2 != null) {
            this.print(name, null, object2);
            return true;
        }
        if (object1 != null & object2 == null) {
            this.print(name, object1, null);
            return true;
        }
        return false;
    }

    private boolean comparePrimatives(String name, Object object1, Object object2) {
        if (object1 instanceof Integer) {
            Integer a1 = (Integer)object1;
            Integer a2 = (Integer)object2;
            if (a1.intValue() != a2.intValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Boolean) {
            Boolean a1 = (Boolean)object1;
            Boolean a2 = (Boolean)object2;
            if (a1.booleanValue() != a2.booleanValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Short) {
            Short a1 = (Short)object1;
            Short a2 = (Short)object2;
            if (a1.shortValue() != a2.shortValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Character) {
            Character a1 = (Character)object1;
            Character a2 = (Character)object2;
            if (a1.charValue() != a2.charValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Byte) {
            Byte a1 = (Byte)object1;
            Byte a2 = (Byte)object2;
            if (a1.byteValue() != a2.byteValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Long) {
            Long a1 = (Long)object1;
            Long a2 = (Long)object2;
            if (a1.longValue() != a2.longValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Float) {
            Float a1 = (Float)object1;
            Float a2 = (Float)object2;
            if (a1.floatValue() != a2.floatValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        if (object1 instanceof Double) {
            Double a1 = (Double)object1;
            Double a2 = (Double)object2;
            if (a1.doubleValue() != a2.doubleValue()) {
                this.print(name, a1, a2);
            } else if (this.showAll) {
                this.print(name, a1, a2);
            }
            return true;
        }
        return false;
    }

    public void setShowAll(boolean b) {
        this.showAll = b;
    }

    protected void print(String name, Object obj1, Object obj2) {
        System.out.println(name + " = " + obj1 + " <---> " + obj2);
    }
}

