/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphConverter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class PFJChartType {
    public MajorType majorType = MajorType.Unknown;
    public MinorType minorType = MinorType.Unknown;
    public RiserType riserType = RiserType.Unknown;
    public int numYAxis = 1;
    public boolean isNumericAxis = false;
    public boolean isDateAxis = false;
    public boolean isBiPolar = false;
    public boolean isVertical = false;
    public boolean isProportional = false;
    public boolean isMultiPie = false;
    static final String XY_TYPE = "xy";
    static final String BAR_TYPE = "bar";
    static final String COMBINED_TYPE = "combined_bar_line";
    static final String LINE_TYPE = "line";
    static final String SURFACE_TYPE = "surface";
    static final String RADARSURFACE_TYPE = "radar_surface";
    static final String RADARLINE_TYPE = "radar_line";
    static final String PIE_TYPE = "pie";
    static final String DONUT_TYPE = "donut";
    static final String STOCK_TYPE_HL = "stock_hl";
    static final String STOCK_TYPE_HLO = "stock_hlo";
    static final String STOCK_TYPE_HLC = "stock_hlc";
    static final String STOCK_TYPE_HLOC = "stock_hloc";
    static final String THREED_TYPE = "3dbar";
    static final String THREEDSURFACE_TYPE = "3dsurface";
    static final String BUBBLE_TYPE = "bubble";
    static final String SCATTER_TYPE = "scatter";
    static final String FUNNEL_TYPE = "funnel";
    static final String GAUGE_TYPE = "gauge";
    static final String HISTOGRAM_TYPE = "histogram";
    static final String WATERFALL_TYPE = "waterfall";
    static final String GANTT_TYPE = "gantt_start_end";
    static final String NUMERICX_BAR = "numeric_x_bar";
    static final String NUMERICX_LINE = "numeric_x_line";
    static final String NUMERICX_SURFACE = "numeric_x_surface";
    static Map<String, MajorType> majorMap = new HashMap<String, MajorType>();

    private String getGrapicID(CVOMHelper cvom) {
        String graphicID = cvom.context.getPublicGraphicId();
        graphicID = graphicID.replace("pfjlite/", "");
        graphicID = graphicID.replace("pfjgraphics/", "");
        return graphicID;
    }

    private PFJChartType() {
    }

    public static PFJChartType create(CVOMHelper cvom) {
        PFJChartType chartType = new PFJChartType();
        chartType.inhaleCVOMChartTypeSettings(cvom);
        return chartType;
    }

    public static PFJChartType create(GraphConverter.PerspectiveSummary perspectiveSummary) {
        PFJChartType chartType = new PFJChartType();
        chartType.inhalePFJChartTypeSettings(perspectiveSummary.jChartType, perspectiveSummary.isNumericAxis, perspectiveSummary.isDateTimeAxis);
        return chartType;
    }

    public static PFJChartType create(Perspective pfj) {
        PFJChartType chartType = new PFJChartType();
        chartType.inhalePFJChartTypeSettings(pfj.getGraphType(), pfj.getUseNumericScaleAxis(), pfj.getUsePGSDKTimeScaleAxis() || pfj.getUseTimeScaleAxis());
        return chartType;
    }

    private void inhaleCVOMChartTypeSettings(CVOMHelper cvom) {
        String graphicID = this.getGrapicID(cvom);
        this.isNumericAxis = NUMERICX_BAR.equals(graphicID) || NUMERICX_LINE.equals(graphicID) || NUMERICX_SURFACE.equals(graphicID);
        this.majorType = majorMap.get(graphicID);
        if (this.isNumericAxis) {
            this.minorType = this.majorType == MajorType.Bar ? MinorType.SideBySide : MinorType.Absolute;
        } else if (this.isStacked(cvom, "stacked/100%")) {
            this.minorType = MinorType.Percent;
        } else if (this.isStacked(cvom, "stacked")) {
            this.minorType = MinorType.Stacked;
        } else if (this.majorType == MajorType.Bar) {
            this.minorType = MinorType.SideBySide;
        } else if (this.majorType == MajorType.Area || this.majorType == MajorType.Line || this.majorType == MajorType.Radar) {
            this.minorType = MinorType.Absolute;
        } else if (STOCK_TYPE_HL.equals(graphicID)) {
            this.minorType = MinorType.HiLo;
        } else if (STOCK_TYPE_HLC.equals(graphicID)) {
            this.minorType = MinorType.HiLoClose;
        } else if (STOCK_TYPE_HLO.equals(graphicID)) {
            this.minorType = MinorType.HiLoOpen;
        } else if (STOCK_TYPE_HLOC.equals(graphicID)) {
            this.minorType = MinorType.HiLoOpenClose;
        }
        switch (this.majorType) {
            case Bar: {
                this.riserType = RiserType.Bar;
                break;
            }
            case Line: {
                this.riserType = RiserType.Line;
                break;
            }
            case Area: {
                this.riserType = RiserType.Area;
                break;
            }
            case Stock: {
                this.riserType = RiserType.Bar;
                break;
            }
            case Radar: {
                if (RADARSURFACE_TYPE.equals(graphicID)) {
                    this.riserType = RiserType.Area;
                    break;
                }
                this.riserType = RiserType.Line;
                break;
            }
            case ThreeD: {
                String riser = ((VisuState)cvom.getProperty("root", "risershape")).getId();
                if (riser.equals(BAR_TYPE)) {
                    this.riserType = RiserType.ThreeDBar;
                    break;
                }
                if (riser.equals("pyramid")) {
                    this.riserType = RiserType.ThreeDPyramid;
                    break;
                }
                if (riser.equals("octagon")) {
                    this.riserType = RiserType.ThreeDOctigon;
                    break;
                }
                if (riser.equals("cutcorners")) {
                    this.riserType = RiserType.ThreeDCutCorners;
                    break;
                }
                if (riser.equals("cube")) {
                    this.riserType = RiserType.ThreeDCube;
                    break;
                }
                if (riser.equals("diamond")) {
                    this.riserType = RiserType.ThreeDDiamond;
                    break;
                }
                if (riser.equals("sphere")) {
                    this.riserType = RiserType.ThreeDSphere;
                    break;
                }
                if (riser.equals(SURFACE_TYPE)) {
                    this.riserType = RiserType.ThreeDSurface;
                    break;
                }
                if (riser.equals("surfacewithsides")) {
                    this.riserType = RiserType.ThreeDSurfaceWithSides;
                    break;
                }
                if (!riser.equals("surfacehoneycomb")) break;
                this.riserType = RiserType.ThreeDSurfaceHoneyComb;
            }
        }
        this.numYAxis = this.hasDualY(cvom) ? 2 : 1;
        this.isDateAxis = this.isDateTimeChart(cvom, graphicID);
        this.isBiPolar = this.isBipolar(cvom);
        this.isVertical = this.isVertical(cvom);
        this.isProportional = this.isProportional(cvom);
        this.isMultiPie = this.isMultiPie(cvom);
    }

    private boolean isDateTimeChart(CVOMHelper cvom, String graphicID) {
        if (GANTT_TYPE.equals(graphicID)) {
            return true;
        }
        return ((VisuBool)cvom.getProperty("root", "usepgsdktimescaleaxis")).booleanValue();
    }

    private void inhalePFJChartTypeSettings(int graphType, boolean isNumeric, boolean isDateTime) {
        JGraphType jGraphType = JGraphType.getJGraphType(graphType);
        this.majorType = jGraphType.isHistogram() ? MajorType.Histogram : (jGraphType.isGaugeType() ? MajorType.Gauge : (jGraphType.isGanttType() ? MajorType.Gantt : (jGraphType.isFunnelType() ? MajorType.Funnel : (jGraphType.isRadarType() ? MajorType.Radar : (jGraphType.isBubble() ? MajorType.Bubble : (jGraphType.is3DType() ? MajorType.ThreeD : (jGraphType.isStockType() ? MajorType.Stock : (jGraphType.isRegularPieType() ? MajorType.Pie : (jGraphType.isDoughnutType() ? MajorType.Doughnut : (jGraphType.isBarType() ? MajorType.Bar : (jGraphType.isLineType() ? MajorType.Line : (jGraphType.isAreaType() ? MajorType.Area : (jGraphType.isScatter() ? MajorType.Scatter : MajorType.Unknown)))))))))))));
        this.isNumericAxis = isNumeric;
        this.isDateAxis = isDateTime;
        this.isBiPolar = jGraphType.isBipolar();
        this.isProportional = jGraphType.isPieProportional();
        this.isMultiPie = jGraphType.isMultiPieType();
        boolean bl = this.isVertical = jGraphType.getOrientation() == 2;
        this.numYAxis = jGraphType.isDualY() ? 2 : (jGraphType.isThreeY() ? 3 : (jGraphType.isFourY() ? 4 : (jGraphType.isFiveY() ? 5 : 1)));
        this.minorType = jGraphType.isHiLo() ? MinorType.HiLo : (jGraphType.isHiLoOpenClose() ? MinorType.HiLoOpenClose : (jGraphType.isHiLoOpen() ? MinorType.HiLoOpen : (jGraphType.isHiLoClose() ? MinorType.HiLoClose : (jGraphType.isScalingStacked() ? MinorType.Stacked : (jGraphType.isScalingAbs() && this.majorType == MajorType.Bar ? MinorType.SideBySide : (jGraphType.isScalingAbs() ? MinorType.Absolute : (jGraphType.isScalingPercent() ? MinorType.Percent : MinorType.Unknown)))))));
        this.riserType = jGraphType.getIntegerGraphType() == 0 ? RiserType.ThreeDBar : (jGraphType.getIntegerGraphType() == 2 ? RiserType.ThreeDOctigon : (jGraphType.getIntegerGraphType() == 131 ? RiserType.ThreeDCutCorners : (jGraphType.getIntegerGraphType() == 1 ? RiserType.ThreeDPyramid : (jGraphType.getIntegerGraphType() == 4 ? RiserType.ThreeDCube : (jGraphType.getIntegerGraphType() == 5 ? RiserType.ThreeDDiamond : (jGraphType.getIntegerGraphType() == 11 ? RiserType.ThreeDSphere : (jGraphType.getIntegerGraphType() == 12 ? RiserType.ThreeDSurface : (jGraphType.getIntegerGraphType() == 14 ? RiserType.ThreeDSurfaceHoneyComb : (jGraphType.getIntegerGraphType() == 13 ? RiserType.ThreeDSurfaceWithSides : (this.majorType == MajorType.Bar ? RiserType.Bar : (this.majorType == MajorType.Line ? RiserType.Line : (this.majorType == MajorType.Area ? RiserType.Area : (jGraphType.getIntegerGraphType() == 68 || jGraphType.getIntegerGraphType() == 127 ? RiserType.Area : (jGraphType.getIntegerGraphType() == 67 || jGraphType.getIntegerGraphType() == 126 ? RiserType.Line : (this.majorType == MajorType.Stock ? (jGraphType.isStockCandleType() ? RiserType.CandleStick : RiserType.Bar) : RiserType.Unknown)))))))))))))));
    }

    public void exhaleCVOMChartTypeSettings(CVOMHelper cvom) {
        if (!this.isNumericAxis) {
            switch (this.minorType) {
                case Stacked: {
                    this.setStacking(cvom, "stacked");
                    break;
                }
                case Percent: {
                    this.setStacking(cvom, "stacked/100%");
                }
            }
        }
        String riserID = null;
        switch (this.riserType) {
            case ThreeDBar: {
                riserID = BAR_TYPE;
                break;
            }
            case ThreeDPyramid: {
                riserID = "pyramid";
                break;
            }
            case ThreeDOctigon: {
                riserID = "octagon";
                break;
            }
            case ThreeDCutCorners: {
                riserID = "cutcorners";
                break;
            }
            case ThreeDCube: {
                riserID = "cube";
                break;
            }
            case ThreeDDiamond: {
                riserID = "diamond";
                break;
            }
            case ThreeDSphere: {
                riserID = "sphere";
                break;
            }
            case ThreeDSurface: {
                riserID = SURFACE_TYPE;
                break;
            }
            case ThreeDSurfaceWithSides: {
                riserID = "surfacewithsides";
                break;
            }
            case ThreeDSurfaceHoneyComb: {
                riserID = "surfacehoneycomb";
            }
        }
        if (riserID != null) {
            cvom.setProperty("root", "risershape", (VisuObject)new VisuState(riserID));
        }
        if (!this.isVertical) {
            cvom.setProperty("root", "horizontalOrientation", (VisuObject)VisuBool.TRUE);
        }
        if (this.isProportional) {
            cvom.setProperty("root", "proportional", (VisuObject)VisuBool.TRUE);
        }
        if (this.majorType == MajorType.Pie || this.majorType == MajorType.Doughnut) {
            cvom.setProperty("root", "ismulti", (VisuObject)VisuBool.getVisuBool((boolean)this.isMultiPie));
        }
        this.exhaleBipolar(cvom);
        this.exhaleDualY(cvom);
        this.exhaleIsDateAxis(cvom);
    }

    public void exhalePFJChartTypeSettings(Perspective pfj) {
        pfj.setUseNumericScaleAxis(this.isNumericAxis);
        pfj.setUsePGSDKTimeScaleAxis(this.isDateAxis);
        block0 : switch (this.majorType) {
            case Bar: {
                if (this.minorType == MinorType.SideBySide) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(21);
                            break;
                        }
                        if (this.numYAxis == 2) {
                            pfj.setGraphType(19);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(17);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(28);
                        break;
                    }
                    if (this.numYAxis == 2) {
                        pfj.setGraphType(26);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(24);
                    break;
                }
                if (this.minorType == MinorType.Stacked) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(22);
                            break;
                        }
                        if (this.numYAxis == 2) {
                            pfj.setGraphType(20);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(18);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(29);
                        break;
                    }
                    if (this.numYAxis == 2) {
                        pfj.setGraphType(27);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(25);
                    break;
                }
                if (this.minorType == MinorType.Percent) {
                    if (this.isVertical) {
                        pfj.setGraphType(23);
                        break;
                    }
                    pfj.setGraphType(30);
                    break;
                }
                assert (false) : "Bar subtype not recongized.";
                break;
            }
            case Line: {
                if (this.minorType == MinorType.Absolute) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(45);
                            break;
                        }
                        if (this.numYAxis == 2) {
                            pfj.setGraphType(43);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(41);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(52);
                        break;
                    }
                    if (this.numYAxis == 2) {
                        pfj.setGraphType(50);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(48);
                    break;
                }
                if (this.minorType == MinorType.Stacked) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(46);
                            break;
                        }
                        if (this.numYAxis == 2) {
                            pfj.setGraphType(44);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(42);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(53);
                        break;
                    }
                    if (this.numYAxis == 2) {
                        pfj.setGraphType(51);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(49);
                    break;
                }
                if (this.minorType == MinorType.Percent) {
                    if (this.isVertical) {
                        pfj.setGraphType(47);
                        break;
                    }
                    pfj.setGraphType(54);
                    break;
                }
                assert (false) : "Line subtype not recongized.";
                break;
            }
            case Area: {
                if (this.minorType == MinorType.Absolute) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(33);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(31);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(38);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(36);
                    break;
                }
                if (this.minorType == MinorType.Percent) {
                    if (this.isVertical) {
                        pfj.setGraphType(35);
                        break;
                    }
                    pfj.setGraphType(40);
                    break;
                }
                if (this.minorType == MinorType.Stacked) {
                    if (this.isVertical) {
                        if (this.isBiPolar) {
                            pfj.setGraphType(34);
                            break;
                        }
                        if (this.numYAxis != 1) break;
                        pfj.setGraphType(32);
                        break;
                    }
                    if (this.isBiPolar) {
                        pfj.setGraphType(39);
                        break;
                    }
                    if (this.numYAxis != 1) break;
                    pfj.setGraphType(37);
                    break;
                }
                assert (false) : "Area subtype not recongized.";
                break;
            }
            case Radar: {
                if (this.minorType == MinorType.Stacked) {
                    if (this.riserType == RiserType.Area) {
                        pfj.setGraphType(127);
                        break;
                    }
                    if (this.riserType == RiserType.Line) {
                        pfj.setGraphType(126);
                        break;
                    }
                    assert (false) : "Unknown radar riser type.";
                    break;
                }
                if (this.minorType == MinorType.Absolute) {
                    if (this.riserType == RiserType.Area) {
                        pfj.setGraphType(68);
                        break;
                    }
                    if (this.riserType == RiserType.Line) {
                        pfj.setGraphType(67);
                        break;
                    }
                    assert (false) : "Unknown radar riser type.";
                    break;
                }
                assert (false) : "Unknown radar minor type.";
                break;
            }
            case Bubble: {
                if (this.numYAxis == 2) {
                    pfj.setGraphType(91);
                    break;
                }
                pfj.setGraphType(89);
                break;
            }
            case Doughnut: {
                if (this.isMultiPie) {
                    if (this.isProportional) {
                        pfj.setGraphType(60);
                        break;
                    }
                    pfj.setGraphType(58);
                    break;
                }
                if (this.isProportional) {
                    pfj.setGraphType(60);
                    break;
                }
                pfj.setGraphType(56);
                break;
            }
            case Pie: {
                if (this.isMultiPie) {
                    if (this.isProportional) {
                        pfj.setGraphType(59);
                        break;
                    }
                    pfj.setGraphType(57);
                    break;
                }
                if (this.isProportional) {
                    pfj.setGraphType(59);
                    break;
                }
                pfj.setGraphType(55);
                break;
            }
            case Scatter: {
                if (this.numYAxis == 2) {
                    pfj.setGraphType(62);
                    break;
                }
                pfj.setGraphType(61);
                break;
            }
            case ThreeD: {
                switch (this.riserType) {
                    case ThreeDBar: {
                        pfj.setGraphType(0);
                        break block0;
                    }
                    case ThreeDCutCorners: {
                        pfj.setGraphType(131);
                        break block0;
                    }
                    case ThreeDOctigon: {
                        pfj.setGraphType(2);
                        break block0;
                    }
                    case ThreeDPyramid: {
                        pfj.setGraphType(1);
                        break block0;
                    }
                    case ThreeDCube: {
                        pfj.setGraphType(4);
                        break block0;
                    }
                    case ThreeDDiamond: {
                        pfj.setGraphType(5);
                        break block0;
                    }
                    case ThreeDSphere: {
                        pfj.setGraphType(11);
                        break block0;
                    }
                    case ThreeDSurface: {
                        pfj.setGraphType(12);
                        break block0;
                    }
                    case ThreeDSurfaceHoneyComb: {
                        pfj.setGraphType(14);
                        break block0;
                    }
                    case ThreeDSurfaceWithSides: {
                        pfj.setGraphType(13);
                        break block0;
                    }
                }
                assert (false) : "Unknown 3D riser type.";
                break;
            }
            case Stock: {
                if (this.riserType == RiserType.Bar) {
                    if (this.minorType == MinorType.HiLo) {
                        pfj.setGraphType(73);
                        break;
                    }
                    if (this.minorType == MinorType.HiLoOpenClose) {
                        pfj.setGraphType(79);
                        break;
                    }
                    if (this.minorType == MinorType.HiLoOpen) {
                        pfj.setGraphType(128);
                        break;
                    }
                    if (this.minorType == MinorType.HiLoClose) {
                        pfj.setGraphType(76);
                        break;
                    }
                    assert (false) : "Unknown stock minor type.";
                    break;
                }
                if (this.riserType == RiserType.CandleStick) {
                    pfj.setGraphType(72);
                    break;
                }
                assert (false) : "Unknown stock riser type.";
                break;
            }
            case Funnel: {
                if (this.isVertical) {
                    pfj.setGraphType(106);
                    break;
                }
                assert (false) : "Horizontal funnel charts not supported.";
                break;
            }
            case Gantt: {
                pfj.setGraphType(99);
                break;
            }
            case Gauge: {
                pfj.setGraphType(110);
                break;
            }
            case Histogram: {
                if (this.isVertical) {
                    pfj.setGraphType(85);
                    break;
                }
                pfj.setGraphType(86);
                break;
            }
            case Waterfall: {
                break;
            }
            default: {
                assert (false) : "Unknown chart type.";
                break;
            }
        }
    }

    private boolean isMultiPie(CVOMHelper cvom) {
        return (this.majorType == MajorType.Pie || this.majorType == MajorType.Doughnut) && VisuBool.TRUE.equals((Object)cvom.getProperty("root", "ismulti"));
    }

    private boolean isVertical(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: 
            case Histogram: {
                return VisuBool.FALSE.equals((Object)cvom.getProperty("root", "horizontalOrientation"));
            }
            case Funnel: {
                return true;
            }
        }
        return false;
    }

    private boolean isProportional(CVOMHelper cvom) {
        return (this.majorType == MajorType.Pie || this.majorType == MajorType.Doughnut) && VisuBool.TRUE.equals((Object)cvom.getProperty("root", "proportional"));
    }

    private void exhaleBipolar(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: {
                cvom.setProperty("root", "hasdualy/splitaxes", (VisuObject)VisuBool.getVisuBool((boolean)this.isBiPolar));
            }
        }
    }

    private void exhaleDualY(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: 
            case Bubble: 
            case Scatter: {
                cvom.setProperty("root", "hasdualy", (VisuObject)VisuBool.getVisuBool((this.numYAxis > 1 ? 1 : 0) != 0));
            }
        }
    }

    private void exhaleIsDateAxis(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: {
                cvom.setProperty("root", "usepgsdktimescaleaxis", (VisuObject)VisuBool.getVisuBool((boolean)this.isDateAxis));
            }
        }
    }

    private boolean isBipolar(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: {
                return VisuBool.TRUE.equals((Object)cvom.getProperty("root", "hasdualy/splitaxes"));
            }
        }
        return false;
    }

    private boolean hasDualY(CVOMHelper cvom) {
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: 
            case Bubble: 
            case Scatter: {
                return VisuBool.TRUE.equals((Object)cvom.getProperty("root", "hasdualy"));
            }
        }
        return false;
    }

    private boolean isStacked(CVOMHelper cvom, String stackType) {
        return (this.majorType == MajorType.Bar || this.majorType == MajorType.Line || this.majorType == MajorType.Area || this.majorType == MajorType.Radar) && VisuBool.TRUE.equals((Object)cvom.context.getPropertyValue("root", stackType));
    }

    private void setStacking(CVOMHelper cvom, String stackType) {
        if (this.majorType == MajorType.Bar || this.majorType == MajorType.Line || this.majorType == MajorType.Area || this.majorType == MajorType.Radar) {
            cvom.context.setPropertyValue("root", stackType, (VisuObject)VisuBool.TRUE);
        }
    }

    public boolean isGanttDataType() {
        return this.majorType == MajorType.Gantt;
    }

    public boolean isProportionalDataType() {
        return this.majorType == MajorType.Doughnut || this.majorType == MajorType.Pie || this.majorType == MajorType.Funnel;
    }

    public boolean isStockDataType() {
        return this.majorType == MajorType.Stock;
    }

    public boolean isScatterDataType() {
        return this.majorType == MajorType.Bubble || this.majorType == MajorType.Scatter || this.isNumericAxis || this.isDateAxis;
    }

    public boolean isXYDataType() {
        if (this.isNumericAxis || this.isDateAxis) {
            return false;
        }
        switch (this.majorType) {
            case Bar: 
            case Line: 
            case Area: 
            case Radar: 
            case ThreeD: 
            case Gauge: 
            case Histogram: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultiDataType() {
        if (this.isNumericAxis) {
            return true;
        }
        switch (this.majorType) {
            case Stock: 
            case Bubble: 
            case Scatter: 
            case Gantt: {
                return true;
            }
        }
        return false;
    }

    public URL getDefaultChartURL() {
        String name = "com/businessobjects/visualization/pfjgraphics/rendering/resources/defaultCharts/";
        switch (this.majorType) {
            case Bar: {
                if (this.isNumericAxis) {
                    name = name + "NumericBarChart.3tf";
                    break;
                }
                name = name + "BarChart.3tf";
                break;
            }
            case Line: {
                if (this.isNumericAxis) {
                    name = name + "NumericLineChart.3tf";
                    break;
                }
                name = name + "LineChart.3tf";
                break;
            }
            case Area: {
                if (this.isNumericAxis) {
                    name = name + "NumericAreaChart.3tf";
                    break;
                }
                name = name + "AreaChart.3tf";
                break;
            }
            case Bubble: {
                name = name + "BubbleChart.3tf";
                break;
            }
            case Doughnut: {
                name = name + "DoughnutChart.3tf";
                break;
            }
            case Pie: {
                name = name + "PieChart.3tf";
                break;
            }
            case Radar: {
                name = name + "RadarChart.3tf";
                break;
            }
            case Scatter: {
                name = name + "ScatterChart.3tf";
                break;
            }
            case Stock: {
                name = name + "StockChart.3tf";
                break;
            }
            case ThreeD: {
                if (this.riserType == RiserType.ThreeDBar || this.riserType == RiserType.ThreeDCutCorners || this.riserType == RiserType.ThreeDOctigon || this.riserType == RiserType.ThreeDPyramid) {
                    name = name + "3DBarChart.3tf";
                    break;
                }
                if (this.riserType == RiserType.ThreeDSurface || this.riserType == RiserType.ThreeDSurfaceHoneyComb || this.riserType == RiserType.ThreeDSurfaceWithSides) {
                    name = name + "3DSurfaceChart.3tf";
                    break;
                }
                name = name + "3DBarChart.3tf";
                break;
            }
            case Funnel: {
                name = name + "FunnelChart.3tf";
                break;
            }
            case Gauge: {
                name = name + "GaugeChart.3tf";
                break;
            }
            case Gantt: {
                name = name + "GanttChart.3tf";
                break;
            }
            case Histogram: {
                name = name + "HistogramChart.3tf";
                break;
            }
            default: {
                name = name + "BarChart.3tf";
            }
        }
        URL chartTemplateURL = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            chartTemplateURL = loader.getResource(name);
        }
        return chartTemplateURL;
    }

    static {
        majorMap.put(XY_TYPE, MajorType.Bar);
        majorMap.put(BAR_TYPE, MajorType.Bar);
        majorMap.put(COMBINED_TYPE, MajorType.Bar);
        majorMap.put(LINE_TYPE, MajorType.Line);
        majorMap.put(SURFACE_TYPE, MajorType.Area);
        majorMap.put(RADARSURFACE_TYPE, MajorType.Radar);
        majorMap.put(RADARLINE_TYPE, MajorType.Radar);
        majorMap.put(PIE_TYPE, MajorType.Pie);
        majorMap.put(DONUT_TYPE, MajorType.Doughnut);
        majorMap.put(STOCK_TYPE_HL, MajorType.Stock);
        majorMap.put(STOCK_TYPE_HLC, MajorType.Stock);
        majorMap.put(STOCK_TYPE_HLO, MajorType.Stock);
        majorMap.put(STOCK_TYPE_HLOC, MajorType.Stock);
        majorMap.put(THREED_TYPE, MajorType.ThreeD);
        majorMap.put(THREEDSURFACE_TYPE, MajorType.ThreeD);
        majorMap.put(BUBBLE_TYPE, MajorType.Bubble);
        majorMap.put(SCATTER_TYPE, MajorType.Scatter);
        majorMap.put(FUNNEL_TYPE, MajorType.Funnel);
        majorMap.put(GAUGE_TYPE, MajorType.Gauge);
        majorMap.put(HISTOGRAM_TYPE, MajorType.Histogram);
        majorMap.put(WATERFALL_TYPE, MajorType.Waterfall);
        majorMap.put(GANTT_TYPE, MajorType.Gantt);
        majorMap.put(NUMERICX_BAR, MajorType.Bar);
        majorMap.put(NUMERICX_LINE, MajorType.Line);
        majorMap.put(NUMERICX_SURFACE, MajorType.Area);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisType {
        Unknown,
        Ordinal,
        Numeric,
        DateTime;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MajorType {
        Unknown,
        Bar,
        Line,
        Area,
        Radar,
        Pie,
        Doughnut,
        Stock,
        ThreeD,
        Bubble,
        Scatter,
        Funnel,
        Gauge,
        Histogram,
        Waterfall,
        Gantt;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MinorType {
        Unknown,
        Stacked,
        Absolute,
        Percent,
        SideBySide,
        HiLo,
        HiLoOpenClose,
        HiLoOpen,
        HiLoClose;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RiserType {
        Unknown,
        Bar,
        Line,
        Area,
        ThreeDBar,
        ThreeDPyramid,
        ThreeDOctigon,
        ThreeDCutCorners,
        ThreeDCube,
        ThreeDDiamond,
        ThreeDSphere,
        ThreeDSurface,
        ThreeDSurfaceWithSides,
        ThreeDSurfaceHoneyComb,
        CandleStick;

    }
}

