/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.pietjonas.wmfwriter2d.WMF;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EMFRecorder
extends WMF {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.reports.common.metafile.EMFRecorder");
    private static final boolean debugEvaluation = false;
    static final int LF_FACESIZE = 32;
    static final int GM_COMPATIBLE = 1;
    static final int GM_ADVANCED = 2;
    static final byte HANGEUL_CHARSET = -127;
    static final byte GB2312_CHARSET = -122;
    static final byte CHINESEBIG5_CHARSET = -120;
    static final byte OUT_TT_ONLY_PRECIS = 7;
    static final byte OUT_OUTLINE_PRECIS = 8;
    static final byte OUT_SCREEN_OUTLINE_PRECIS = 9;
    static final byte OUT_PS_ONLY_PRECIS = 10;
    static final int LF_FULLFACESIZE = 64;
    static final int ELF_VENDOR_SIZE = 4;
    static final int PANOSE_SIZE = 10;
    static final int BI_RGB = 0;
    static final int BI_RLE8 = 1;
    static final int BI_RLE4 = 2;
    static final int BI_BITFIELDS = 3;
    static final int BI_JPEG = 4;
    static final int BI_PNG = 5;
    public static final int EMR_HEADER = 1;
    public static final int EMR_POLYBEZIER = 2;
    public static final int EMR_POLYGON = 3;
    public static final int EMR_POLYLINE = 4;
    public static final int EMR_POLYBEZIERTO = 5;
    public static final int EMR_POLYLINETO = 6;
    public static final int EMR_POLYPOLYLINE = 7;
    public static final int EMR_POLYPOLYGON = 8;
    public static final int EMR_SETWINDOWEXTEX = 9;
    public static final int EMR_SETWINDOWORGEX = 10;
    public static final int EMR_SETVIEWPORTEXTEX = 11;
    public static final int EMR_SETVIEWPORTORGEX = 12;
    public static final int EMR_SETBRUSHORGEX = 13;
    public static final int EMR_EOF = 14;
    public static final int EMR_SETPIXELV = 15;
    public static final int EMR_SETMAPPERFLAGS = 16;
    public static final int EMR_SETMAPMODE = 17;
    public static final int EMR_SETBKMODE = 18;
    public static final int EMR_SETPOLYFILLMODE = 19;
    public static final int EMR_SETROP2 = 20;
    public static final int EMR_SETSTRETCHBLTMODE = 21;
    public static final int EMR_SETTEXTALIGN = 22;
    public static final int EMR_SETCOLORADJUSTMENT = 23;
    public static final int EMR_SETTEXTCOLOR = 24;
    public static final int EMR_SETBKCOLOR = 25;
    public static final int EMR_OFFSETCLIPRGN = 26;
    public static final int EMR_MOVETOEX = 27;
    public static final int EMR_SETMETARGN = 28;
    public static final int EMR_EXCLUDECLIPRECT = 29;
    public static final int EMR_INTERSECTCLIPRECT = 30;
    public static final int EMR_SCALEVIEWPORTEXTEX = 31;
    public static final int EMR_SCALEWINDOWEXTEX = 32;
    public static final int EMR_SAVEDC = 33;
    public static final int EMR_RESTOREDC = 34;
    public static final int EMR_SETWORLDTRANSFORM = 35;
    public static final int EMR_MODIFYWORLDTRANSFORM = 36;
    public static final int EMR_SELECTOBJECT = 37;
    public static final int EMR_CREATEPEN = 38;
    public static final int EMR_CREATEBRUSHINDIRECT = 39;
    public static final int EMR_DELETEOBJECT = 40;
    public static final int EMR_ANGLEARC = 41;
    public static final int EMR_ELLIPSE = 42;
    public static final int EMR_RECTANGLE = 43;
    public static final int EMR_ROUNDRECT = 44;
    public static final int EMR_ARC = 45;
    public static final int EMR_CHORD = 46;
    public static final int EMR_PIE = 47;
    public static final int EMR_SELECTPALETTE = 48;
    public static final int EMR_CREATEPALETTE = 49;
    public static final int EMR_SETPALETTEENTRIES = 50;
    public static final int EMR_RESIZEPALETTE = 51;
    public static final int EMR_REALIZEPALETTE = 52;
    public static final int EMR_EXTFLOODFILL = 53;
    public static final int EMR_LINETO = 54;
    public static final int EMR_ARCTO = 55;
    public static final int EMR_POLYDRAW = 56;
    public static final int EMR_SETARCDIRECTION = 57;
    public static final int EMR_SETMITERLIMIT = 58;
    public static final int EMR_BEGINPATH = 59;
    public static final int EMR_ENDPATH = 60;
    public static final int EMR_CLOSEFIGURE = 61;
    public static final int EMR_FILLPATH = 62;
    public static final int EMR_STROKEANDFILLPATH = 63;
    public static final int EMR_STROKEPATH = 64;
    public static final int EMR_FLATTENPATH = 65;
    public static final int EMR_WIDENPATH = 66;
    public static final int EMR_SELECTCLIPPATH = 67;
    public static final int EMR_ABORTPATH = 68;
    public static final int EMR_GDICOMMENT = 70;
    public static final int EMR_FILLRGN = 71;
    public static final int EMR_FRAMERGN = 72;
    public static final int EMR_INVERTRGN = 73;
    public static final int EMR_PAINTRGN = 74;
    public static final int EMR_EXTSELECTCLIPRGN = 75;
    public static final int EMR_BITBLT = 76;
    public static final int EMR_STRETCHBLT = 77;
    public static final int EMR_MASKBLT = 78;
    public static final int EMR_PLGBLT = 79;
    public static final int EMR_SETDIBITSTODEVICE = 80;
    public static final int EMR_STRETCHDIBITS = 81;
    public static final int EMR_EXTCREATEFONTINDIRECTW = 82;
    public static final int EMR_EXTTEXTOUTA = 83;
    public static final int EMR_EXTTEXTOUTW = 84;
    public static final int EMR_POLYBEZIER16 = 85;
    public static final int EMR_POLYGON16 = 86;
    public static final int EMR_POLYLINE16 = 87;
    public static final int EMR_POLYBEZIERTO16 = 88;
    public static final int EMR_POLYLINETO16 = 89;
    public static final int EMR_POLYPOLYLINE16 = 90;
    public static final int EMR_POLYPOLYGON16 = 91;
    public static final int EMR_POLYDRAW16 = 92;
    public static final int EMR_CREATEMONOBRUSH = 93;
    public static final int EMR_CREATEDIBPATTERNBRUSHPT = 94;
    public static final int EMR_EXTCREATEPEN = 95;
    public static final int EMR_POLYTEXTOUTA = 96;
    public static final int EMR_POLYTEXTOUTW = 97;
    public static final int EMR_SETICMMODE = 98;
    public static final int EMR_CREATECOLORSPACE = 99;
    public static final int EMR_SETCOLORSPACE = 100;
    public static final int EMR_DELETECOLORSPACE = 101;
    public static final int EMR_GLSRECORD = 102;
    public static final int EMR_GLSBOUNDEDRECORD = 103;
    public static final int EMR_PIXELFORMAT = 104;
    public static final int EMR_DRAWESCAPE = 105;
    public static final int EMR_EXTESCAPE = 106;
    public static final int EMR_STARTDOC = 107;
    public static final int EMR_SMALLTEXTOUT = 108;
    public static final int EMR_FORCEUFIMAPPING = 109;
    public static final int EMR_NAMEDESCAPE = 110;
    public static final int EMR_COLORCORRECTPALETTE = 111;
    public static final int EMR_SETICMPROFILEA = 112;
    public static final int EMR_SETICMPROFILEW = 113;
    public static final int EMR_ALPHABLEND = 114;
    public static final int EMR_ALPHADIBBLEND = 115;
    public static final int EMR_TRANSPARENTBLT = 116;
    public static final int EMR_TRANSPARENTDIB = 117;
    public static final int EMR_GRADIENTFILL = 118;
    public static final int EMR_SETLINKEDUFIS = 119;
    public static final int EMR_SETTEXTJUSTIFICATION = 120;
    public static final int EMR_COLORMATCHTOTARGETW = 121;
    public static final int EMR_CREATECOLORSPACEW = 122;
    static final int WHITE_BRUSH = 0;
    static final int BLACK_PEN = 7;
    static final int SYSTEM_FONT = 13;
    static final int DEFAULT_PALETTE = 15;
    static final int N_RESERVED_HANDLES = 1;
    private int nPeekActiveEMFHandles = 0;
    private int nTotalEMFHandlesCreated = 0;
    private final ArrayList<GDIObject> gdiObjects = new ArrayList();
    private int nEMFRecords = 0;
    private final RandomAccessMemoryFile emfDataStream = new RandomAccessMemoryFile();
    private long currentRecordStartPosition;
    private final GDIState gdiState = new GDIState();
    static final int ENHMETA_SIGNATURE = 1179469088;
    private FontRenderContext fontRenderContext;
    static final int RGN_AND = 1;
    static final int RGN_OR = 2;
    static final int RGN_XOR = 3;
    static final int RGN_DIFF = 4;
    static final int RGN_COPY = 5;
    static final int EOF_RECORD_SIZE = 20;

    static void Write_WORD(OutputStream stream, int w) throws IOException {
        stream.write((byte)(w >>> 0 & 0xFF));
        stream.write((byte)(w >>> 8 & 0xFF));
    }

    static void Write_DWORD(OutputStream stream, int dw) throws IOException {
        stream.write((byte)(dw >>> 0 & 0xFF));
        stream.write((byte)(dw >>> 8 & 0xFF));
        stream.write((byte)(dw >>> 16 & 0xFF));
        stream.write((byte)(dw >>> 24 & 0xFF));
    }

    static void Write_LONG(OutputStream stream, int l) throws IOException {
        stream.write((byte)(l >>> 0 & 0xFF));
        stream.write((byte)(l >>> 8 & 0xFF));
        stream.write((byte)(l >>> 16 & 0xFF));
        stream.write((byte)(l >>> 24 & 0xFF));
    }

    static void Write_ULONG(OutputStream stream, int ul) throws IOException {
        stream.write((byte)(ul >>> 0 & 0xFF));
        stream.write((byte)(ul >>> 8 & 0xFF));
        stream.write((byte)(ul >>> 16 & 0xFF));
        stream.write((byte)(ul >>> 24 & 0xFF));
    }

    static void Write_UINT(OutputStream stream, int uint) throws IOException {
        stream.write((byte)(uint >>> 0 & 0xFF));
        stream.write((byte)(uint >>> 8 & 0xFF));
        stream.write((byte)(uint >>> 16 & 0xFF));
        stream.write((byte)(uint >>> 24 & 0xFF));
    }

    static void Write_FLOAT(OutputStream stream, float f) throws IOException {
        int intVar = Float.floatToIntBits(f);
        EMFRecorder.Write_DWORD(stream, intVar);
    }

    static void Write_WCHAR(OutputStream stream, char wch) throws IOException {
        stream.write((byte)(wch >>> 0 & 0xFF));
        stream.write((byte)(wch >>> 8 & 0xFF));
    }

    static void Write_String(OutputStream stream, String str, int nCharsToWrite) throws IOException {
        int charIndex;
        int length = str.length();
        for (charIndex = 0; charIndex < length && charIndex < nCharsToWrite; ++charIndex) {
            EMFRecorder.Write_WCHAR(stream, str.charAt(charIndex));
        }
        while (charIndex < nCharsToWrite) {
            EMFRecorder.Write_WCHAR(stream, '\u0000');
            ++charIndex;
        }
    }

    static void Write_RECT(OutputStream stream, int x, int y, int width, int height) throws IOException {
        EMFRecorder.Write_LONG(stream, x);
        EMFRecorder.Write_LONG(stream, y);
        EMFRecorder.Write_LONG(stream, x + width);
        EMFRecorder.Write_LONG(stream, y + height);
    }

    static void Write_RECT(OutputStream stream, Rectangle rcl) throws IOException {
        EMFRecorder.Write_LONG(stream, rcl.x);
        EMFRecorder.Write_LONG(stream, rcl.y);
        EMFRecorder.Write_LONG(stream, rcl.x + rcl.width);
        EMFRecorder.Write_LONG(stream, rcl.y + rcl.height);
    }

    static void Write_SIZE(OutputStream stream, int cx, int cy) throws IOException {
        EMFRecorder.Write_LONG(stream, cx);
        EMFRecorder.Write_LONG(stream, cy);
    }

    static void Write_POINT(OutputStream stream, int x, int y) throws IOException {
        EMFRecorder.Write_LONG(stream, x);
        EMFRecorder.Write_LONG(stream, y);
    }

    static void Write_COLORREF(OutputStream stream, Color color) throws IOException {
        stream.write((byte)color.getRed());
        stream.write((byte)color.getGreen());
        stream.write((byte)color.getBlue());
        stream.write(0);
    }

    static void Write_LOGPEN(OutputStream stream, int style, int width, Color color) throws IOException {
        EMFRecorder.Write_UINT(stream, style);
        EMFRecorder.Write_POINT(stream, width, 0);
        EMFRecorder.Write_COLORREF(stream, color);
    }

    static void Write_LOGBRUSH32(OutputStream stream, int style, Color color, int hatch) throws IOException {
        EMFRecorder.Write_UINT(stream, style);
        EMFRecorder.Write_COLORREF(stream, color);
        EMFRecorder.Write_ULONG(stream, hatch);
    }

    static void Write_LOGFONT(OutputStream stream, int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, byte charset, byte outprecision, byte clipprecision, byte quality, byte pitchandfamily, String faceName) throws IOException {
        EMFRecorder.Write_LONG(stream, height);
        EMFRecorder.Write_LONG(stream, width);
        EMFRecorder.Write_LONG(stream, escapement);
        EMFRecorder.Write_LONG(stream, orientation);
        EMFRecorder.Write_LONG(stream, weight);
        stream.write(italic ? 1 : 0);
        stream.write(underline ? 1 : 0);
        stream.write(strikeout ? 1 : 0);
        stream.write(charset);
        stream.write(outprecision);
        stream.write(clipprecision);
        stream.write(quality);
        stream.write(pitchandfamily);
        EMFRecorder.Write_String(stream, faceName, 32);
    }

    static void Write_EXTLOGFONTW(OutputStream stream, Font font, int escapement, boolean underline, boolean strikeout) throws IOException {
        int index;
        int height = -font.getSize();
        int width = 0;
        int orientation = escapement;
        int weight = font.isBold() ? 700 : 400;
        boolean italic = font.isItalic();
        byte charset = 1;
        byte outprecision = 0;
        byte clipprecision = 0;
        byte quality = 0;
        byte pitchandfamily = 0;
        EMFRecorder.Write_LOGFONT(stream, height, width, escapement, orientation, weight, italic, underline, strikeout, charset, outprecision, clipprecision, quality, pitchandfamily, font.getName());
        EMFRecorder.Write_String(stream, font.getName(), 64);
        String style = "";
        if (font.isBold() && font.isItalic()) {
            style = "Bold Italic";
        } else if (font.isBold()) {
            style = "Bold";
        } else if (font.isItalic()) {
            style = "Italic";
        }
        EMFRecorder.Write_String(stream, style, 32);
        EMFRecorder.Write_DWORD(stream, 1);
        EMFRecorder.Write_DWORD(stream, 0);
        EMFRecorder.Write_DWORD(stream, 0);
        EMFRecorder.Write_DWORD(stream, 0);
        for (index = 0; index < 4; ++index) {
            stream.write(0);
        }
        EMFRecorder.Write_DWORD(stream, 0);
        for (index = 0; index < 10; ++index) {
            stream.write(0);
        }
        stream.write(0);
        stream.write(0);
    }

    static void Write_EXTLOGFONTW(OutputStream stream, int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, byte charset, byte outprecision, byte clipprecision, byte quality, byte pitchandfamily, String fontName) throws IOException {
        int index;
        EMFRecorder.Write_LOGFONT(stream, height, width, escapement, orientation, weight, italic, underline, strikeout, charset, outprecision, clipprecision, quality, pitchandfamily, fontName);
        EMFRecorder.Write_String(stream, fontName, 64);
        String style = "";
        if (weight >= 700 && italic) {
            style = "Bold Italic";
        } else if (weight >= 700) {
            style = "Bold";
        } else if (italic) {
            style = "Italic";
        }
        EMFRecorder.Write_String(stream, style, 32);
        EMFRecorder.Write_DWORD(stream, 1);
        EMFRecorder.Write_DWORD(stream, 0);
        EMFRecorder.Write_DWORD(stream, 0);
        EMFRecorder.Write_DWORD(stream, 0);
        for (index = 0; index < 4; ++index) {
            stream.write(0);
        }
        EMFRecorder.Write_DWORD(stream, 0);
        for (index = 0; index < 10; ++index) {
            stream.write(0);
        }
    }

    static void Write_EMRTEXT(OutputStream outputStream, int leadingOffset, int x, int y, int options, Rectangle rect, String string, int[] dx) throws IOException {
        boolean addPadding;
        EMFRecorder.Write_POINT(outputStream, x, y);
        EMFRecorder.Write_DWORD(outputStream, string.length());
        int offString = leadingOffset + 40;
        EMFRecorder.Write_DWORD(outputStream, offString);
        EMFRecorder.Write_DWORD(outputStream, options);
        EMFRecorder.Write_RECT(outputStream, rect);
        int offDx = offString + 2 * string.length();
        boolean bl = addPadding = offDx % 4 != 0;
        if (addPadding) {
            offDx += 2;
        }
        EMFRecorder.Write_DWORD(outputStream, offDx);
        EMFRecorder.Write_String(outputStream, string, string.length());
        if (addPadding) {
            outputStream.write(0);
            outputStream.write(0);
        }
        for (int charN = 0; charN < string.length(); ++charN) {
            if (charN < dx.length) {
                EMFRecorder.Write_LONG(outputStream, dx[charN]);
                continue;
            }
            assert (false);
            EMFRecorder.Write_LONG(outputStream, 0);
        }
    }

    static void Write_BITMAPINFO(OutputStream outputStream, int width, int height) throws IOException {
        EMFRecorder.Write_DWORD(outputStream, 40);
        EMFRecorder.Write_LONG(outputStream, width);
        EMFRecorder.Write_LONG(outputStream, -height);
        EMFRecorder.Write_WORD(outputStream, 1);
        EMFRecorder.Write_WORD(outputStream, 24);
        EMFRecorder.Write_DWORD(outputStream, 0);
        int bytesPerScanline = (width * 3 + 3) / 4 * 4;
        int biSizeImage = bytesPerScanline * height;
        EMFRecorder.Write_DWORD(outputStream, biSizeImage);
        EMFRecorder.Write_LONG(outputStream, 0);
        EMFRecorder.Write_LONG(outputStream, 0);
        EMFRecorder.Write_DWORD(outputStream, 0);
        EMFRecorder.Write_DWORD(outputStream, 0);
    }

    static void Write_BITMAPBITS(OutputStream outputStream, int[] pix, int width, int height) throws IOException {
        int bytesPerScanline = (width * 3 + 3) / 4 * 4;
        byte[] paddingBytes = new byte[bytesPerScanline - width * 3];
        for (int index = 0; index < paddingBytes.length; ++index) {
            paddingBytes[index] = 0;
        }
        for (int lineN = 0; lineN < height; ++lineN) {
            for (int columnN = 0; columnN < width; ++columnN) {
                int offset = lineN * width + columnN;
                int pixelColor = 0;
                if (offset < pix.length) {
                    pixelColor = pix[offset];
                }
                byte r = (byte)(pixelColor >> 16 & 0xFF);
                byte g = (byte)(pixelColor >> 8 & 0xFF);
                byte b = (byte)(pixelColor & 0xFF);
                outputStream.write(b);
                outputStream.write(g);
                outputStream.write(r);
            }
            outputStream.write(paddingBytes);
        }
    }

    static boolean IsStockObject(int objectIndex) {
        return (objectIndex & Integer.MIN_VALUE) != 0;
    }

    private int createGDIObject(GDIObjectType objectType, Object objectAttribute) {
        int index;
        assert (objectType != GDIObjectType.UNUSED);
        if (this.gdiObjects.size() == 0) {
            for (index = 0; index < 1; ++index) {
                this.gdiObjects.add(GDIObject.RESERVED_GDIOBJECT);
            }
        }
        int nHandles = this.gdiObjects.size();
        for (index = 1; index < nHandles; ++index) {
            if (this.gdiObjects.get(index) != GDIObject.UNUSED_GDIOBJECT) continue;
            this.gdiObjects.set(index, new GDIObject(objectType, objectAttribute));
            return index;
        }
        this.gdiObjects.add(new GDIObject(objectType, objectAttribute));
        this.nPeekActiveEMFHandles = this.gdiObjects.size() - 1;
        ++this.nTotalEMFHandlesCreated;
        return this.gdiObjects.size() - 1;
    }

    private void deleteGDIObject(int objectIndex) {
        assert (objectIndex >= 1 && objectIndex < this.gdiObjects.size());
        this.gdiObjects.set(objectIndex, GDIObject.UNUSED_GDIOBJECT);
    }

    private GDIObject getGDIObject(int objectIndex) {
        assert (objectIndex >= 1 && objectIndex < this.gdiObjects.size());
        return this.gdiObjects.get(objectIndex);
    }

    private void startRecord(int iType) throws IOException {
        this.currentRecordStartPosition = this.emfDataStream.getFilePointer();
        EMFRecorder.Write_DWORD(this.emfDataStream, iType);
        EMFRecorder.Write_DWORD(this.emfDataStream, 0);
    }

    private void endRecord() throws IOException {
        long recordEndPosition = this.emfDataStream.getFilePointer();
        int recordSize = (int)(recordEndPosition - this.currentRecordStartPosition);
        int SIZE_POSITION = 4;
        this.emfDataStream.seek(this.currentRecordStartPosition + 4L);
        EMFRecorder.Write_DWORD(this.emfDataStream, recordSize);
        this.emfDataStream.seek(recordEndPosition);
        ++this.nEMFRecords;
    }

    private EMFRecorder() {
        BufferedImage image = new BufferedImage(16, 16, 10);
        this.fontRenderContext = image.createGraphics().getFontRenderContext();
    }

    private void init(Rectangle rclFrame, int cxDevice, int cyDevice, int cxMillimeters, int cyMillimeters) {
        this.writeHeader(rclFrame, cxDevice, cyDevice, cxMillimeters, cyMillimeters);
        this.setMapMode(8);
        this.setViewportExt(cxDevice, cyDevice);
        this.setWindowExt(cxDevice, cyDevice);
    }

    public static EMFRecorder CreateEMFRecorder(Rectangle rclFrame, int cxDevice, int cyDevice, double dpiX, double dpiY) {
        EMFRecorder emfRecorder = new EMFRecorder();
        Rectangle rclFrameMu = new Rectangle((int)((double)rclFrame.x / dpiX * 2540.0), (int)((double)rclFrame.y / dpiY * 2540.0), (int)((double)rclFrame.width / dpiX * 2540.0), (int)((double)rclFrame.height / dpiY * 2540.0));
        int cxMicrometers = (int)((double)cxDevice / dpiY * 25400.0);
        int cyMicrometers = (int)((double)cyDevice / dpiX * 25400.0);
        emfRecorder.init(rclFrameMu, cxDevice, cyDevice, cxMicrometers, cyMicrometers);
        return emfRecorder;
    }

    private void writeHeader(Rectangle rclFrame, int cxDevice, int cyDevice, int cxMicrometers, int cyMicrometers) {
        try {
            this.startRecord(1);
            EMFRecorder.Write_RECT(this.emfDataStream, 0, 0, cxDevice, cyDevice);
            EMFRecorder.Write_RECT(this.emfDataStream, rclFrame);
            EMFRecorder.Write_DWORD(this.emfDataStream, 1179469088);
            EMFRecorder.Write_DWORD(this.emfDataStream, 65536);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_WORD(this.emfDataStream, 0);
            EMFRecorder.Write_WORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 2);
            EMFRecorder.Write_DWORD(this.emfDataStream, 108);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_SIZE(this.emfDataStream, cxDevice, cyDevice);
            EMFRecorder.Write_SIZE(this.emfDataStream, cxMicrometers / 1000, cyMicrometers / 1000);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_SIZE(this.emfDataStream, cxMicrometers, cyMicrometers);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    private void updateHeader() {
        try {
            long savedPosition = this.emfDataStream.getFilePointer();
            this.emfDataStream.seek(48L);
            int nBytes = (int)savedPosition;
            EMFRecorder.Write_DWORD(this.emfDataStream, nBytes);
            EMFRecorder.Write_DWORD(this.emfDataStream, this.nEMFRecords);
            int nHandles = this.nPeekActiveEMFHandles + 1;
            EMFRecorder.Write_DWORD(this.emfDataStream, nHandles);
            this.emfDataStream.seek(savedPosition);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("updateHeader: " + nBytes + " bytes, " + this.nEMFRecords + " records, " + nHandles + " handles."));
            }
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void arc(int left, int top, int right, int bottom, int xStart, int yStart, int xEnd, int yEnd) {
        try {
            this.startRecord(45);
            EMFRecorder.Write_RECT(this.emfDataStream, left, top, right - right, bottom - top);
            EMFRecorder.Write_POINT(this.emfDataStream, xStart, yStart);
            EMFRecorder.Write_POINT(this.emfDataStream, xEnd, yEnd);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void chord(int left, int top, int right, int bottom, int x1, int y1, int x2, int y2) {
        try {
            this.startRecord(46);
            EMFRecorder.Write_RECT(this.emfDataStream, left, top, right - right, bottom - top);
            EMFRecorder.Write_POINT(this.emfDataStream, x1, y1);
            EMFRecorder.Write_POINT(this.emfDataStream, x2, y2);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void pie(int left, int top, int bottom, int right, int x1, int y1, int x2, int y2) {
        try {
            this.startRecord(47);
            EMFRecorder.Write_RECT(this.emfDataStream, left, top, right - right, bottom - top);
            EMFRecorder.Write_POINT(this.emfDataStream, x1, y1);
            EMFRecorder.Write_POINT(this.emfDataStream, x2, y2);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void ellipse(int x1, int y1, int x2, int y2) {
        try {
            this.startRecord(42);
            EMFRecorder.Write_RECT(this.emfDataStream, x1, y1, x2 - x1, y2 - y1);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void bitBlt(int dx, int dy, int dwidth, int dheight, int sx, int sy, int rop, int[] pix, int width, int height) {
        try {
            this.startRecord(76);
            EMFRecorder.Write_RECT(this.emfDataStream, 0, 0, -1, -1);
            EMFRecorder.Write_DWORD(this.emfDataStream, dx);
            EMFRecorder.Write_DWORD(this.emfDataStream, dy);
            EMFRecorder.Write_DWORD(this.emfDataStream, dwidth);
            EMFRecorder.Write_DWORD(this.emfDataStream, dheight);
            EMFRecorder.Write_DWORD(this.emfDataStream, rop);
            if (pix != null) {
                EMFRecorder.Write_DWORD(this.emfDataStream, sx);
                EMFRecorder.Write_DWORD(this.emfDataStream, sy);
            } else {
                EMFRecorder.Write_DWORD(this.emfDataStream, 0);
                EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            }
            float eM11 = 1.0f;
            float eM12 = 0.0f;
            float eM21 = 0.0f;
            float eM22 = 1.0f;
            float eDx = 0.0f;
            float eDy = 0.0f;
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM11);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM12);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM21);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM22);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eDx);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eDy);
            Color crBkColorSrc = new Color(255, 255, 255);
            EMFRecorder.Write_COLORREF(this.emfDataStream, crBkColorSrc);
            int iUsageSrc = 0;
            EMFRecorder.Write_DWORD(this.emfDataStream, iUsageSrc);
            if (pix != null) {
                int offBmiSrc = 100;
                EMFRecorder.Write_DWORD(this.emfDataStream, offBmiSrc);
                int cbBmiSrc = 40;
                EMFRecorder.Write_DWORD(this.emfDataStream, cbBmiSrc);
                int offBitsSrc = offBmiSrc + cbBmiSrc;
                EMFRecorder.Write_DWORD(this.emfDataStream, offBitsSrc);
                int bytesPerScanline = (width * 3 + 3) / 4 * 4;
                int cbBitsSrc = height * bytesPerScanline;
                EMFRecorder.Write_DWORD(this.emfDataStream, cbBitsSrc);
                EMFRecorder.Write_BITMAPINFO(this.emfDataStream, width, height);
                EMFRecorder.Write_BITMAPBITS(this.emfDataStream, pix, width, height);
            } else {
                int offBmiSrc = 0;
                EMFRecorder.Write_DWORD(this.emfDataStream, offBmiSrc);
                int cbBmiSrc = 0;
                EMFRecorder.Write_DWORD(this.emfDataStream, cbBmiSrc);
                int offBitsSrc = 0;
                EMFRecorder.Write_DWORD(this.emfDataStream, offBitsSrc);
                int cbBitsSrc = 0;
                EMFRecorder.Write_DWORD(this.emfDataStream, cbBitsSrc);
            }
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void patBlt(int dx, int dy, int dwidth, int dheight, int rop) {
        int sx = 0;
        int sy = 0;
        int width = 0;
        int height = 0;
        int[] pix = null;
        this.bitBlt(dx, dy, dwidth, dheight, sx, sy, rop, pix, width, height);
    }

    public void stretchBlt(int dx, int dy, int dwidth, int dheight, int sx, int sy, int swidth, int sheight, int rop, int[] pix, int width, int height) {
        try {
            this.startRecord(77);
            EMFRecorder.Write_RECT(this.emfDataStream, 0, 0, -1, -1);
            EMFRecorder.Write_DWORD(this.emfDataStream, dx);
            EMFRecorder.Write_DWORD(this.emfDataStream, dy);
            EMFRecorder.Write_DWORD(this.emfDataStream, dwidth);
            EMFRecorder.Write_DWORD(this.emfDataStream, dheight);
            EMFRecorder.Write_DWORD(this.emfDataStream, rop);
            EMFRecorder.Write_DWORD(this.emfDataStream, sx);
            EMFRecorder.Write_DWORD(this.emfDataStream, sy);
            float eM11 = 1.0f;
            float eM12 = 0.0f;
            float eM21 = 0.0f;
            float eM22 = 1.0f;
            float eDx = 0.0f;
            float eDy = 0.0f;
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM11);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM12);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM21);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eM22);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eDx);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eDy);
            Color crBkColorSrc = new Color(255, 255, 255);
            EMFRecorder.Write_COLORREF(this.emfDataStream, crBkColorSrc);
            int iUsageSrc = 0;
            EMFRecorder.Write_DWORD(this.emfDataStream, iUsageSrc);
            int offBmiSrc = 108;
            EMFRecorder.Write_DWORD(this.emfDataStream, offBmiSrc);
            int cbBmiSrc = 40;
            EMFRecorder.Write_DWORD(this.emfDataStream, cbBmiSrc);
            int offBitsSrc = offBmiSrc + cbBmiSrc;
            EMFRecorder.Write_DWORD(this.emfDataStream, offBitsSrc);
            int bytesPerScanline = (width * 3 + 3) / 4 * 4;
            int cbBitsSrc = height * bytesPerScanline;
            EMFRecorder.Write_DWORD(this.emfDataStream, cbBitsSrc);
            EMFRecorder.Write_DWORD(this.emfDataStream, swidth);
            EMFRecorder.Write_DWORD(this.emfDataStream, sheight);
            EMFRecorder.Write_BITMAPINFO(this.emfDataStream, width, height);
            EMFRecorder.Write_BITMAPBITS(this.emfDataStream, pix, width, height);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public int createBrushIndirect(int style, Color color, int hatch) {
        try {
            this.startRecord(39);
            int ihBrush = this.createGDIObject(GDIObjectType.BRUSH, null);
            EMFRecorder.Write_DWORD(this.emfDataStream, ihBrush);
            EMFRecorder.Write_LOGBRUSH32(this.emfDataStream, style, color, hatch);
            this.endRecord();
            return ihBrush;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return 0;
        }
    }

    public int createFont(Font font, int escapement, boolean underline, boolean strikeout) {
        try {
            this.startRecord(82);
            int ihFont = this.createGDIObject(GDIObjectType.FONT, font);
            EMFRecorder.Write_DWORD(this.emfDataStream, ihFont);
            EMFRecorder.Write_EXTLOGFONTW(this.emfDataStream, font, escapement, underline, strikeout);
            this.endRecord();
            return ihFont;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return 0;
        }
    }

    public int createFontIndirect(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, byte charset, byte outprecision, byte clipprecision, byte quality, byte pitchandfamily, String name) {
        try {
            this.startRecord(82);
            int style = 0;
            if (weight >= 700 && italic) {
                style = 3;
            } else if (weight >= 700) {
                style = 1;
            } else if (italic) {
                style = 2;
            }
            Font newFont = new Font(name, style, -height);
            int ihFont = this.createGDIObject(GDIObjectType.FONT, newFont);
            EMFRecorder.Write_DWORD(this.emfDataStream, ihFont);
            EMFRecorder.Write_EXTLOGFONTW(this.emfDataStream, height, width, escapement, orientation, weight, italic, underline, strikeout, charset, outprecision, clipprecision, quality, pitchandfamily, name);
            this.endRecord();
            return ihFont;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return 0;
        }
    }

    public int createPatternBrush(int[] pix, int width, int height) {
        try {
            this.startRecord(94);
            int ihBrush = this.createGDIObject(GDIObjectType.BRUSH, null);
            EMFRecorder.Write_DWORD(this.emfDataStream, ihBrush);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            int offBmi = 32;
            EMFRecorder.Write_DWORD(this.emfDataStream, offBmi);
            int cbBmi = 40;
            EMFRecorder.Write_DWORD(this.emfDataStream, cbBmi);
            int offBits = offBmi + cbBmi;
            EMFRecorder.Write_DWORD(this.emfDataStream, offBits);
            int bytesPerScanline = (width * 3 + 3) / 4 * 4;
            int cbBits = height * bytesPerScanline;
            EMFRecorder.Write_DWORD(this.emfDataStream, cbBits);
            EMFRecorder.Write_BITMAPINFO(this.emfDataStream, width, height);
            EMFRecorder.Write_BITMAPBITS(this.emfDataStream, pix, width, height);
            this.endRecord();
            return ihBrush;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return 0;
        }
    }

    public int createPenIndirect(int style, int width, Color color) {
        try {
            this.startRecord(38);
            int ihPen = this.createGDIObject(GDIObjectType.PEN, null);
            EMFRecorder.Write_DWORD(this.emfDataStream, ihPen);
            EMFRecorder.Write_LOGPEN(this.emfDataStream, style, width, color);
            this.endRecord();
            return ihPen;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return 0;
        }
    }

    public void deleteObject(int index) {
        try {
            if (!EMFRecorder.IsStockObject(index) && index != this.gdiState.ihBrush && index != this.gdiState.ihFont && index != this.gdiState.ihPen && index != this.gdiState.ihPalette) {
                this.startRecord(40);
                this.deleteGDIObject(index);
                EMFRecorder.Write_DWORD(this.emfDataStream, index);
                this.endRecord();
            } else if (logger.isDebugEnabled()) {
                if (EMFRecorder.IsStockObject(index)) {
                    logger.debug((Object)("try to delete a stock object (" + index + ")"));
                } else {
                    GDIObject gdiObject = this.getGDIObject(index);
                    logger.debug((Object)("try to delete a selected object (" + index + ", " + gdiObject.toString() + ")"));
                }
            }
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void escape(int number, byte[] data) {
        try {
            this.startRecord(70);
            EMFRecorder.Write_DWORD(this.emfDataStream, number);
            if (number <= data.length) {
                this.emfDataStream.write(data, 0, number);
            } else {
                this.emfDataStream.write(data);
                for (int byteN = data.length; byteN < number; ++byteN) {
                    this.emfDataStream.write(0);
                }
            }
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void textOut(int x, int y, String string) {
        int options = 0;
        Rectangle rect = new Rectangle();
        this.extTextOut(x, y, options, rect, string);
    }

    public void extTextOut(int x, int y, int options, Rectangle rect, String string) {
        int[] dx = new int[string.length()];
        Font currentFont = null;
        if (!EMFRecorder.IsStockObject(this.gdiState.ihFont)) {
            GDIObject gdiObject = this.getGDIObject(this.gdiState.ihFont);
            currentFont = (Font)gdiObject.objectAttribute;
        }
        if (currentFont == null) {
            assert (false);
            for (int charN = 0; charN < dx.length; ++charN) {
                dx[charN] = 12;
            }
        } else {
            GlyphVector glyphVector = currentFont.createGlyphVector(this.fontRenderContext, string);
            assert (glyphVector.getNumGlyphs() == string.length());
            for (int charN = 0; charN < dx.length; ++charN) {
                GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(charN);
                dx[charN] = Math.round(glyphMetrics.getAdvance());
            }
        }
        this.extTextOut(x, y, options, rect, string, dx);
    }

    public void extTextOut(int x, int y, int options, Rectangle rect, String string, int[] dx) {
        if (dx == null) {
            this.extTextOut(x, y, options, rect, string);
            return;
        }
        try {
            this.startRecord(84);
            Rectangle rclBounds = new Rectangle(-10000, -10000, 20000, 20000);
            EMFRecorder.Write_RECT(this.emfDataStream, rclBounds);
            EMFRecorder.Write_DWORD(this.emfDataStream, 1);
            float exScale = 1.0f;
            float eyScale = 1.0f;
            EMFRecorder.Write_FLOAT(this.emfDataStream, exScale);
            EMFRecorder.Write_FLOAT(this.emfDataStream, eyScale);
            int leadingOffset = 36;
            Rectangle rclEMRText = new Rectangle();
            EMFRecorder.Write_EMRTEXT(this.emfDataStream, leadingOffset, x, y, options, rclEMRText, string, dx);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void intersectClipRect(int x1, int y1, int x2, int y2) {
        try {
            this.startRecord(30);
            EMFRecorder.Write_RECT(this.emfDataStream, x1, y1, x2 - x1, y2 - y2);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void lineTo(int x, int y) {
        try {
            this.startRecord(54);
            EMFRecorder.Write_POINT(this.emfDataStream, x, y);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void moveTo(int x, int y) {
        try {
            this.startRecord(27);
            EMFRecorder.Write_POINT(this.emfDataStream, x, y);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setViewportOrg(int x, int y) {
        this.gdiState.viewportOrgX = x;
        this.gdiState.viewportOrgY = y;
        try {
            this.startRecord(12);
            EMFRecorder.Write_POINT(this.emfDataStream, x, y);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void offsetViewportOrg(int xOfs, int yOfs) {
        if (xOfs != 0 || yOfs != 0) {
            int newViewportOrgX = this.gdiState.viewportOrgX + xOfs;
            int newViewportOrgY = this.gdiState.viewportOrgY + yOfs;
            this.setViewportOrg(newViewportOrgX, newViewportOrgY);
        }
    }

    public void scaleViewportExt(int xnum, int xdenom, int ynum, int ydenom) {
        try {
            this.startRecord(31);
            EMFRecorder.Write_LONG(this.emfDataStream, xnum);
            EMFRecorder.Write_LONG(this.emfDataStream, xdenom);
            EMFRecorder.Write_LONG(this.emfDataStream, ynum);
            EMFRecorder.Write_LONG(this.emfDataStream, ydenom);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setViewportExt(int width, int height) {
        try {
            this.startRecord(11);
            EMFRecorder.Write_SIZE(this.emfDataStream, width, height);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setWindowOrg(int x, int y) {
        this.gdiState.windowOrgX = x;
        this.gdiState.windowOrgY = y;
        try {
            this.startRecord(10);
            EMFRecorder.Write_POINT(this.emfDataStream, x, y);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void offsetWindowOrg(int offX, int offY) {
        if (offX != 0 || offY != 0) {
            int newWindowOrgX = this.gdiState.windowOrgX + offX;
            int newWindowOrgY = this.gdiState.windowOrgY + offY;
            this.setWindowOrg(newWindowOrgX, newWindowOrgY);
        }
    }

    public void scaleWindowExt(int xnum, int xdenom, int ynum, int ydenom) {
        try {
            this.startRecord(32);
            EMFRecorder.Write_LONG(this.emfDataStream, xnum);
            EMFRecorder.Write_LONG(this.emfDataStream, xdenom);
            EMFRecorder.Write_LONG(this.emfDataStream, ynum);
            EMFRecorder.Write_LONG(this.emfDataStream, ydenom);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setWindowExt(int width, int height) {
        try {
            this.startRecord(9);
            EMFRecorder.Write_SIZE(this.emfDataStream, width, height);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    private void polyPoints(int recordType, int[] xPoints, int[] yPoints, int nPoints) {
        try {
            if (nPoints > xPoints.length) {
                nPoints = xPoints.length;
            }
            if (nPoints > yPoints.length) {
                nPoints = yPoints.length;
            }
            this.startRecord(recordType);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int pointN = 0; pointN < nPoints; ++pointN) {
                if (xPoints[pointN] < minX) {
                    minX = xPoints[pointN];
                }
                if (xPoints[pointN] > maxX) {
                    maxX = xPoints[pointN];
                }
                if (yPoints[pointN] < minY) {
                    minY = yPoints[pointN];
                }
                if (yPoints[pointN] <= maxY) continue;
                maxY = yPoints[pointN];
            }
            EMFRecorder.Write_RECT(this.emfDataStream, minX, minY, maxX - minX, maxY - minY);
            EMFRecorder.Write_DWORD(this.emfDataStream, nPoints);
            for (int pointN = 0; pointN < nPoints; ++pointN) {
                EMFRecorder.Write_POINT(this.emfDataStream, xPoints[pointN], yPoints[pointN]);
            }
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void polygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.polyPoints(3, xPoints, yPoints, nPoints);
    }

    public void polyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.polyPoints(4, xPoints, yPoints, nPoints);
    }

    public void polypolygon(Polygon[] polys) {
        try {
            int polyN;
            this.startRecord(8);
            int totalPoints = 0;
            Rectangle rclBounds = new Rectangle();
            for (polyN = 0; polyN < polys.length; ++polyN) {
                rclBounds = rclBounds.union(polys[polyN].getBounds());
                totalPoints += polys[polyN].npoints;
            }
            EMFRecorder.Write_RECT(this.emfDataStream, rclBounds);
            EMFRecorder.Write_DWORD(this.emfDataStream, polys.length);
            EMFRecorder.Write_DWORD(this.emfDataStream, totalPoints);
            for (polyN = 0; polyN < polys.length; ++polyN) {
                EMFRecorder.Write_DWORD(this.emfDataStream, polys[polyN].npoints);
            }
            for (polyN = 0; polyN < polys.length; ++polyN) {
                Polygon polygon = polys[polyN];
                for (int pointN = 0; pointN < polygon.npoints; ++pointN) {
                    EMFRecorder.Write_POINT(this.emfDataStream, polygon.xpoints[pointN], polygon.ypoints[pointN]);
                }
            }
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void rectangle(int left, int right, int top, int bottom) {
        try {
            this.startRecord(43);
            EMFRecorder.Write_RECT(this.emfDataStream, left, top, right - left, bottom - top);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void roundRect(int left, int top, int right, int bottom, int width, int height) {
        try {
            this.startRecord(44);
            EMFRecorder.Write_RECT(this.emfDataStream, left, top, right - left, bottom - top);
            EMFRecorder.Write_SIZE(this.emfDataStream, width, height);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void selectObject(int index) {
        try {
            this.startRecord(37);
            EMFRecorder.Write_DWORD(this.emfDataStream, index);
            this.endRecord();
            if (!EMFRecorder.IsStockObject(index)) {
                GDIObject gdiObject = this.getGDIObject(index);
                if (gdiObject.objectType == GDIObjectType.FONT) {
                    this.gdiState.ihFont = index;
                } else if (gdiObject.objectType == GDIObjectType.BRUSH) {
                    this.gdiState.ihBrush = index;
                } else if (gdiObject.objectType == GDIObjectType.PEN) {
                    this.gdiState.ihPen = index;
                } else if (gdiObject.objectType == GDIObjectType.PALETTE) {
                    this.gdiState.ihPalette = index;
                } else assert (false);
            }
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setBKColor(Color bkcolor) {
        try {
            this.startRecord(25);
            EMFRecorder.Write_COLORREF(this.emfDataStream, bkcolor);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setBKMode(int mode) {
        try {
            this.startRecord(18);
            EMFRecorder.Write_DWORD(this.emfDataStream, mode);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setClipRgn() {
        try {
            this.startRecord(75);
            boolean cbRgnData = false;
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 5);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setMapMode(int mode) {
        try {
            this.startRecord(17);
            EMFRecorder.Write_DWORD(this.emfDataStream, mode);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setPixel(int x, int y, Color color) {
        try {
            this.startRecord(15);
            EMFRecorder.Write_POINT(this.emfDataStream, x, y);
            EMFRecorder.Write_COLORREF(this.emfDataStream, color);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setPolyFillMode(int mode) {
        try {
            this.startRecord(19);
            EMFRecorder.Write_DWORD(this.emfDataStream, mode);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setROP2(int mode) {
        try {
            this.startRecord(20);
            EMFRecorder.Write_DWORD(this.emfDataStream, mode);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setStretchBltMode(int mode) {
        try {
            this.startRecord(21);
            EMFRecorder.Write_DWORD(this.emfDataStream, mode);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setTextAlign(int align) {
        try {
            this.startRecord(22);
            EMFRecorder.Write_DWORD(this.emfDataStream, align);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setTextColor(Color textcolor) {
        try {
            this.startRecord(24);
            EMFRecorder.Write_COLORREF(this.emfDataStream, textcolor);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void setTextCharacterExtra(int charextra) {
        if (charextra != 0) {
            throw new IllegalArgumentException("Obsolete function, EMFRecorder doesn't support setTextCharacterExtra!");
        }
    }

    public void setTextJustification(int breakextra, int breakcount) {
        throw new IllegalArgumentException("Obsolete function, EMFRecorder doesn't support setTextJustification!");
    }

    public void writePlaceableWMF(OutputStream out, int x, int y, int width, int height, int dpi) throws IOException {
        throw new IllegalArgumentException("Programming error, EMFRecorder doesn't support writePlaceableWMF!");
    }

    public void writeWMF(OutputStream out) throws IOException {
        throw new IllegalArgumentException("Programming error, EMFRecorder doesn't support writeWMF!");
    }

    public void setTranslateFontNames(String[][] names) {
        super.setTranslateFontNames(names);
    }

    public String translateFontName(String name) {
        String winName = super.translateFontName(name);
        return winName;
    }

    public String[][] getTranslateFontNames() {
        String[][] names = super.getTranslateFontNames();
        return names;
    }

    private void eof() {
        try {
            this.startRecord(14);
            EMFRecorder.Write_DWORD(this.emfDataStream, 0);
            EMFRecorder.Write_DWORD(this.emfDataStream, 16);
            EMFRecorder.Write_DWORD(this.emfDataStream, 20);
            this.endRecord();
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
    }

    public void finalizeEMF() {
        this.eof();
        this.updateHeader();
    }

    public void writeEMF(OutputStream out) throws IOException {
        int nBytesRead;
        InputStream inputStream = this.emfDataStream.getInputStream();
        int bufferSize = 32768;
        byte[] buffer = new byte[32768];
        do {
            if ((nBytesRead = inputStream.read(buffer)) <= 0) continue;
            out.write(buffer, 0, nBytesRead);
        } while (nBytesRead >= 32768);
    }

    public byte[] getMetafileData() {
        try {
            long metafileDataSize = this.emfDataStream.getFilePointer();
            byte[] metafileData = new byte[(int)metafileDataSize];
            InputStream inputStream = this.emfDataStream.getInputStream();
            inputStream.read(metafileData);
            return metafileData;
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
            return null;
        }
    }

    static class GDIObject {
        final GDIObjectType objectType;
        final Object objectAttribute;
        static final GDIObject RESERVED_GDIOBJECT = new GDIObject(GDIObjectType.RESERVED, null);
        static final GDIObject UNUSED_GDIOBJECT = new GDIObject(GDIObjectType.UNUSED, null);

        GDIObject(GDIObjectType type, Object attribute) {
            this.objectType = type;
            this.objectAttribute = attribute;
        }

        public String toString() {
            return this.objectType.toString();
        }
    }

    static class GDIObjectType {
        private final int type;
        static final int _unused = 0;
        static final int _reserved = 1;
        static final int _brush = 2;
        static final int _font = 3;
        static final int _palette = 4;
        static final int _pen = 5;
        static final GDIObjectType UNUSED = new GDIObjectType(0);
        static final GDIObjectType RESERVED = new GDIObjectType(1);
        static final GDIObjectType BRUSH = new GDIObjectType(2);
        static final GDIObjectType FONT = new GDIObjectType(3);
        static final GDIObjectType PALETTE = new GDIObjectType(4);
        static final GDIObjectType PEN = new GDIObjectType(5);

        private GDIObjectType(int type) {
            this.type = type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "UNUSED";
                }
                case 1: {
                    return "RESERVED";
                }
                case 2: {
                    return "BRUSH";
                }
                case 3: {
                    return "FONT";
                }
                case 4: {
                    return "PALETTE";
                }
                case 5: {
                    return "PEN";
                }
            }
            assert (false);
            return "Unknown";
        }
    }

    static class GDIState {
        int viewportOrgX = 0;
        int viewportOrgY = 0;
        int windowOrgX = 0;
        int windowOrgY = 0;
        int ihBrush = Integer.MIN_VALUE;
        int ihFont = -2147483635;
        int ihPalette = -2147483633;
        int ihPen = -2147483641;

        GDIState() {
        }
    }

    public class RandomAccessMemoryFile
    extends OutputStream {
        private static final int blockSize = 32768;
        private byte[] buffer = new byte[32768];
        private int currentOffset = 0;

        private void ensureCapacity(int size) {
            if (this.buffer.length <= size) {
                int newSize = (size / 32768 + 1) * 32768;
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
        }

        public void seek(long pos) throws IOException {
            if (pos > Integer.MAX_VALUE) {
                throw new IOException();
            }
            this.currentOffset = (int)pos;
        }

        public long getFilePointer() throws IOException {
            return this.currentOffset;
        }

        public void write(int b) throws IOException {
            this.ensureCapacity(this.currentOffset + 1);
            RawData.Int8ToData(b, this.buffer, this.currentOffset);
            ++this.currentOffset;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureCapacity(this.currentOffset + len);
            System.arraycopy(b, off, this.buffer, this.currentOffset, len);
            this.currentOffset += len;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void writeBoolean(boolean v) throws IOException {
            this.write(v ? 1 : 0);
        }

        public void writeByte(int v) throws IOException {
            this.write(v);
        }

        public void writeShort(int v) throws IOException {
            this.ensureCapacity(this.currentOffset + 2);
            RawData.Int16ToData(v, this.buffer, this.currentOffset);
            this.currentOffset += 2;
        }

        public void writeChar(int v) throws IOException {
            this.ensureCapacity(this.currentOffset + 2);
            RawData.Int16ToData(v, this.buffer, this.currentOffset);
            this.currentOffset += 2;
        }

        public void writeInt(int v) throws IOException {
            this.ensureCapacity(this.currentOffset + 4);
            RawData.Int32ToData(v, this.buffer, this.currentOffset);
            this.currentOffset += 4;
        }

        public void writeLong(long v) throws IOException {
            this.ensureCapacity(this.currentOffset + 8);
            RawData.Int64ToData(v, this.buffer, this.currentOffset);
            this.currentOffset += 8;
        }

        public void writeFloat(float v) throws IOException {
            this.writeInt(Float.floatToIntBits(v));
        }

        public void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        public void writeChars(String s) throws IOException {
            int clen = s.length();
            int blen = 2 * clen;
            byte[] b = new byte[blen];
            char[] c = new char[clen];
            s.getChars(0, clen, c, 0);
            int j = 0;
            for (int i = 0; i < clen; ++i) {
                RawData.Int16ToData(c[i], b, j);
                j += 2;
            }
            this.write(b, 0, blen);
        }

        public void writeBytes(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeUTF(String str) throws IOException {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buffer, 0, this.currentOffset);
        }
    }

    public static class RawData {
        public static final int BYTE_SIZE = 1;
        public static final int SHORT_SIZE = 2;
        public static final int INT_SIZE = 4;
        public static final int LONG_SIZE = 8;
        public static final int FLOAT_SIZE = 4;
        public static final int DOUBLE_SIZE = 8;
        public static final int CHAR_SIZE = 2;
        public static final int MAX_UNSIGNED_BYTE_VALUE = 255;
        public static final int MAX_UNSIGNED_SHORT_VALUE = 65535;
        public static final long MAX_UNSIGNED_INT_VALUE = -1L;

        private RawData() {
        }

        public static int Int8sFromData(byte[] data, int offset) {
            return data[offset];
        }

        public static int Int8uFromData(byte[] data, int offset) {
            return data[offset] & 0xFF;
        }

        public static int Int16sFromData(byte[] data, int offset) {
            return data[offset + 1] & 0xFF | data[offset] << 8;
        }

        public static int Int16uFromData(byte[] data, int offset) {
            return data[offset + 1] & 0xFF | (data[offset] & 0xFF) << 8;
        }

        public static int Int32sFromData(byte[] data, int offset) {
            return data[offset + 3] & 0xFF | (data[offset + 2] & 0xFF) << 8 | (data[offset + 1] & 0xFF) << 16 | data[offset] << 24;
        }

        public static long Int32uFromData(byte[] data, int offset) {
            return (long)RawData.Int32sFromData(data, offset) & 0xFFFFFFFFL;
        }

        public static long Int64sFromData(byte[] data, int offset) {
            int h = data[offset] << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
            int l = data[offset + 4] << 24 | (data[offset + 5] & 0xFF) << 16 | (data[offset + 6] & 0xFF) << 8 | data[offset + 7] & 0xFF;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }

        public static char charFromData(byte[] data, int offset) {
            return (char)(data[offset + 1] & 0xFF | data[offset] << 8);
        }

        public static float FloatFromData(byte[] data, int offset) {
            return Float.intBitsToFloat(RawData.Int32sFromData(data, offset));
        }

        public static double DoubleFromData(byte[] data, int offset) {
            return Double.longBitsToDouble(RawData.Int64sFromData(data, offset));
        }

        public static void Int8ToData(int value, byte[] data, int offset) {
            data[offset] = (byte)value;
        }

        public static void Int16ToData(int value, byte[] data, int offset) {
            data[offset + 1] = (byte)value;
            data[offset] = (byte)(value >> 8);
        }

        public static void Int32ToData(int value, byte[] data, int offset) {
            data[offset + 3] = (byte)value;
            data[offset + 2] = (byte)(value >> 8);
            data[offset + 1] = (byte)(value >> 16);
            data[offset] = (byte)(value >> 24);
        }

        public static void Int32uToData(long value, byte[] data, int offset) {
            RawData.Int32ToData((int)value, data, offset);
        }

        public static void Int64ToData(long value, byte[] data, int offset) {
            int l = (int)value;
            int h = (int)(value >> 32);
            data[offset] = (byte)(h >> 24);
            data[offset + 1] = (byte)(h >> 16);
            data[offset + 2] = (byte)(h >> 8);
            data[offset + 3] = (byte)h;
            data[offset + 4] = (byte)(l >> 24);
            data[offset + 5] = (byte)(l >> 16);
            data[offset + 6] = (byte)(l >> 8);
            data[offset + 7] = (byte)l;
        }

        public static void charToData(char value, byte[] data, int offset) {
            data[offset + 1] = (byte)value;
            data[offset] = (byte)(value >> 8);
        }

        public static void FloatToData(float value, byte[] data, int offset) {
            RawData.Int32ToData(Float.floatToIntBits(value), data, offset);
        }

        public static void DoubleToData(double value, byte[] data, int offset) {
            RawData.Int64ToData(Double.doubleToLongBits(value), data, offset);
        }
    }
}

