/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.converter.JdbcCharacterConverters;

public class I18CharacterConvertersWrapper
implements JdbcCharacterConverters {
    CharacterConverter wrapper;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public I18CharacterConvertersWrapper(CharacterConverter _wrapper) {
        this.wrapper = _wrapper;
    }

    public int getGroupId() {
        return this.wrapper.getGroupId();
    }

    public int getOracleId() {
        return this.wrapper.getOracleId();
    }

    public char[] getLeadingCodes() {
        return this.wrapper.getLeadingCodes();
    }

    public String toUnicodeString(byte[] b2, int i2, int j2) throws SQLException {
        return this.wrapper.toUnicodeString(b2, i2, j2);
    }

    public String toUnicodeStringWithReplacement(byte[] b2, int i2, int j2) {
        return this.wrapper.toUnicodeStringWithReplacement(b2, i2, j2);
    }

    public byte[] toOracleString(String x) throws SQLException {
        return this.wrapper.toOracleString(x);
    }

    public byte[] toOracleStringWithReplacement(String x) {
        return this.wrapper.toOracleStringWithReplacement(x);
    }

    public void buildUnicodeToOracleMapping() {
        this.wrapper.buildUnicodeToOracleMapping();
    }

    public void extractCodepoints(Vector x) {
        this.wrapper.extractCodepoints(x);
    }

    public void extractExtraMappings(Vector x) {
        this.wrapper.extractExtraMappings(x);
    }

    public boolean hasExtraMappings() {
        return this.wrapper.hasExtraMappings();
    }

    public char getOraChar1ByteRep() {
        return this.wrapper.getOraChar1ByteRep();
    }

    public char getOraChar2ByteRep() {
        return this.wrapper.getOraChar2ByteRep();
    }

    public int getUCS2CharRep() {
        return this.wrapper.getUCS2CharRep();
    }

    public int toUnicodeChars(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count) throws SQLException {
        return this.wrapper.toUnicodeCharsWithReplacement(srcChar, offset, dstChar, dstOffset, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql.converter");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.converter.I18CharacterConvertersWrapper"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

