/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibServer;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMPTZ;

public class DATE
extends Datum {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    public DATE() {
        super(DATE._initDate());
    }

    public DATE(byte[] date) {
        super(date);
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
    }

    public DATE(Date date, Calendar cal) {
        super(DATE.toBytes(date, cal));
    }

    public DATE(Time time, Calendar cal) {
        super(DATE.toBytes(time, cal));
    }

    public DATE(Timestamp timestamp, Calendar cal) {
        super(DATE.toBytes(timestamp, cal));
    }

    public DATE(String str) {
        super(DATE.toBytes(str));
    }

    public DATE(String str, boolean lenient) throws ParseException {
        super(DATE.toBytes(str));
        if (!lenient) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            java.util.Date tempDate = simpleDateFormat.parse(str);
        }
    }

    public DATE(String str, Calendar cal) {
        super(DATE.toBytes(str, cal));
    }

    public DATE(Object obj) throws SQLException {
        if (obj instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)obj));
        } else if (obj instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)obj));
        } else if (obj instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)obj));
        } else if (obj instanceof String) {
            this.setShareBytes(DATE.toBytes((String)obj));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(Object obj, Calendar cal) throws SQLException {
        if (obj instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)obj, cal));
        } else if (obj instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)obj, cal));
        } else if (obj instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)obj, cal));
        } else if (obj instanceof String) {
            this.setShareBytes(DATE.toBytes((String)obj, cal));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static Date toDate(byte[] date) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        int year = (result[0] - 100) * 100 + (result[1] - 100);
        int javaYear = year - 1900;
        if (year <= 0) {
            ++javaYear;
        }
        return new Date(javaYear, result[2] - 1, result[3]);
    }

    public static Time toTime(byte[] date) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        return new Time(result[4] - 1, result[5] - 1, result[6] - 1);
    }

    public static Timestamp toTimestamp(byte[] date) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        int year = (result[0] - 100) * 100 + (result[1] - 100);
        int javaYear = year - 1900;
        if (year <= 0) {
            ++javaYear;
        }
        return new Timestamp(javaYear, result[2] - 1, result[3], result[4] - 1, result[5] - 1, result[6] - 1, 0);
    }

    public static Date toDate(byte[] date, Calendar cal) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        int year = (result[0] - 100) * 100 + (result[1] - 100);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date newDate = new Date(cal.getTime().getTime());
        return newDate;
    }

    public static Time toTime(byte[] date, Calendar cal) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        Time newTime = new Time(cal.getTime().getTime());
        return newTime;
    }

    public static Timestamp toTimestamp(byte[] date, Calendar cal) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = date[i2] & 0xFF;
        }
        int year = (result[0] - 100) * 100 + (result[1] - 100);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        Timestamp newTimestamp = new Timestamp(cal.getTime().getTime());
        return newTimestamp;
    }

    public static String toString(byte[] bytes) {
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = bytes[i2] < 0 ? bytes[i2] + 256 : bytes[i2];
        }
        int year = (result[0] - 100) * 100 + (result[1] - 100);
        int month = result[2];
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        int nanos = -1;
        return TIMESTAMPTZ.toString(year, month, day, hours, minutes, seconds, -1, null);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Date date) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(date));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[7];
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -year;
            }
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.SEVERE, "         Throwing IllegalArgumentException: Invalid year value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Invalid year value");
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = 1;
            result[5] = 1;
            result[6] = 1;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] result = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        result[0] = 119;
        result[1] = -86;
        result[2] = 1;
        result[3] = 1;
        result[4] = (byte)(cal.get(11) + 1);
        result[5] = (byte)(cal.get(12) + 1);
        result[6] = (byte)(cal.get(13) + 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Timestamp timestamp) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(timestamp));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[7];
            Calendar cal = Calendar.getInstance();
            cal.setTime(timestamp);
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -year;
            }
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.SEVERE, "         Throwing IllegalArgumentException: Invalid year value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Invalid year value");
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Date date, Calendar cal) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(date) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.setTime(date);
            byte[] result = new byte[7];
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -year;
            }
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.SEVERE, "         Throwing IllegalArgumentException: Invalid year value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Invalid year value");
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = 1;
            result[5] = 1;
            result[6] = 1;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(Time time, Calendar cal) {
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(time);
        byte[] result = new byte[]{119, -86, 1, 1, (byte)(cal.get(11) + 1), (byte)(cal.get(12) + 1), (byte)(cal.get(13) + 1)};
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Timestamp timestamp, Calendar cal) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.setTime(timestamp);
            byte[] result = new byte[7];
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -year;
            }
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DATE.logger().log(Level.SEVERE, "         Throwing IllegalArgumentException: Invalid year value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Invalid year value");
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DATE.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(String str) {
        return DATE.toBytes(Timestamp.valueOf(str));
    }

    public static byte[] toBytes(String str, Calendar cal) {
        return DATE.toBytes(Timestamp.valueOf(str), cal);
    }

    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    public Timestamp timestampValue() {
        return DATE.toTimestamp(this.getBytes());
    }

    public Date dateValue(Calendar cal) {
        return DATE.toDate(this.getBytes(), cal);
    }

    public Time timeValue(Calendar cal) {
        return DATE.toTime(this.getBytes(), cal);
    }

    public Timestamp timestampValue(Calendar cal) {
        return DATE.toTimestamp(this.getBytes(), cal);
    }

    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    public Object toJdbc() {
        return this.timestampValue();
    }

    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0;
    }

    public DATE addJulianDays(int julianDay, int julianSec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), julianDay, julianSec));
    }

    public DATE addMonths(int months) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), months));
    }

    public void diffInJulianDays(DATE date, int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxsub(this.shareBytes(), date.shareBytes(), julianDay, julianSec);
    }

    public NUMBER diffInMonths(DATE date) throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), date.shareBytes()));
    }

    public static DATE getCurrentDate() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxgdt());
    }

    public static int checkValidity(byte[] date) throws SQLException {
        return DATE._getLdxLib().ldxchk(date);
    }

    public static DATE fromJulianDays(int julianDay, int julianSec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxdfd(julianDay, julianSec));
    }

    public static DATE fromText(String datestr, String fmt, String lang) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxstd(datestr, fmt, lang));
    }

    public DATE lastDayOfMonth() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
    }

    public static void numberToJulianDays(NUMBER num, int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxftd(num.toBytes(), julianDay, julianSec);
    }

    public DATE round(String prec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), prec));
    }

    public DATE setDayOfWeek(int day) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), day));
    }

    public void toJulianDays(int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxdtd(this.shareBytes(), julianDay, julianSec);
    }

    public NUMBER toNumber() throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
    }

    public String toText(String fmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), fmt, lang);
    }

    public String toText(byte[] pfmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), pfmt, lang);
    }

    public static byte[] parseFormat(String fmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxsto(fmt, lang);
    }

    public DATE truncate(String prec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), prec));
    }

    public int compareTo(DATE date) {
        return DATE.compareBytes(this.shareBytes(), date.shareBytes());
    }

    private static byte[] _initDate() {
        byte[] tmp = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return tmp;
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            try {
                _sldxlib = System.getProperty("oracle.jserver.version") != null ? new LdxLibServer() : new LdxLibThin();
            }
            catch (SecurityException e2) {
                _sldxlib = new LdxLibThin();
            }
        }
        return _sldxlib;
    }

    private static void _printBytes(byte[] date) {
        System.out.println(DATE.toString(date));
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.DATE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

